/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.manager.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.onlyoffice.manager.request.RequestManager;
import com.onlyoffice.manager.security.JwtManager;
import com.onlyoffice.manager.settings.SettingsManager;
import com.onlyoffice.manager.url.UrlManager;
import com.onlyoffice.model.common.RequestEntity;
import com.onlyoffice.model.common.RequestedService;
import com.onlyoffice.model.settings.HttpClientSettings;
import com.onlyoffice.model.settings.security.Security;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class DefaultRequestManager
implements RequestManager {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private UrlManager urlManager;
    private JwtManager jwtManager;
    private SettingsManager settingsManager;

    public DefaultRequestManager(UrlManager urlManager, JwtManager jwtManager, SettingsManager settingsManager) {
        this.urlManager = urlManager;
        this.jwtManager = jwtManager;
        this.settingsManager = settingsManager;
    }

    public UrlManager getUrlManager() {
        return this.urlManager;
    }

    public void setUrlManager(UrlManager urlManager) {
        this.urlManager = urlManager;
    }

    public JwtManager getJwtManager() {
        return this.jwtManager;
    }

    public void setJwtManager(JwtManager jwtManager) {
        this.jwtManager = jwtManager;
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    @Override
    public <R> R executeGetRequest(String url, RequestManager.Callback<R> callback) throws Exception {
        HttpClientSettings httpClientSettings = new HttpClientSettings();
        httpClientSettings.setIgnoreSSLCertificate(this.settingsManager.isIgnoreSSLCertificate());
        return this.executeGetRequest(url, httpClientSettings, callback);
    }

    @Override
    public <R> R executeGetRequest(String url, HttpClientSettings httpClientSettings, RequestManager.Callback<R> callback) throws Exception {
        HttpGet httpGet = new HttpGet(url);
        return this.executeRequest((HttpUriRequest)httpGet, httpClientSettings, callback);
    }

    @Override
    public <R> R executePostRequest(RequestedService requestedService, RequestEntity requestEntity, RequestManager.Callback<R> callback) throws Exception {
        Security security = new Security();
        security.setKey(this.settingsManager.getSecurityKey());
        security.setHeader(this.settingsManager.getSecurityHeader());
        security.setPrefix(this.settingsManager.getSecurityPrefix());
        String url = this.urlManager.getServiceUrl(requestedService);
        return this.executePostRequest(url, requestEntity, security, null, callback);
    }

    @Override
    public <R> R executePostRequest(RequestedService requestedService, RequestEntity requestEntity, HttpClientSettings httpClientSettings, RequestManager.Callback<R> callback) throws Exception {
        Security security = new Security();
        security.setKey(this.settingsManager.getSecurityKey());
        security.setHeader(this.settingsManager.getSecurityHeader());
        security.setPrefix(this.settingsManager.getSecurityPrefix());
        String url = this.urlManager.getServiceUrl(requestedService);
        return this.executePostRequest(url, requestEntity, security, httpClientSettings, callback);
    }

    @Override
    public <R> R executePostRequest(String url, RequestEntity requestEntity, Security security, HttpClientSettings httpClientSettings, RequestManager.Callback<R> callback) throws Exception {
        HttpPost request = this.createPostRequest(url, requestEntity, security);
        return this.executeRequest((HttpUriRequest)request, httpClientSettings, callback);
    }

    /*
     * Exception decompiling
     */
    private <R> R executeRequest(HttpUriRequest request, HttpClientSettings httpClientSettings, RequestManager.Callback<R> callback) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HttpPost createPostRequest(String url, RequestEntity requestEntity, Security security) throws JsonProcessingException {
        HttpPost request = new HttpPost(url);
        if (security.getKey() != null && !security.getKey().isEmpty()) {
            HashMap<String, RequestEntity> payloadMap = new HashMap<String, RequestEntity>();
            payloadMap.put("payload", requestEntity);
            String headerToken = this.jwtManager.createToken((Map)this.objectMapper.convertValue(payloadMap, Map.class), security.getKey());
            request.setHeader(security.getHeader(), security.getPrefix() + headerToken);
            String bodyToken = this.jwtManager.createToken(requestEntity, security.getKey());
            requestEntity.setToken(bodyToken);
        }
        StringEntity entity = new StringEntity(this.objectMapper.writeValueAsString((Object)requestEntity), ContentType.APPLICATION_JSON);
        request.setEntity((HttpEntity)entity);
        request.setHeader("Accept", "application/json");
        return request;
    }

    private CloseableHttpClient getHttpClient(HttpClientSettings httpClientSettings) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        CloseableHttpClient httpClient;
        Boolean ignoreSSLCertificate = this.settingsManager.isIgnoreSSLCertificate();
        Integer connectionTimeout = (int)TimeUnit.SECONDS.toMillis(this.settingsManager.getDocsIntegrationSdkProperties().getHttpClient().getConnectionTimeout());
        Integer connectionRequestTimeout = (int)TimeUnit.SECONDS.toMillis(this.settingsManager.getDocsIntegrationSdkProperties().getHttpClient().getConnectionRequestTimeout());
        Integer socketTimeout = (int)TimeUnit.SECONDS.toMillis(this.settingsManager.getDocsIntegrationSdkProperties().getHttpClient().getSocketTimeout());
        if (httpClientSettings != null) {
            if (httpClientSettings.getConnectionTimeout() != null) {
                connectionTimeout = httpClientSettings.getConnectionTimeout();
            }
            if (httpClientSettings.getConnectionRequestTimeout() != null) {
                connectionRequestTimeout = httpClientSettings.getConnectionRequestTimeout();
            }
            if (httpClientSettings.getSocketTimeout() != null) {
                socketTimeout = httpClientSettings.getSocketTimeout();
            }
            if (httpClientSettings.getIgnoreSSLCertificate() != null) {
                ignoreSSLCertificate = httpClientSettings.getIgnoreSSLCertificate();
            }
        }
        RequestConfig config = RequestConfig.custom().setConnectTimeout(connectionTimeout.intValue()).setConnectionRequestTimeout(connectionRequestTimeout.intValue()).setSocketTimeout(socketTimeout.intValue()).build();
        if (ignoreSSLCertificate.booleanValue()) {
            SSLContextBuilder builder = new SSLContextBuilder();
            builder.loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            });
            SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(builder.build(), new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory).setDefaultRequestConfig(config).build();
        } else {
            httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        }
        return httpClient;
    }
}

