/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.manager.security;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.onlyoffice.manager.security.JwtManager;
import com.onlyoffice.manager.security.jwt4.JWTCreator4;
import com.onlyoffice.manager.settings.SettingsManager;
import java.util.Base64;
import java.util.Map;

public class DefaultJwtManager
implements JwtManager {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private SettingsManager settingsManager;

    public DefaultJwtManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    @Override
    public String createToken(Object object) {
        Map payloadMap = (Map)this.objectMapper.convertValue(object, Map.class);
        return this.createToken(payloadMap, this.settingsManager.getSecurityKey());
    }

    @Override
    public String createToken(Object object, String key) {
        Map payloadMap = (Map)this.objectMapper.convertValue(object, Map.class);
        return this.createToken(payloadMap, key);
    }

    @Override
    public String createToken(Map<String, ?> payloadMap, String secret) {
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWTCreator4.builder().withPayload(payloadMap).sign(algorithm);
    }

    @Override
    public String verify(String token) {
        return this.verifyToken(token, this.settingsManager.getSecurityKey());
    }

    @Override
    public String verifyToken(String token, String key) {
        Algorithm algorithm = Algorithm.HMAC256((String)key);
        Base64.Decoder decoder = Base64.getUrlDecoder();
        DecodedJWT jwt = JWT.require((Algorithm)algorithm).acceptLeeway(this.settingsManager.getDocsIntegrationSdkProperties().getDocumentServer().getSecurity().getLeeway().longValue()).build().verify(token);
        return new String(decoder.decode(jwt.getPayload()));
    }
}

