/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.manager.security.jwt4;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.onlyoffice.manager.security.jwt4.ClaimsHolder;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class ClaimsSerializer<T extends ClaimsHolder>
extends StdSerializer<T> {
    public ClaimsSerializer(Class<T> t) {
        super(t);
    }

    private static void handleSerialization(Object value, JsonGenerator gen) throws IOException {
        if (value instanceof Date) {
            gen.writeNumber(ClaimsSerializer.dateToSeconds((Date)value));
        } else if (value instanceof Instant) {
            gen.writeNumber(ClaimsSerializer.instantToSeconds((Instant)value));
        } else if (value instanceof Map) {
            ClaimsSerializer.serializeMap((Map)value, gen);
        } else if (value instanceof List) {
            ClaimsSerializer.serializeList((List)value, gen);
        } else {
            gen.writeObject(value);
        }
    }

    private static void serializeMap(Map<?, ?> map, JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            gen.writeFieldName((String)entry.getKey());
            Object value = entry.getValue();
            ClaimsSerializer.handleSerialization(value, gen);
        }
        gen.writeEndObject();
    }

    private static void serializeList(List<?> list, JsonGenerator gen) throws IOException {
        gen.writeStartArray();
        for (Object entry : list) {
            ClaimsSerializer.handleSerialization(entry, gen);
        }
        gen.writeEndArray();
    }

    private static long instantToSeconds(Instant instant) {
        return instant.getEpochSecond();
    }

    private static long dateToSeconds(Date date) {
        return date.getTime() / 1000L;
    }

    public void serialize(T holder, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        for (Map.Entry<String, Object> entry : ((ClaimsHolder)holder).getClaims().entrySet()) {
            this.writeClaim(entry, gen);
        }
        gen.writeEndObject();
    }

    protected void writeClaim(Map.Entry<String, Object> entry, JsonGenerator gen) throws IOException {
        gen.writeFieldName(entry.getKey());
        ClaimsSerializer.handleSerialization(entry.getValue(), gen);
    }
}

