/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.manager.security.jwt4;

import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.SignatureGenerationException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.onlyoffice.manager.security.jwt4.HeaderClaimsHolder;
import com.onlyoffice.manager.security.jwt4.HeaderParams;
import com.onlyoffice.manager.security.jwt4.HeaderSerializer;
import com.onlyoffice.manager.security.jwt4.PayloadClaimsHolder;
import com.onlyoffice.manager.security.jwt4.PayloadSerializer;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JWTCreator4 {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final SimpleModule module = new SimpleModule();
    private final Algorithm algorithm;
    private final String headerJson;
    private final String payloadJson;

    private JWTCreator4(Algorithm algorithm, Map<String, Object> headerClaims, Map<String, Object> payloadClaims) throws JWTCreationException {
        this.algorithm = algorithm;
        try {
            this.headerJson = mapper.writeValueAsString((Object)new HeaderClaimsHolder(headerClaims));
            this.payloadJson = mapper.writeValueAsString((Object)new PayloadClaimsHolder(payloadClaims));
        }
        catch (JsonProcessingException e) {
            throw new JWTCreationException("Some of the Claims couldn't be converted to a valid JSON format.", (Throwable)e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private String sign() throws SignatureGenerationException {
        String header = Base64.getUrlEncoder().withoutPadding().encodeToString(this.headerJson.getBytes(StandardCharsets.UTF_8));
        String payload = Base64.getUrlEncoder().withoutPadding().encodeToString(this.payloadJson.getBytes(StandardCharsets.UTF_8));
        byte[] signatureBytes = this.algorithm.sign(header.getBytes(StandardCharsets.UTF_8), payload.getBytes(StandardCharsets.UTF_8));
        String signature = Base64.getUrlEncoder().withoutPadding().encodeToString(signatureBytes);
        return String.format("%s.%s.%s", header, payload, signature);
    }

    static {
        module.addSerializer(PayloadClaimsHolder.class, (JsonSerializer)new PayloadSerializer());
        module.addSerializer(HeaderClaimsHolder.class, (JsonSerializer)new HeaderSerializer());
        mapper.registerModule((Module)module);
        mapper.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, true);
    }

    public static class Builder {
        private final Map<String, Object> payloadClaims = new HashMap<String, Object>();
        private final Map<String, Object> headerClaims = new HashMap<String, Object>();

        Builder() {
        }

        private static boolean validateClaim(Map<?, ?> map) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Object value = entry.getValue();
                if (!Builder.isSupportedType(value)) {
                    return false;
                }
                if (entry.getKey() != null && entry.getKey() instanceof String) continue;
                return false;
            }
            return true;
        }

        private static boolean validateClaim(List<?> list) {
            for (Object object : list) {
                if (Builder.isSupportedType(object)) continue;
                return false;
            }
            return true;
        }

        private static boolean isSupportedType(Object value) {
            if (value instanceof List) {
                return Builder.validateClaim((List)value);
            }
            return value instanceof Map ? Builder.validateClaim((Map)value) : Builder.isBasicType(value);
        }

        private static boolean isBasicType(Object value) {
            if (value == null) {
                return true;
            }
            Class<?> c = value.getClass();
            if (c.isArray()) {
                return c == Integer[].class || c == Long[].class || c == String[].class;
            }
            return c == String.class || c == Integer.class || c == Long.class || c == Double.class || c == Date.class || c == Instant.class || c == Boolean.class;
        }

        public Builder withKeyId(String keyId) {
            this.headerClaims.put(HeaderParams.KEY_ID, keyId);
            return this;
        }

        public Builder withPayload(Map<String, ?> payloadClaims) throws IllegalArgumentException {
            if (payloadClaims == null) {
                return this;
            }
            if (!this.validatePayload(payloadClaims)) {
                throw new IllegalArgumentException("Claim values must only be of types Map, List, Boolean, Integer, Long, Double, String, Date, Instant, and Null");
            }
            for (Map.Entry<String, ?> entry : payloadClaims.entrySet()) {
                this.addClaim(entry.getKey(), entry.getValue());
            }
            return this;
        }

        private boolean validatePayload(Map<String, ?> payload) {
            for (Map.Entry<String, ?> entry : payload.entrySet()) {
                String key = entry.getKey();
                this.assertNonNull(key);
                Object value = entry.getValue();
                if (value instanceof List && !Builder.validateClaim((List)value)) {
                    return false;
                }
                if (value instanceof Map && !Builder.validateClaim((Map)value)) {
                    return false;
                }
                if (Builder.isSupportedType(value)) continue;
                return false;
            }
            return true;
        }

        public String sign(Algorithm algorithm) throws IllegalArgumentException, JWTCreationException {
            String signingKeyId;
            if (algorithm == null) {
                throw new IllegalArgumentException("The Algorithm cannot be null.");
            }
            this.headerClaims.put(HeaderParams.ALGORITHM, algorithm.getName());
            if (!this.headerClaims.containsKey(HeaderParams.TYPE)) {
                this.headerClaims.put(HeaderParams.TYPE, "JWT");
            }
            if ((signingKeyId = algorithm.getSigningKeyId()) != null) {
                this.withKeyId(signingKeyId);
            }
            return new JWTCreator4(algorithm, this.headerClaims, this.payloadClaims).sign();
        }

        private void assertNonNull(String name) {
            if (name == null) {
                throw new IllegalArgumentException("The Custom Claim's name can't be null.");
            }
        }

        private void addClaim(String name, Object value) {
            this.payloadClaims.put(name, value);
        }
    }
}

