/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.manager.security.jwt4;

import com.fasterxml.jackson.core.JsonGenerator;
import com.onlyoffice.manager.security.jwt4.ClaimsSerializer;
import com.onlyoffice.manager.security.jwt4.PayloadClaimsHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PayloadSerializer
extends ClaimsSerializer<PayloadClaimsHolder> {
    private static final String AUDIENCE = "aud";

    public PayloadSerializer() {
        super(PayloadClaimsHolder.class);
    }

    @Override
    protected void writeClaim(Map.Entry<String, Object> entry, JsonGenerator gen) throws IOException {
        if (AUDIENCE.equals(entry.getKey())) {
            this.writeAudience(gen, entry);
        } else {
            super.writeClaim(entry, gen);
        }
    }

    private void writeAudience(JsonGenerator gen, Map.Entry<String, Object> e) throws IOException {
        if (e.getValue() instanceof String) {
            gen.writeFieldName(e.getKey());
            gen.writeString((String)e.getValue());
        } else {
            List<Object> audArray = new ArrayList();
            if (e.getValue() instanceof String[]) {
                audArray = Arrays.asList((String[])e.getValue());
            } else if (e.getValue() instanceof List) {
                for (Object e2 : (List)e.getValue()) {
                    if (!(e2 instanceof String)) continue;
                    audArray.add((String)e2);
                }
            }
            if (audArray.size() == 1) {
                gen.writeFieldName(e.getKey());
                gen.writeString((String)audArray.get(0));
            } else if (audArray.size() > 1) {
                gen.writeFieldName(e.getKey());
                gen.writeStartArray();
                for (String string : audArray) {
                    gen.writeString(string);
                }
                gen.writeEndArray();
            }
        }
    }
}

