/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.manager.settings;

import com.onlyoffice.manager.settings.SettingsManager;
import com.onlyoffice.model.documenteditor.config.editorconfig.Customization;
import com.onlyoffice.model.documenteditor.config.editorconfig.customization.Anonymous;
import com.onlyoffice.model.documenteditor.config.editorconfig.customization.Customer;
import com.onlyoffice.model.documenteditor.config.editorconfig.customization.Features;
import com.onlyoffice.model.documenteditor.config.editorconfig.customization.Goback;
import com.onlyoffice.model.documenteditor.config.editorconfig.customization.Logo;
import com.onlyoffice.model.documenteditor.config.editorconfig.customization.Review;
import com.onlyoffice.model.properties.DocsIntegrationSdkProperties;
import com.onlyoffice.model.settings.Settings;
import com.onlyoffice.model.settings.security.Security;
import com.onlyoffice.utils.ConfigurationUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DefaultSettingsManager
implements SettingsManager {
    @Override
    public abstract String getSetting(String var1);

    @Override
    public abstract void setSetting(String var1, String var2);

    @Override
    public Map<String, String> getSettings() throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        Settings settings = new Settings();
        settings.setSecurity(new Security());
        Customization customization = new Customization();
        customization.setGoback(new Goback());
        customization.setAnonymous(new Anonymous());
        customization.setCustomer(new Customer());
        customization.setFeatures(new Features());
        customization.setLogo(new Logo());
        customization.setReview(new Review());
        settings.setCustomization(customization);
        List<String> namesSettings = this.getNamesSettings(settings);
        HashMap<String, String> settinsMap = new HashMap<String, String>();
        for (String name : namesSettings) {
            settinsMap.put(name, this.getSetting(name));
        }
        return settinsMap;
    }

    @Override
    public void setSettings(Settings settings) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        Map<String, String> mapSettings = this.convertObjectToDotNotationMap(settings);
        for (Map.Entry<String, String> setting : mapSettings.entrySet()) {
            this.setSetting(setting.getKey(), setting.getValue());
        }
    }

    @Override
    public Boolean getSettingBoolean(String name, Boolean defaultValue) {
        String setting = this.getSetting(name);
        if (setting == null || setting.isEmpty()) {
            return defaultValue;
        }
        return Boolean.parseBoolean(setting);
    }

    @Override
    public DocsIntegrationSdkProperties getDocsIntegrationSdkProperties() {
        return ConfigurationUtils.getDocsIntegrationSdkProperties();
    }

    @Override
    public Boolean isSecurityEnabled() {
        String key = this.getSecurityKey();
        return key != null && !key.isEmpty();
    }

    @Override
    public String getSecurityKey() {
        if (this.isDemoActive().booleanValue()) {
            return ConfigurationUtils.getDemoDocumentServerProperties().getSecurity().getKey();
        }
        String key = this.getSetting("security.key");
        if (key == null || key.isEmpty()) {
            key = this.getDocsIntegrationSdkProperties().getDocumentServer().getSecurity().getKey();
        }
        if (key != null && !key.isEmpty()) {
            return key;
        }
        return null;
    }

    @Override
    public String getSecurityHeader() {
        if (this.isDemoActive().booleanValue()) {
            return ConfigurationUtils.getDemoDocumentServerProperties().getSecurity().getHeader();
        }
        String header = this.getSetting("security.header");
        if (header == null || header.isEmpty()) {
            header = this.getDocsIntegrationSdkProperties().getDocumentServer().getSecurity().getHeader();
        }
        if (header != null && !header.isEmpty()) {
            return header;
        }
        return null;
    }

    @Override
    public String getSecurityPrefix() {
        if (this.isDemoActive().booleanValue()) {
            return ConfigurationUtils.getDemoDocumentServerProperties().getSecurity().getPrefix();
        }
        String prefix = this.getSetting("security.prefix");
        if (prefix == null || prefix.isEmpty()) {
            prefix = this.getDocsIntegrationSdkProperties().getDocumentServer().getSecurity().getPrefix();
        }
        if (prefix != null && !prefix.isEmpty()) {
            return prefix;
        }
        return "";
    }

    @Override
    public Boolean isIgnoreSSLCertificate() {
        if (!this.isDemoActive().booleanValue()) {
            String ignoreSSLCertificateString = this.getSetting("ignoreSSLCertificate");
            if (ignoreSSLCertificateString != null && !ignoreSSLCertificateString.isEmpty()) {
                return Boolean.parseBoolean(ignoreSSLCertificateString);
            }
            Boolean ignoreSSLCertificate = this.getDocsIntegrationSdkProperties().getHttpClient().getIgnoreSslCertificate();
            if (ignoreSSLCertificate != null) {
                return ignoreSSLCertificate;
            }
        }
        return false;
    }

    @Override
    public Boolean enableDemo() {
        this.setSetting("demo", "true");
        String demoStart = this.getSetting("demo-start");
        if (demoStart == null || demoStart.isEmpty()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date date = new Date();
            this.setSetting("demo-start", dateFormat.format(date));
            return true;
        }
        return false;
    }

    @Override
    public void disableDemo() {
        this.setSetting("demo", "false");
    }

    @Override
    public Boolean isDemoActive() {
        String demo = this.getSetting("demo");
        if (demo == null || demo.isEmpty()) {
            return false;
        }
        Boolean isDemo = Boolean.parseBoolean(demo);
        String demoStart = this.getSetting("demo-start");
        if (demoStart != null && !demoStart.isEmpty() && isDemo.booleanValue()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            try {
                Calendar date = Calendar.getInstance();
                date.setTime(dateFormat.parse(demoStart));
                date.add(5, ConfigurationUtils.getDemoTrialPeriod());
                return date.after(Calendar.getInstance());
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public Boolean isDemoAvailable() {
        String demoStart = this.getSetting("demo-start");
        if (demoStart != null && !demoStart.isEmpty()) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            try {
                Calendar date = Calendar.getInstance();
                date.setTime(dateFormat.parse(demoStart));
                date.add(5, ConfigurationUtils.getDemoTrialPeriod());
                return date.after(Calendar.getInstance());
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    protected <T> Map<String, String> convertObjectToDotNotationMap(T object) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        Class<?> beanClass = object.getClass();
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
        HashMap<String, String> result = new HashMap<String, String>();
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            String name = propertyDescriptor.getName();
            Object value = propertyDescriptor.getReadMethod().invoke(object, new Object[0]);
            if (value == null || name.equals("class")) continue;
            if (value.toString().startsWith("com.onlyoffice.model")) {
                for (Map.Entry<String, String> map : this.convertObjectToDotNotationMap(value).entrySet()) {
                    result.put(name + "." + map.getKey(), map.getValue());
                }
                continue;
            }
            result.put(name, value.toString());
        }
        return result;
    }

    protected <T> List<String> getNamesSettings(T object) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        Class<?> beanClass = object.getClass();
        BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
        ArrayList<String> result = new ArrayList<String>();
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            String name = propertyDescriptor.getName();
            Object value = propertyDescriptor.getReadMethod().invoke(object, new Object[0]);
            if (name.equals("class")) continue;
            if (value != null && value.toString().startsWith("com.onlyoffice.model")) {
                for (String name1 : this.getNamesSettings(value)) {
                    result.add(name + "." + name1);
                }
                continue;
            }
            result.add(name);
        }
        return result;
    }
}

