/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.model.settings.validation;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.onlyoffice.model.common.Error;
import com.onlyoffice.model.settings.validation.status.Status;

@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
public class ValidationResult {
    private Status status;
    private Error error;
    private String message;

    private ValidationResult(Builder builder) {
        this.status = builder.status;
        this.error = builder.error;
        this.message = builder.message;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Status getStatus() {
        return this.status;
    }

    public Error getError() {
        return this.error;
    }

    public String getMessage() {
        return this.message;
    }

    public static class Builder {
        private Status status;
        private Error error;
        private String message;

        private Builder() {
        }

        public Builder status(Status status) {
            this.status = status;
            return this;
        }

        public Builder error(Error error) {
            this.error = error;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public ValidationResult build() {
            return new ValidationResult(this);
        }
    }
}

