/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.service.convert;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.onlyoffice.manager.document.DocumentManager;
import com.onlyoffice.manager.request.RequestManager;
import com.onlyoffice.manager.settings.SettingsManager;
import com.onlyoffice.manager.url.UrlManager;
import com.onlyoffice.model.common.RequestedService;
import com.onlyoffice.model.convertservice.ConvertRequest;
import com.onlyoffice.model.convertservice.ConvertResponse;
import com.onlyoffice.model.convertservice.convertrequest.Thumbnail;
import com.onlyoffice.model.settings.HttpClientSettings;
import com.onlyoffice.service.convert.ConvertService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;

public class DefaultConvertService
implements ConvertService,
RequestedService {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private DocumentManager documentManager;
    private UrlManager urlManager;
    private RequestManager requestManager;
    private SettingsManager settingsManager;

    public DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public void setDocumentManager(DocumentManager documentManager) {
        this.documentManager = documentManager;
    }

    public UrlManager getUrlManager() {
        return this.urlManager;
    }

    public void setUrlManager(UrlManager urlManager) {
        this.urlManager = urlManager;
    }

    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    public void setRequestManager(RequestManager requestManager) {
        this.requestManager = requestManager;
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    @Override
    public ConvertResponse processConvert(ConvertRequest convertRequest, String bucket, String fileId) throws Exception {
        String fileName = this.documentManager.getDocumentName(bucket, fileId);
        if (convertRequest.getFiletype() == null || convertRequest.getFiletype().isEmpty()) {
            convertRequest.setFiletype(this.documentManager.getExtension(fileName));
        }
        if (convertRequest.getKey() == null || convertRequest.getKey().isEmpty()) {
            convertRequest.setKey(this.documentManager.getDocumentKey(bucket, fileId, false));
        }
        if (convertRequest.getOutputtype() == null || convertRequest.getOutputtype().isEmpty()) {
            convertRequest.setOutputtype(this.documentManager.getDefaultConvertExtension(fileName));
        }
        if (convertRequest.getTitle() == null || convertRequest.getTitle().isEmpty()) {
            convertRequest.setTitle(this.documentManager.getBaseName(fileName) + "." + convertRequest.getOutputtype());
        }
        if (convertRequest.getUrl() == null || convertRequest.getUrl().isEmpty()) {
            convertRequest.setUrl(this.urlManager.getFileUrl(bucket, fileId));
        }
        if (Arrays.asList("bmp", "gif", "jpg", "png").contains(convertRequest.getOutputtype()) && convertRequest.getThumbnail() == null) {
            Thumbnail thumbnail = new Thumbnail();
            thumbnail.setFirst(false);
            convertRequest.setThumbnail(thumbnail);
        }
        Integer socketTimeout = (int)TimeUnit.SECONDS.toMillis(this.settingsManager.getDocsIntegrationSdkProperties().getDocumentServer().getConvertService().getSyncSocketTimeout());
        HttpClientSettings httpClientSettings = null;
        if (convertRequest.getAsync() == null || !convertRequest.getAsync().booleanValue()) {
            httpClientSettings = new HttpClientSettings();
            httpClientSettings.setSocketTimeout(socketTimeout);
        }
        return this.requestManager.executePostRequest(this, convertRequest, httpClientSettings, new RequestManager.Callback<ConvertResponse>(){

            @Override
            public ConvertResponse doWork(Object response) throws IOException {
                String content = IOUtils.toString((InputStream)((HttpEntity)response).getContent(), (String)"utf-8");
                ConvertResponse convertResponse = (ConvertResponse)DefaultConvertService.this.objectMapper.readValue(content.toString(), ConvertResponse.class);
                return convertResponse;
            }
        });
    }
}

