/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.service.documenteditor.config;

import com.onlyoffice.manager.document.DocumentManager;
import com.onlyoffice.manager.security.JwtManager;
import com.onlyoffice.manager.settings.SettingsManager;
import com.onlyoffice.manager.url.UrlManager;
import com.onlyoffice.model.common.User;
import com.onlyoffice.model.documenteditor.Config;
import com.onlyoffice.model.documenteditor.config.Document;
import com.onlyoffice.model.documenteditor.config.EditorConfig;
import com.onlyoffice.model.documenteditor.config.document.DocumentType;
import com.onlyoffice.model.documenteditor.config.document.Info;
import com.onlyoffice.model.documenteditor.config.document.Permissions;
import com.onlyoffice.model.documenteditor.config.document.ReferenceData;
import com.onlyoffice.model.documenteditor.config.document.Type;
import com.onlyoffice.model.documenteditor.config.editorconfig.CoEditing;
import com.onlyoffice.model.documenteditor.config.editorconfig.Customization;
import com.onlyoffice.model.documenteditor.config.editorconfig.Embedded;
import com.onlyoffice.model.documenteditor.config.editorconfig.Mode;
import com.onlyoffice.model.documenteditor.config.editorconfig.Plugins;
import com.onlyoffice.model.documenteditor.config.editorconfig.Recent;
import com.onlyoffice.model.documenteditor.config.editorconfig.Template;
import com.onlyoffice.model.documenteditor.config.editorconfig.customization.Goback;
import com.onlyoffice.model.documenteditor.config.editorconfig.customization.Review;
import com.onlyoffice.model.documenteditor.config.editorconfig.customization.review.ReviewDisplay;
import com.onlyoffice.service.documenteditor.config.ConfigService;
import java.util.List;
import java.util.regex.Pattern;

public class DefaultConfigService
implements ConfigService {
    private DocumentManager documentManager;
    private UrlManager urlManager;
    private JwtManager jwtManager;
    private SettingsManager settingsManager;

    public DefaultConfigService(DocumentManager documentManager, UrlManager urlManager, JwtManager jwtManager, SettingsManager settingsManager) {
        this.documentManager = documentManager;
        this.urlManager = urlManager;
        this.jwtManager = jwtManager;
        this.settingsManager = settingsManager;
    }

    public DocumentManager getDocumentManager() {
        return this.documentManager;
    }

    public void setDocumentManager(DocumentManager documentManager) {
        this.documentManager = documentManager;
    }

    public UrlManager getUrlManager() {
        return this.urlManager;
    }

    public void setUrlManager(UrlManager urlManager) {
        this.urlManager = urlManager;
    }

    public JwtManager getJwtManager() {
        return this.jwtManager;
    }

    public void setJwtManager(JwtManager jwtManager) {
        this.jwtManager = jwtManager;
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    @Override
    public Config createConfig(String bucket, String fileId, Mode mode, String userAgent) {
        return this.createConfig(bucket, fileId, mode, this.getType(userAgent));
    }

    @Override
    public Config createConfig(String bucket, String fileId, Mode mode, Type type) {
        String documentName = this.documentManager.getDocumentName(bucket, fileId);
        DocumentType documentType = this.documentManager.getDocumentType(documentName);
        Document document = this.getDocument(bucket, fileId, type);
        EditorConfig editorConfig = this.getEditorConfig(bucket, fileId, mode, type);
        Config config = new Config();
        config.setWidth("100%");
        config.setHeight("100%");
        config.setType(type);
        config.setDocumentType(documentType);
        config.setDocument(document);
        config.setEditorConfig(editorConfig);
        if (this.settingsManager.isSecurityEnabled().booleanValue()) {
            config.setToken(this.jwtManager.createToken(config));
        }
        return config;
    }

    @Override
    public Document getDocument(String bucket, String fileId, Type type) {
        String documentName = this.documentManager.getDocumentName(bucket, fileId);
        Permissions permissions = this.getPermissions(bucket, fileId);
        Document document = new Document();
        document.setFileType(this.documentManager.getExtension(documentName));
        document.setKey(this.documentManager.getDocumentKey(bucket, fileId, type.equals((Object)Type.EMBEDDED)));
        document.setReferenceData(this.getReferenceData(bucket, fileId));
        document.setTitle(documentName);
        document.setUrl(this.urlManager.getFileUrl(bucket, fileId));
        document.setInfo(this.getInfo(bucket, fileId));
        document.setPermissions(permissions);
        return document;
    }

    @Override
    public EditorConfig getEditorConfig(String bucket, String fileId, Mode mode, Type type) {
        Permissions permissions = this.getPermissions(bucket, fileId);
        EditorConfig editorConfig = new EditorConfig();
        editorConfig.setCoEditing(this.getCoEditing(bucket, fileId, mode, type));
        editorConfig.setCreateUrl(this.urlManager.getCreateUrl(bucket, fileId));
        editorConfig.setMode(mode);
        editorConfig.setUser(this.getUser());
        editorConfig.setRecent(this.getRecent(null));
        editorConfig.setTemplates(this.getTemplates(bucket, fileId));
        editorConfig.setCustomization(this.getCustomization(bucket, fileId));
        editorConfig.setPlugins(this.getPlugins(null));
        if (permissions != null && (Boolean.TRUE.equals(permissions.getEdit()) || Boolean.TRUE.equals(permissions.getFillForms()) || Boolean.TRUE.equals(permissions.getComment()) || Boolean.TRUE.equals(permissions.getReview())) && mode.equals((Object)Mode.EDIT)) {
            editorConfig.setCallbackUrl(this.urlManager.getCallbackUrl(bucket, fileId));
        }
        if (type.equals((Object)Type.EMBEDDED)) {
            editorConfig.setEmbedded(this.getEmbedded(bucket, fileId));
        }
        return editorConfig;
    }

    @Override
    public ReferenceData getReferenceData(String bucket, String fileId) {
        return null;
    }

    @Override
    public Info getInfo(String bucket, String fileId) {
        return null;
    }

    @Override
    public Permissions getPermissions(String bucket, String fileId) {
        return null;
    }

    @Override
    public CoEditing getCoEditing(String bucket, String fileId, Mode mode, Type type) {
        return null;
    }

    @Override
    public List<Recent> getRecent(Object object) {
        return null;
    }

    @Override
    public List<Template> getTemplates(String bucket, String fileId) {
        return null;
    }

    @Override
    public User getUser() {
        return null;
    }

    @Override
    public Customization getCustomization(String bucket, String fileId) {
        Goback goback = new Goback();
        if (this.urlManager.getGobackUrl(bucket, fileId) != null) {
            goback.setUrl(this.urlManager.getGobackUrl(bucket, fileId));
        }
        Customization customization = new Customization();
        customization.setChat(this.settingsManager.getSettingBoolean("customization.chat", true));
        customization.setCompactHeader(this.settingsManager.getSettingBoolean("customization.compactHeader", false));
        customization.setFeedback(this.settingsManager.getSettingBoolean("customization.feedback", false));
        customization.setForcesave(this.settingsManager.getSettingBoolean("customization.forcesave", false));
        customization.setGoback(goback);
        customization.setHelp(this.settingsManager.getSettingBoolean("customization.help", true));
        customization.setToolbarNoTabs(this.settingsManager.getSettingBoolean("customization.toolbarNoTabs", false));
        String reviewDisplay = this.settingsManager.getSetting("customization.review.reviewDisplay");
        if (reviewDisplay == null || reviewDisplay.isEmpty()) {
            reviewDisplay = ReviewDisplay.ORIGINAL.name();
        }
        if (!reviewDisplay.equals("ORIGINAL")) {
            Review review = new Review();
            review.setReviewDisplay(ReviewDisplay.valueOf(reviewDisplay));
            customization.setReview(review);
        }
        return customization;
    }

    @Override
    public Embedded getEmbedded(String bucket, String fileId) {
        return null;
    }

    @Override
    public Plugins getPlugins(Object object) {
        return null;
    }

    @Override
    public Type getType(String userAgent) {
        Pattern pattern = Pattern.compile(this.settingsManager.getDocsIntegrationSdkProperties().getDocumentServer().getEditingService().getMobileUserAgent(), 10);
        if (userAgent != null && pattern.matcher(userAgent).find()) {
            return Type.MOBILE;
        }
        return Type.DESKTOP;
    }
}

