/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.service.settings;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.onlyoffice.manager.request.RequestManager;
import com.onlyoffice.manager.settings.SettingsManager;
import com.onlyoffice.manager.url.UrlManager;
import com.onlyoffice.model.commandservice.CommandRequest;
import com.onlyoffice.model.commandservice.CommandResponse;
import com.onlyoffice.model.commandservice.commandrequest.Command;
import com.onlyoffice.model.common.CommonResponse;
import com.onlyoffice.model.convertservice.ConvertRequest;
import com.onlyoffice.model.convertservice.ConvertResponse;
import com.onlyoffice.model.settings.HttpClientSettings;
import com.onlyoffice.model.settings.security.Security;
import com.onlyoffice.model.settings.validation.ValidationResult;
import com.onlyoffice.model.settings.validation.status.Status;
import com.onlyoffice.service.settings.SettingsValidationService;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class DefaultSettingsValidationService
implements SettingsValidationService {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private RequestManager requestManager;
    private UrlManager urlManager;
    private SettingsManager settingsManager;

    public DefaultSettingsValidationService(RequestManager requestManager, UrlManager urlManager, SettingsManager settingsManager) {
        this.requestManager = requestManager;
        this.urlManager = urlManager;
        this.settingsManager = settingsManager;
    }

    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    public void setRequestManager(RequestManager requestManager) {
        this.requestManager = requestManager;
    }

    public UrlManager getUrlManager() {
        return this.urlManager;
    }

    public void setUrlManager(UrlManager urlManager) {
        this.urlManager = urlManager;
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    @Override
    public ValidationResult checkDocumentServer() throws Exception {
        HttpClientSettings httpClientSettings = new HttpClientSettings();
        httpClientSettings.setIgnoreSSLCertificate(this.settingsManager.isIgnoreSSLCertificate());
        return this.checkDocumentServer(this.urlManager.getInnerDocumentServerUrl(), httpClientSettings);
    }

    @Override
    public ValidationResult checkDocumentServer(String url, HttpClientSettings httpClientSettings) throws Exception {
        String healthCheckUrl = this.settingsManager.getDocsIntegrationSdkProperties().getDocumentServer().getHealthCheckUrl();
        healthCheckUrl = this.urlManager.sanitizeUrl(url) + healthCheckUrl;
        return this.requestManager.executeGetRequest(healthCheckUrl, httpClientSettings, new RequestManager.Callback<ValidationResult>(){

            @Override
            public ValidationResult doWork(Object response) throws IOException {
                String content = IOUtils.toString((InputStream)((HttpEntity)response).getContent(), (String)"utf-8").trim();
                if (content.equalsIgnoreCase("true")) {
                    return ValidationResult.builder().status(Status.SUCCESS).build();
                }
                return ValidationResult.builder().status(Status.FAILED).error(CommonResponse.Error.HEALTHCHECK).build();
            }
        });
    }

    @Override
    public ValidationResult checkCommandService() throws Exception {
        String url = this.urlManager.getInnerDocumentServerUrl();
        Security security = new Security();
        security.setKey(this.settingsManager.getSecurityKey());
        security.setHeader(this.settingsManager.getSecurityHeader());
        security.setPrefix(this.settingsManager.getSecurityPrefix());
        HttpClientSettings httpClientSettings = new HttpClientSettings();
        httpClientSettings.setIgnoreSSLCertificate(this.settingsManager.isIgnoreSSLCertificate());
        return this.checkCommandService(url, security, httpClientSettings);
    }

    @Override
    public ValidationResult checkCommandService(String url, Security security, HttpClientSettings httpClientSettings) throws Exception {
        String commandServiceUrl = this.settingsManager.getDocsIntegrationSdkProperties().getDocumentServer().getCommandService().getUrl();
        CommandRequest commandRequest = new CommandRequest();
        commandRequest.setC(Command.VERSION);
        return this.requestManager.executePostRequest(this.urlManager.sanitizeUrl(url) + commandServiceUrl, commandRequest, security, httpClientSettings, new RequestManager.Callback<ValidationResult>(){

            @Override
            public ValidationResult doWork(Object response) throws IOException {
                String content = IOUtils.toString((InputStream)((HttpEntity)response).getContent(), (String)"utf-8");
                CommandResponse commandResponse = (CommandResponse)DefaultSettingsValidationService.this.objectMapper.readValue(content, CommandResponse.class);
                if (commandResponse.getError() != null && commandResponse.getError().equals(CommandResponse.Error.NO)) {
                    return ValidationResult.builder().status(Status.SUCCESS).build();
                }
                return ValidationResult.builder().status(Status.FAILED).error(commandResponse.getError()).build();
            }
        });
    }

    @Override
    public ValidationResult checkConvertService() throws Exception {
        String url = this.urlManager.getInnerDocumentServerUrl();
        Security security = new Security();
        security.setKey(this.settingsManager.getSecurityKey());
        security.setHeader(this.settingsManager.getSecurityHeader());
        security.setPrefix(this.settingsManager.getSecurityPrefix());
        HttpClientSettings httpClientSettings = new HttpClientSettings();
        httpClientSettings.setIgnoreSSLCertificate(this.settingsManager.isIgnoreSSLCertificate());
        return this.checkConvertService(url, null, security, httpClientSettings);
    }

    @Override
    public ValidationResult checkConvertService(String url, String productInnerUrl, Security security, final HttpClientSettings httpClientSettings) throws Exception {
        String convertServiceUrl = this.settingsManager.getDocsIntegrationSdkProperties().getDocumentServer().getConvertService().getUrl();
        ConvertRequest convertRequest = new ConvertRequest();
        convertRequest.setAsync(false);
        convertRequest.setFiletype("txt");
        convertRequest.setOutputtype("docx");
        convertRequest.setKey(new SimpleDateFormat("MMddyyyyHHmmss").format(new Date()));
        convertRequest.setUrl(this.urlManager.getTestConvertUrl(productInnerUrl));
        return this.requestManager.executePostRequest(this.urlManager.sanitizeUrl(url) + convertServiceUrl, convertRequest, security, httpClientSettings, new RequestManager.Callback<ValidationResult>(){

            @Override
            public ValidationResult doWork(Object response) throws Exception {
                String content = IOUtils.toString((InputStream)((HttpEntity)response).getContent(), (String)"utf-8").trim();
                JSONObject result = new JSONObject(content);
                if (result.has("error")) {
                    Integer errorCode = result.getInt("error");
                    return ValidationResult.builder().status(Status.FAILED).error(ConvertResponse.Error.valueOfCode(errorCode)).build();
                }
                String fileUrl = result.getString("fileUrl");
                return DefaultSettingsValidationService.this.requestManager.executeGetRequest(fileUrl, httpClientSettings, new RequestManager.Callback<ValidationResult>(){

                    @Override
                    public ValidationResult doWork(Object response) throws IOException {
                        byte[] bytes = EntityUtils.toByteArray((HttpEntity)((HttpEntity)response));
                        if (bytes.length > 0) {
                            return ValidationResult.builder().status(Status.SUCCESS).build();
                        }
                        return ValidationResult.builder().status(Status.FAILED).error(CommonResponse.Error.DOWNLOAD_RESULT).build();
                    }
                });
            }
        });
    }
}

