/*
 * Decompiled with CFR 0.152.
 */
package com.onlyoffice.utils;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsSchema;
import com.onlyoffice.model.properties.DocsIntegrationSdkProperties;
import com.onlyoffice.model.properties.docsintegrationsdk.DocumentServerProperties;
import com.onlyoffice.model.properties.docsintegrationsdk.documentserver.SecurityProperties;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public final class ConfigurationUtils {
    private static final String PROPERTIES_PREFIX = "onlyoffice-sdk";
    private static final String DEMO_URL = "https://onlinedocs.onlyoffice.com/";
    private static final String DEMO_SECURITY_HEADER = "AuthorizationJWT";
    private static final String DEMO_SECURITY_KEY = "sn2puSUF7muF5Jas";
    private static final String DEMO_SECURITY_PREFIX = "Bearer ";
    private static final Integer DEMO_TRIAL_PERIOD = 30;
    private static boolean isInit = false;
    private static DocsIntegrationSdkProperties docsIntegrationSdkProperties;

    private ConfigurationUtils() {
    }

    public static DocsIntegrationSdkProperties getDocsIntegrationSdkProperties() {
        if (!isInit) {
            ConfigurationUtils.init();
            isInit = true;
        }
        return docsIntegrationSdkProperties;
    }

    public static DocumentServerProperties getDemoDocumentServerProperties() {
        SecurityProperties securityProperties = new SecurityProperties();
        securityProperties.setHeader(DEMO_SECURITY_HEADER);
        securityProperties.setKey(DEMO_SECURITY_KEY);
        securityProperties.setPrefix(DEMO_SECURITY_PREFIX);
        DocumentServerProperties documentServerProperties = new DocumentServerProperties();
        documentServerProperties.setUrl(DEMO_URL);
        documentServerProperties.setSecurity(securityProperties);
        return documentServerProperties;
    }

    public static Integer getDemoTrialPeriod() {
        return DEMO_TRIAL_PERIOD;
    }

    private static void init() {
        Properties properties = new Properties();
        try {
            InputStream stream = ConfigurationUtils.class.getClassLoader().getResourceAsStream("onlyoffice-sdk.properties");
            properties.load(stream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        JavaPropsSchema javaPropsSchema = JavaPropsSchema.emptySchema().withPrefix(PROPERTIES_PREFIX);
        JavaPropsMapper javaPropsMapper = (JavaPropsMapper)((JavaPropsMapper.Builder)((JavaPropsMapper.Builder)JavaPropsMapper.builder().serializationInclusion(JsonInclude.Include.NON_NULL)).propertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE)).build();
        try {
            docsIntegrationSdkProperties = (DocsIntegrationSdkProperties)javaPropsMapper.readPropertiesAs(properties, javaPropsSchema, DocsIntegrationSdkProperties.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

