/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sdk.model;

import com.digiwin.sdk.exception.BusinessException;
import com.digiwin.sdk.exception.Status;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Result<T> {
    private static final Logger log = LoggerFactory.getLogger(Result.class);
    private Integer code;
    private String msg;
    private T data;

    public Result(Integer code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private Result(T data) {
        this.code = Status.SUCCESS.getCode();
        this.msg = Status.SUCCESS.getMsg();
        this.data = data;
    }

    private Result(String msg, T data) {
        this.code = Status.SUCCESS.getCode();
        this.msg = msg;
        this.data = data;
    }

    private Result(Status status) {
        if (status != null) {
            this.code = status.getCode();
            this.msg = status.getMsg();
        }
    }

    public static <T> Result<T> success(T data) {
        return new Result<T>(data);
    }

    public static <T> Result<T> success(String msg, T data) {
        return new Result<T>(msg, data);
    }

    public static <T> Result<T> success(Status status) {
        return new Result<T>(status);
    }

    public static Result success() {
        return new Result(Status.SUCCESS);
    }

    public static <T> Result<T> error(T data) {
        return new Result<T>(data);
    }

    public static Result error(Status status) {
        return new Result(status);
    }

    @Deprecated
    public static Result error(Integer code, String mes) {
        return new Result(code, mes);
    }

    public static Result error(BusinessException e) {
        return new Result(e.getCode(), e.getMessage());
    }

    public void checkSuccess(Status status) {
        if (!this.getCode().equals(Status.SUCCESS.getCode())) {
            log.error("check result error!msg: {}", (Object)this);
            throw new BusinessException(status);
        }
    }

    public static Result errorWithArgs(Status status, Object ... args) {
        return new Result(status.getCode(), MessageFormat.format(status.getMsg(), args));
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }
}

