/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sdk.config;

import com.digiwin.sdk.enums.DomainUrlEnum;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="custom.sdk")
public class SdkProperties {
    private String visitDsUrlMark;
    private String diyDsDomain = "https://hw-test-dmp-dmf.digiwincloud.com.cn";
    private int connectTimeout = 5000;
    private int readTimeout = 10000;
    private int maxRetries = 3;
    private long retryDelay = 1000L;
    private String retryableStatusCodes = "500,502,503,504";

    public String getDsHttp() {
        if (StringUtils.hasText((String)this.visitDsUrlMark)) {
            String domain = DomainUrlEnum.getValue(this.visitDsUrlMark);
            if (StringUtils.hasText((String)this.visitDsUrlMark)) {
                return domain;
            }
        }
        return this.diyDsDomain;
    }

    public String getVisitDsUrlMark() {
        return this.visitDsUrlMark;
    }

    public String getDiyDsDomain() {
        return this.diyDsDomain;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public long getRetryDelay() {
        return this.retryDelay;
    }

    public String getRetryableStatusCodes() {
        return this.retryableStatusCodes;
    }

    public void setVisitDsUrlMark(String visitDsUrlMark) {
        this.visitDsUrlMark = visitDsUrlMark;
    }

    public void setDiyDsDomain(String diyDsDomain) {
        this.diyDsDomain = diyDsDomain;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public void setRetryableStatusCodes(String retryableStatusCodes) {
        this.retryableStatusCodes = retryableStatusCodes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SdkProperties)) {
            return false;
        }
        SdkProperties other = (SdkProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$visitDsUrlMark = this.getVisitDsUrlMark();
        String other$visitDsUrlMark = other.getVisitDsUrlMark();
        if (this$visitDsUrlMark == null ? other$visitDsUrlMark != null : !this$visitDsUrlMark.equals(other$visitDsUrlMark)) {
            return false;
        }
        String this$diyDsDomain = this.getDiyDsDomain();
        String other$diyDsDomain = other.getDiyDsDomain();
        if (this$diyDsDomain == null ? other$diyDsDomain != null : !this$diyDsDomain.equals(other$diyDsDomain)) {
            return false;
        }
        if (this.getConnectTimeout() != other.getConnectTimeout()) {
            return false;
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        if (this.getMaxRetries() != other.getMaxRetries()) {
            return false;
        }
        if (this.getRetryDelay() != other.getRetryDelay()) {
            return false;
        }
        String this$retryableStatusCodes = this.getRetryableStatusCodes();
        String other$retryableStatusCodes = other.getRetryableStatusCodes();
        return !(this$retryableStatusCodes == null ? other$retryableStatusCodes != null : !this$retryableStatusCodes.equals(other$retryableStatusCodes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SdkProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $visitDsUrlMark = this.getVisitDsUrlMark();
        result = result * 59 + ($visitDsUrlMark == null ? 43 : $visitDsUrlMark.hashCode());
        String $diyDsDomain = this.getDiyDsDomain();
        result = result * 59 + ($diyDsDomain == null ? 43 : $diyDsDomain.hashCode());
        result = result * 59 + this.getConnectTimeout();
        result = result * 59 + this.getReadTimeout();
        result = result * 59 + this.getMaxRetries();
        long $retryDelay = this.getRetryDelay();
        result = result * 59 + (int)($retryDelay >>> 32 ^ $retryDelay);
        String $retryableStatusCodes = this.getRetryableStatusCodes();
        result = result * 59 + ($retryableStatusCodes == null ? 43 : $retryableStatusCodes.hashCode());
        return result;
    }

    public String toString() {
        return "SdkProperties(visitDsUrlMark=" + this.getVisitDsUrlMark() + ", diyDsDomain=" + this.getDiyDsDomain() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", maxRetries=" + this.getMaxRetries() + ", retryDelay=" + this.getRetryDelay() + ", retryableStatusCodes=" + this.getRetryableStatusCodes() + ")";
    }
}

