/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sdk.config;

import com.digiwin.sdk.config.SdkProperties;
import com.digiwin.sdk.exception.BusinessException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MimeType;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class ApiClient {
    private static final Logger log = LoggerFactory.getLogger(ApiClient.class);
    private final RestTemplate restTemplate;
    private final SdkProperties properties;
    private final Set<Integer> retryableStatusCodes = new HashSet<Integer>();
    private final HttpHeaders defaultHeaders = new HttpHeaders();

    public ApiClient(RestTemplate restTemplate, SdkProperties properties) {
        this.restTemplate = restTemplate;
        this.properties = properties;
        this.initRetryableStatusCodes();
        this.initDefaultHeaders();
    }

    private void initRetryableStatusCodes() {
        Arrays.stream(this.properties.getRetryableStatusCodes().split(",")).map(String::trim).map(Integer::parseInt).forEach(this.retryableStatusCodes::add);
    }

    private void initDefaultHeaders() {
        this.defaultHeaders.setContentType(MediaType.APPLICATION_JSON);
        this.defaultHeaders.set("X-SDK-Version", "1.0.0");
        this.defaultHeaders.set("User-Agent", "CustomSDK/1.0");
    }

    public Object get(String endpoint) {
        return this.get(endpoint, null);
    }

    public String get(String endpoint, HttpHeaders customHeaders) {
        return this.executeWithRetry(endpoint, HttpMethod.GET, null, customHeaders);
    }

    public String post(String endpoint, Object body) {
        return this.post(endpoint, body, null);
    }

    public String post(String endpoint, Object body, HttpHeaders customHeaders) {
        return this.executeWithRetry(endpoint, HttpMethod.POST, body, customHeaders);
    }

    private String executeWithRetry(String endpoint, HttpMethod method, Object body, HttpHeaders customHeaders) {
        int attempt;
        Throwable lastException = null;
        for (attempt = 0; attempt <= this.properties.getMaxRetries(); ++attempt) {
            try {
                return this.executeRequest(endpoint, method, body, customHeaders);
            }
            catch (HttpStatusCodeException e) {
                log.error("http\u8bf7\u6c42\u5f02\u5e38: ", (Object)e.getMessage(), (Object)e);
                lastException = e;
                if (!this.shouldRetry(e.getStatusCode().value())) {
                    break;
                }
            }
            catch (Exception e) {
                log.error("http\u8bf7\u6c42\u5f02\u5e38: ", (Object)e.getMessage(), (Object)e);
                lastException = e;
            }
            if (attempt >= this.properties.getMaxRetries()) continue;
            this.waitBeforeRetry(attempt);
        }
        throw new BusinessException("API request failed after " + attempt + " attempts", (Exception)lastException);
    }

    private String executeRequest(String url, HttpMethod method, Object body, HttpHeaders customHeaders) {
        if (!StringUtils.hasText((String)url)) {
            throw new BusinessException("api url is null");
        }
        HttpHeaders combinedHeaders = this.combineHeaders(customHeaders);
        HttpEntity entity = body != null ? new HttpEntity(body, (MultiValueMap)combinedHeaders) : new HttpEntity((MultiValueMap)combinedHeaders);
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a[{}], \u8bf7\u6c42\u4f53\uff1a[{}], \u8bf7\u6c42\u5934\uff1a[{}]", new Object[]{url, body != null ? body.toString() : "null", combinedHeaders});
        ResponseEntity response = this.restTemplate.exchange(url, method, entity, byte[].class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new BusinessException("API returned non-2xx status: " + response.getStatusCode());
        }
        byte[] responseBody = (byte[])response.getBody();
        HttpHeaders headers = response.getHeaders();
        if (this.isGzipCompressed(headers)) {
            try {
                responseBody = this.decompressGzip(responseBody);
            }
            catch (IOException e) {
                throw new RuntimeException("GZIP\u89e3\u538b\u5931\u8d25", e);
            }
        }
        Charset charset = this.getResponseCharset(headers);
        String result = new String(responseBody, charset);
        log.info("\u8bf7\u6c42\u5730\u5740\uff1a[{}], \u8fd4\u56de\u7684\u6570\u636e\uff1a[{}]", (Object)url, (Object)result);
        return result;
    }

    private boolean isGzipCompressed(HttpHeaders headers) {
        String contentEncoding = headers.getFirst("Content-Encoding");
        return contentEncoding != null && contentEncoding.toLowerCase().contains("gzip");
    }

    /*
     * Exception decompiling
     */
    private byte[] decompressGzip(byte[] compressedData) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Charset getResponseCharset(HttpHeaders headers) {
        return Optional.ofNullable(headers.getContentType()).map(MimeType::getCharset).orElse(StandardCharsets.UTF_8);
    }

    private HttpHeaders combineHeaders(HttpHeaders customHeaders) {
        HttpHeaders combined = new HttpHeaders();
        if (customHeaders != null) {
            customHeaders.forEach((headerName, headerValues) -> {
                combined.remove(headerName);
                headerValues.forEach(value -> combined.add(headerName, value));
            });
        } else {
            combined.addAll((MultiValueMap)this.defaultHeaders);
        }
        return combined;
    }

    private boolean shouldRetry(int statusCode) {
        return this.retryableStatusCodes.contains(statusCode);
    }

    private void waitBeforeRetry(int attempt) {
        try {
            long delay = (long)((double)this.properties.getRetryDelay() * Math.pow(2.0, attempt));
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new BusinessException("Retry wait interrupted", e);
        }
    }
}

