/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.sdk.config.ApiClient;
import com.digiwin.sdk.config.SdkProperties;
import com.digiwin.sdk.enums.ApiUrlEnum;
import com.digiwin.sdk.exception.BusinessException;
import com.digiwin.sdk.model.Result;
import com.digiwin.sdk.model.req.AppExternalDTO;
import com.digiwin.sdk.model.rsp.QueryIamAppList;
import com.digiwin.sdk.service.IamApiService;
import com.digiwin.sdk.util.SpringHeaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class IamApiServiceImpl
implements IamApiService {
    private static final Logger log = LoggerFactory.getLogger(IamApiServiceImpl.class);
    private final String DATA = "data";
    @Autowired
    private ApiClient apiClient;
    @Autowired
    private SdkProperties sdkProperties;

    @Override
    public Result<QueryIamAppList> queryIamAppList(AppExternalDTO appExternalDTO) {
        String url = this.sdkProperties.getDsHttp() + ApiUrlEnum.SEARCH_API_QUERY_IAM_INFO.getUrl();
        String result = this.apiClient.post(url, appExternalDTO, SpringHeaderUtil.getHeader());
        if (!StringUtils.hasText((String)result)) {
            throw new BusinessException("http request result is null");
        }
        JSONObject jsonObject = JSON.parseObject((String)result);
        String data = jsonObject.getString("data");
        if (!StringUtils.hasText((String)data)) {
            throw new BusinessException("http request result data is null");
        }
        QueryIamAppList projectList = (QueryIamAppList)JSON.parseObject((String)data, QueryIamAppList.class);
        return Result.success(projectList);
    }
}

