/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.sdk.config.ApiClient;
import com.digiwin.sdk.config.SdkProperties;
import com.digiwin.sdk.enums.ApiUrlEnum;
import com.digiwin.sdk.exception.BusinessException;
import com.digiwin.sdk.model.Result;
import com.digiwin.sdk.model.req.ProjectExternalDTO;
import com.digiwin.sdk.model.rsp.ProjectList;
import com.digiwin.sdk.service.ProjectApiService;
import com.digiwin.sdk.util.SpringHeaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ProjectApiServiceImpl
implements ProjectApiService {
    private static final Logger log = LoggerFactory.getLogger(ProjectApiServiceImpl.class);
    private final String DATA = "data";
    @Autowired
    private ApiClient apiClient;
    @Autowired
    private SdkProperties sdkProperties;

    @Override
    public Result<ProjectList> queryProjectListPaging(ProjectExternalDTO projectExternalDTO) {
        String url = this.sdkProperties.getDsHttp() + ApiUrlEnum.DS_API_PROJECTS_LIST_PAGING.getUrl();
        String result = this.apiClient.post(url, projectExternalDTO, SpringHeaderUtil.getHeader());
        if (!StringUtils.hasText((String)result)) {
            throw new BusinessException("http request result is null");
        }
        JSONObject jsonObject = JSON.parseObject((String)result);
        String data = jsonObject.getString("data");
        if (!StringUtils.hasText((String)data)) {
            throw new BusinessException("http request result data is null");
        }
        ProjectList projectList = (ProjectList)JSON.parseObject((String)data, ProjectList.class);
        return Result.success(projectList);
    }

    @Override
    public Result createProject(ProjectExternalDTO projectExternalDTO) {
        String url = this.sdkProperties.getDsHttp() + ApiUrlEnum.DS_API_PROJECTS_CREATE.getUrl();
        String result = this.apiClient.post(url, projectExternalDTO, SpringHeaderUtil.getHeader());
        if (!StringUtils.hasText((String)result)) {
            throw new BusinessException("http request result is null");
        }
        JSONObject jsonObject = JSON.parseObject((String)result);
        String data = jsonObject.getString("data");
        if (StringUtils.hasText((String)data)) {
            Integer id = jsonObject.getInteger("data");
            return Result.success(id);
        }
        return (Result)JSON.parseObject((String)result, Result.class);
    }

    @Override
    public Result updateProject(ProjectExternalDTO projectExternalDTO) {
        String url = this.sdkProperties.getDsHttp() + ApiUrlEnum.DS_API_PROJECTS_UPDATE.getUrl();
        String result = this.apiClient.post(url, projectExternalDTO, SpringHeaderUtil.getHeader());
        if (!StringUtils.hasText((String)result)) {
            throw new BusinessException("http request result is null");
        }
        return (Result)JSON.parseObject((String)result, Result.class);
    }

    @Override
    public Result deleteProject(ProjectExternalDTO projectExternalDTO) {
        String url = this.sdkProperties.getDsHttp() + ApiUrlEnum.DS_API_PROJECTS_DELETE.getUrl();
        String result = this.apiClient.post(url, projectExternalDTO, SpringHeaderUtil.getHeader());
        if (!StringUtils.hasText((String)result)) {
            throw new BusinessException("http request result is null");
        }
        return (Result)JSON.parseObject((String)result, Result.class);
    }
}

