/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sdk.util;

import java.util.Enumeration;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpHeaders;

public class HeaderUtils {
    public static HttpHeaders createHeaders() {
        return new HttpHeaders();
    }

    public static HttpHeaders createHeaders(String name, String value) {
        HttpHeaders headers = new HttpHeaders();
        headers.set(name, value);
        return headers;
    }

    public static HttpHeaders createHeaders(String name, String ... values) {
        HttpHeaders headers = new HttpHeaders();
        for (String value : values) {
            headers.add(name, value);
        }
        return headers;
    }

    public static HttpHeaders addHeader(HttpHeaders headers, String name, String value) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        headers.add(name, value);
        return headers;
    }

    public static HttpHeaders setHeader(HttpHeaders headers, String name, String value) {
        if (headers == null) {
            headers = new HttpHeaders();
        }
        headers.set(name, value);
        return headers;
    }

    public static HttpHeaders getHeader(HttpServletRequest request) {
        if (Objects.isNull(request)) {
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Enumeration headerValues = request.getHeaders(headerName);
                if (headerValues == null) continue;
                while (headerValues.hasMoreElements()) {
                    String headerValue = (String)headerValues.nextElement();
                    headers.add(headerName, headerValue);
                }
            }
        }
        return headers;
    }
}

