/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.sdk.config.ApiClient;
import com.digiwin.sdk.config.SdkProperties;
import com.digiwin.sdk.enums.ApiUrlEnum;
import com.digiwin.sdk.exception.BusinessException;
import com.digiwin.sdk.model.Result;
import com.digiwin.sdk.model.req.ProjectExternalDTO;
import com.digiwin.sdk.model.req.ProjectMemberDTO;
import com.digiwin.sdk.model.rsp.UserInfo;
import com.digiwin.sdk.service.ProjectUserApiService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ProjectUserApiServiceImpl
implements ProjectUserApiService {
    private static final Logger log = LoggerFactory.getLogger(ProjectUserApiServiceImpl.class);
    private final String DATA = "data";
    @Autowired
    private ApiClient apiClient;
    @Autowired
    private SdkProperties sdkProperties;

    @Override
    public Result<List<UserInfo>> queryProjectToAddUserList(HttpHeaders headers, ProjectExternalDTO projectExternalDTO) {
        String url = this.sdkProperties.getDsHttp() + ApiUrlEnum.DS_API_PROCESS_TO_BE_ADD_USERS_LIST.getUrl();
        String result = this.apiClient.post(url, projectExternalDTO, headers);
        if (!StringUtils.hasText((String)result)) {
            throw new BusinessException("http request result is null");
        }
        JSONObject jsonObject = JSON.parseObject((String)result);
        String data = jsonObject.getString("data");
        if (!StringUtils.hasText((String)data)) {
            throw new BusinessException("http request result data is null");
        }
        List projectList = JSON.parseArray((String)data, UserInfo.class);
        return Result.success(projectList);
    }

    @Override
    public Result updateProjectMembers(HttpHeaders headers, ProjectMemberDTO projectMemberDTO) {
        String url = this.sdkProperties.getDsHttp() + ApiUrlEnum.DS_API_PROJECTS_USERS_UPDATE.getUrl();
        String result = this.apiClient.post(url, projectMemberDTO, headers);
        if (!StringUtils.hasText((String)result)) {
            throw new BusinessException("http request result is null");
        }
        return (Result)JSON.parseObject((String)result, Result.class);
    }
}

