/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.sdk.config;

import com.digiwin.sdk.config.SdkProperties;
import com.digiwin.sdk.exception.BusinessException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class ApiClient {
    private final RestTemplate restTemplate;
    private final SdkProperties properties;
    private final Set<Integer> retryableStatusCodes = new HashSet<Integer>();
    private final HttpHeaders defaultHeaders = new HttpHeaders();

    public ApiClient(RestTemplate restTemplate, SdkProperties properties) {
        this.restTemplate = restTemplate;
        this.properties = properties;
        this.initRetryableStatusCodes();
        this.initDefaultHeaders();
    }

    private void initRetryableStatusCodes() {
        Arrays.stream(this.properties.getRetryableStatusCodes().split(",")).map(String::trim).map(Integer::parseInt).forEach(this.retryableStatusCodes::add);
    }

    private void initDefaultHeaders() {
        this.defaultHeaders.setContentType(MediaType.APPLICATION_JSON);
        this.defaultHeaders.set("X-SDK-Version", "1.0.0");
        this.defaultHeaders.set("User-Agent", "CustomSDK/1.0");
    }

    public String get(String endpoint) {
        return this.get(endpoint, null);
    }

    public String get(String endpoint, HttpHeaders customHeaders) {
        return this.executeWithRetry(endpoint, HttpMethod.GET, null, customHeaders);
    }

    public String post(String endpoint, Object body) {
        return this.post(endpoint, body, null);
    }

    public String post(String endpoint, Object body, HttpHeaders customHeaders) {
        return this.executeWithRetry(endpoint, HttpMethod.POST, body, customHeaders);
    }

    private String executeWithRetry(String endpoint, HttpMethod method, Object body, HttpHeaders customHeaders) {
        int attempt;
        Throwable lastException = null;
        for (attempt = 0; attempt <= this.properties.getMaxRetries(); ++attempt) {
            try {
                return this.executeRequest(endpoint, method, body, customHeaders);
            }
            catch (HttpStatusCodeException e) {
                lastException = e;
                if (!this.shouldRetry(e.getStatusCode().value())) {
                    break;
                }
            }
            catch (Exception e) {
                lastException = e;
            }
            if (attempt >= this.properties.getMaxRetries()) continue;
            this.waitBeforeRetry(attempt);
        }
        throw new BusinessException("API request failed after " + attempt + " attempts", (Exception)lastException);
    }

    private String executeRequest(String endpoint, HttpMethod method, Object body, HttpHeaders customHeaders) {
        String url = this.properties.getBaseUrl() + endpoint;
        HttpHeaders combinedHeaders = this.combineHeaders(customHeaders);
        HttpEntity entity = body != null ? new HttpEntity(body, (MultiValueMap)combinedHeaders) : new HttpEntity((MultiValueMap)combinedHeaders);
        ResponseEntity response = this.restTemplate.exchange(url, method, entity, String.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new BusinessException("API returned non-2xx status: " + response.getStatusCode());
        }
        return (String)response.getBody();
    }

    private HttpHeaders combineHeaders(HttpHeaders customHeaders) {
        HttpHeaders combined = new HttpHeaders();
        combined.addAll((MultiValueMap)this.defaultHeaders);
        if (customHeaders != null) {
            customHeaders.forEach((headerName, headerValues) -> {
                combined.remove(headerName);
                headerValues.forEach(value -> combined.add(headerName, value));
            });
        }
        return combined;
    }

    private boolean shouldRetry(int statusCode) {
        return this.retryableStatusCodes.contains(statusCode);
    }

    private void waitBeforeRetry(int attempt) {
        try {
            long delay = (long)((double)this.properties.getRetryDelay() * Math.pow(2.0, attempt));
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new BusinessException("Retry wait interrupted", e);
        }
    }
}

