/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dcc.model.constant;

import com.digiwin.dcc.core.enums.DataSourceTypeEnum;

public enum FastbootEnum {
    MYSQL_YYYYMMDD00("yyyymmdd", "%Y%m%d", "mysql"),
    MYSQL_YYYYMMDD01("yyyy-mm-dd", "%Y-%m-%d", "mysql"),
    MYSQL_YYYYMMDD02("yyyy/mm/dd", "%Y/%m/%d", "mysql"),
    MYSQL_DDMMYYYY00("ddmmyyyy", "%d%m%Y", "mysql"),
    MYSQL_DDMMYYYY01("dd-mm-yyyy", "%d-%m-%Y", "mysql"),
    MYSQL_DDMMYYYY02("dd/mm/yyyy", "%d/%m/%Y", "mysql"),
    MYSQL_MMDDYYYY00("mmddyyyy", "%m%d%Y", "mysql"),
    MYSQL_MMDDYYYY01("mm-dd-yyyy", "%m-%d-%Y", "mysql"),
    MYSQL_MMDDYYYY02("mm/dd/yyyy", "%m/%d/%Y", "mysql"),
    IMPALA_YYYYMMDD00("yyyymmdd", "yyyyMMdd", "impala"),
    IMPALA_YYYYMMDD01("yyyy-mm-dd", "yyyy-MM-dd", "impala"),
    IMPALA_YYYYMMDD02("yyyy/mm/dd", "yyyy/MM/dd", "impala"),
    IMPALA_DDMMYYYY00("ddmmyyyy", "ddMMyyyy", "impala"),
    IMPALA_DDMMYYYY01("dd-mm-yyyy", "dd-MM-yyyy", "impala"),
    IMPALA_DDMMYYYY02("dd/mm/yyyy", "dd/MM/yyyy", "impala"),
    IMPALA_MMDDYYYY00("mmddyyyy", "MMddyyyy", "impala"),
    IMPALA_MMDDYYYY01("mm-dd-yyyy", "MM-dd-yyyy", "impala"),
    IMPALA_MMDDYYYY02("mm/dd/yyyy", "MM/dd/yyyy", "impala"),
    HIVE_YYYYMMDD00("yyyymmdd", "yyyyMMdd", DataSourceTypeEnum.hive.getType()),
    HIVE_YYYYMMDD01("yyyy-mm-dd", "yyyy-MM-dd", DataSourceTypeEnum.hive.getType()),
    HIVE_YYYYMMDD02("yyyy/mm/dd", "yyyy/MM/dd", DataSourceTypeEnum.hive.getType()),
    HIVE_DDMMYYYY00("ddmmyyyy", "ddMMyyyy", DataSourceTypeEnum.hive.getType()),
    HIVE_DDMMYYYY01("dd-mm-yyyy", "dd-MM-yyyy", DataSourceTypeEnum.hive.getType()),
    HIVE_DDMMYYYY02("dd/mm/yyyy", "dd/MM/yyyy", DataSourceTypeEnum.hive.getType()),
    HIVE_MMDDYYYY00("mmddyyyy", "MMddyyyy", DataSourceTypeEnum.hive.getType()),
    HIVE_MMDDYYYY01("mm-dd-yyyy", "MM-dd-yyyy", DataSourceTypeEnum.hive.getType()),
    HIVE_MMDDYYYY02("mm/dd/yyyy", "MM/dd/yyyy", DataSourceTypeEnum.hive.getType()),
    ORACLE_YYYYMMDD00("yyyymmdd", "YYYYMMDD", "oracle"),
    ORACLE_YYYYMMDD01("yyyy-mm-dd", "YYYY-MM-DD", "oracle"),
    ORACLE_YYYYMMDD02("yyyy/mm/dd", "YYYY/MM/DD", "oracle"),
    ORACLE_DDMMYYYY00("ddmmyyyy", "DDMMYYYY", "oracle"),
    ORACLE_DDMMYYYY01("dd-mm-yyyy", "DD-MM-YYYY", "oracle"),
    ORACLE_DDMMYYYY02("dd/mm/yyyy", "DD/MM/YYYY", "oracle"),
    ORACLE_MMDDYYYY00("mmddyyyy", "MMDDYYYY", "oracle"),
    ORACLE_MMDDYYYY01("mm-dd-yyyy", "MM-DD-YYYY", "oracle"),
    ORACLE_MMDDYYYY02("mm/dd/yyyy", "MM/DD/YYYY", "oracle"),
    STARROCKS_YYYYMMDD00("yyyymmdd", "%Y%m%d", "StarRocks"),
    STARROCKS_YYYYMMDD01("yyyy-mm-dd", "%Y-%m-%d", "StarRocks"),
    STARROCKS_YYYYMMDD02("yyyy/mm/dd", "%Y/%m/%d", "StarRocks"),
    STARROCKS_DDMMYYYY00("ddmmyyyy", "%d%m%Y", "StarRocks"),
    STARROCKS_DDMMYYYY01("dd-mm-yyyy", "%d-%m-%Y", "StarRocks"),
    STARROCKS_DDMMYYYY02("dd/mm/yyyy", "%d/%m/%Y", "StarRocks"),
    STARROCKS_MMDDYYYY00("mmddyyyy", "%m%d%Y", "StarRocks"),
    STARROCKS_MMDDYYYY01("mm-dd-yyyy", "%m-%d-%Y", "StarRocks"),
    STARROCKS_MMDDYYYY02("mm/dd/yyyy", "%m/%d/%Y", "StarRocks");

    private final String key;
    private final String value;
    private final String dbType;

    private FastbootEnum(String key, String value, String dbType) {
        this.key = key;
        this.value = value;
        this.dbType = dbType;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public String getDbType() {
        return this.dbType;
    }

    public static String getValueByKey(String key, String dbType) {
        for (FastbootEnum fastbootEnum : FastbootEnum.values()) {
            if (!key.equals(fastbootEnum.key) || !dbType.equals(fastbootEnum.dbType)) continue;
            return fastbootEnum.getValue();
        }
        return null;
    }
}

