/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dcc;

import cn.hutool.core.bean.BeanUtil;
import com.digiwin.dcc.fastboot.FastbootConvertio;
import com.digiwin.dcc.model.constant.SQLConstants;
import com.digiwin.dcc.model.dto.DatasourceFunction;
import com.digiwin.dcc.model.dto.FastbootDTO;
import com.digiwin.dcc.model.vo.DatasourceFunctionVO;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class FunctionUtil {
    private static final FastbootConvertio fastbootConvertio = new FastbootConvertio();

    public static String functionFastboot(FastbootDTO fastbootDTO) {
        fastbootDTO.setDbType(SQLConstants.DB_MAP.get(fastbootDTO.getDbType()));
        String result = "";
        if (null != fastbootDTO) {
            switch (fastbootDTO.getFunc()) {
                case 0: 
                case 1: {
                    result = fastbootConvertio.convertDate(fastbootDTO);
                    break;
                }
                case 2: {
                    result = fastbootConvertio.substr(fastbootDTO);
                    break;
                }
                case 3: {
                    result = fastbootConvertio.concat(fastbootDTO);
                    break;
                }
            }
        }
        return result;
    }

    public static List<DatasourceFunctionVO> transformFunction(List<DatasourceFunction> functions) {
        List<DatasourceFunctionVO> resList = FunctionUtil.queryFunctionTree(0, functions);
        return resList;
    }

    private static List<DatasourceFunctionVO> queryFunctionTree(int pId, List<DatasourceFunction> list) {
        return list.stream().filter(f -> f.getPId().equals(pId)).map(v -> {
            DatasourceFunctionVO vo = new DatasourceFunctionVO();
            BeanUtil.copyProperties((Object)v, (Object)vo, (String[])new String[0]);
            vo.setChildren(FunctionUtil.queryFunctionTree(v.getId(), list));
            return vo;
        }).sorted(Comparator.comparing(DatasourceFunctionVO::getSeq)).collect(Collectors.toList());
    }
}

