/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dcc.fastboot;

import com.digiwin.dcc.core.enums.DataSourceTypeEnum;
import com.digiwin.dcc.fastboot.FastbootConversionStrategy;
import com.digiwin.dcc.fastboot.HiveFastbootConversion;
import com.digiwin.dcc.fastboot.ImpalaFastbootConversion;
import com.digiwin.dcc.fastboot.MySqlFastbootConversion;
import com.digiwin.dcc.fastboot.OracleFastbootConversion;
import com.digiwin.dcc.fastboot.SqlServerFastbootConversion;
import com.digiwin.dcc.fastboot.StarRocksFastbootConversion;
import com.digiwin.dcc.model.dto.FastbootDTO;
import java.util.HashMap;
import java.util.Map;

public class FastbootConvertio {
    private final Map<String, FastbootConversionStrategy> strategyMap = new HashMap<String, FastbootConversionStrategy>();

    public FastbootConvertio() {
        this.strategyMap.put(DataSourceTypeEnum.mysql.getType(), new MySqlFastbootConversion());
        this.strategyMap.put(DataSourceTypeEnum.impala.getType(), new ImpalaFastbootConversion());
        this.strategyMap.put(DataSourceTypeEnum.hive.getType(), new HiveFastbootConversion());
        this.strategyMap.put(DataSourceTypeEnum.sqlServer.getType(), new SqlServerFastbootConversion());
        this.strategyMap.put(DataSourceTypeEnum.oracle.getType(), new OracleFastbootConversion());
        this.strategyMap.put(DataSourceTypeEnum.StarRocks.getType(), new StarRocksFastbootConversion());
    }

    public String convertDate(FastbootDTO fastbootDTO) {
        FastbootConversionStrategy strategy = this.strategyMap.get(fastbootDTO.getDbType());
        if (strategy == null) {
            throw new IllegalStateException("FastbootStrategy not adapt " + fastbootDTO.getDbType());
        }
        return strategy.convertDate(fastbootDTO);
    }

    public String substr(FastbootDTO fastbootDTO) {
        FastbootConversionStrategy strategy = this.strategyMap.get(fastbootDTO.getDbType());
        if (strategy == null) {
            throw new IllegalStateException("FastbootStrategy not adapt " + fastbootDTO.getDbType());
        }
        return strategy.substr(fastbootDTO);
    }

    public String concat(FastbootDTO fastbootDTO) {
        FastbootConversionStrategy strategy = this.strategyMap.get(fastbootDTO.getDbType());
        if (strategy == null) {
            throw new IllegalStateException("FastbootStrategy not adapt " + fastbootDTO.getDbType());
        }
        return strategy.concat(fastbootDTO);
    }
}

