/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dcc;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.digiwin.dcc.core.entity.query.PlaygroundFilter;
import com.digiwin.dcc.model.dto.ModelLinkEditDTO;
import com.digiwin.dcc.model.dto.ModelLinkField;
import com.digiwin.dcc.model.vo.ModelLinkEditVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ModelLinkUtil {
    public static ModelLinkEditVO transferModelLinkAndField(ModelLinkEditDTO dto) {
        ArrayList<ModelLinkField> resList = new ArrayList<ModelLinkField>();
        resList.addAll(ModelLinkUtil.parseLink(dto.getModelLink().getModelId(), dto.getModelLink().getId(), dto.getModelLink().getSourceTable(), dto.getModelLink().getSourceField()));
        resList.addAll(ModelLinkUtil.parseLink(dto.getModelLink().getModelId(), dto.getModelLink().getId(), dto.getModelLink().getTargetTable(), dto.getModelLink().getTargetField()));
        HashMap<String, String> fieldTableMap = new HashMap<String, String>();
        dto.getModelTables().forEach(table -> table.getFields().forEach(field -> {
            if (!fieldTableMap.containsKey(field.getId().toString())) {
                fieldTableMap.put(field.getId().toString(), table.getId().toString());
            }
        }));
        PlaygroundFilter filter = dto.getModelLink().getFilter() == null ? null : (PlaygroundFilter)JSONUtil.toBean((String)dto.getModelLink().getFilter(), PlaygroundFilter.class);
        resList.addAll(ModelLinkUtil.parseLinkFilter(dto.getModelLink().getModelId(), dto.getModelLink().getId(), filter, fieldTableMap));
        ModelLinkEditVO res = new ModelLinkEditVO();
        res.setModelLink(dto.getModelLink());
        res.setRelationLinkFields(resList);
        return res;
    }

    public static List<ModelLinkField> parseLinkFilter(Long modelId, Long modelLinkId, PlaygroundFilter filter, Map<String, String> fieldTableMap) {
        ArrayList<ModelLinkField> resList = new ArrayList<ModelLinkField>();
        if (filter == null) {
            return resList;
        }
        List children = filter.getChildren();
        if (CollectionUtil.isEmpty((Collection)children)) {
            resList.addAll(ModelLinkUtil.parseLinkFilterItem(modelId, modelLinkId, filter, fieldTableMap));
        } else {
            children.forEach(child -> resList.addAll(ModelLinkUtil.parseLinkFilter(modelId, modelLinkId, child, fieldTableMap)));
        }
        return resList;
    }

    public static List<ModelLinkField> parseLinkFilterItem(Long modelId, Long modelLinkId, PlaygroundFilter filter, Map<String, String> fieldTableMap) {
        ArrayList<ModelLinkField> resList = new ArrayList<ModelLinkField>();
        ModelLinkField linkField = new ModelLinkField();
        linkField.setModelId(modelId);
        linkField.setModelLinkId(modelLinkId);
        linkField.setTableId(Long.parseLong(fieldTableMap.get(filter.getLeftValue())));
        linkField.setFieldId(Long.parseLong(filter.getLeftValue()));
        resList.add(linkField);
        if ("field".equals(filter.getRightType()) && StringUtils.isNotEmpty((CharSequence)filter.getRightValue())) {
            if (StringUtils.containsIgnoreCase((CharSequence)filter.getOperator(), (CharSequence)"between")) {
                Arrays.stream(filter.getRightValue().split("#")).forEach(v -> {
                    ModelLinkField linkFieldObj = new ModelLinkField();
                    linkFieldObj.setModelId(modelId);
                    linkFieldObj.setModelLinkId(modelLinkId);
                    linkFieldObj.setTableId(Long.parseLong((String)fieldTableMap.get(v)));
                    linkFieldObj.setFieldId(Long.parseLong(v));
                    resList.add(linkFieldObj);
                });
            } else {
                ModelLinkField rightLinkField = new ModelLinkField();
                rightLinkField.setModelId(modelId);
                rightLinkField.setModelLinkId(modelLinkId);
                rightLinkField.setTableId(Long.parseLong(fieldTableMap.get(filter.getRightValue())));
                rightLinkField.setFieldId(Long.parseLong(filter.getRightValue()));
                resList.add(rightLinkField);
            }
        }
        return resList;
    }

    public static List<ModelLinkField> parseLink(Long modelId, Long modelLinkId, Long tableId, String fields) {
        ArrayList<ModelLinkField> resList = new ArrayList<ModelLinkField>();
        Arrays.stream(fields.split(",")).forEach(v -> {
            long fieldId = Long.parseLong(v);
            ModelLinkField linkFieldObj = new ModelLinkField();
            linkFieldObj.setModelId(modelId);
            linkFieldObj.setModelLinkId(modelLinkId);
            linkFieldObj.setTableId(tableId);
            linkFieldObj.setFieldId(fieldId);
            resList.add(linkFieldObj);
        });
        return resList;
    }
}

