/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dcc;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.dcc.ModelLinkUtil;
import com.digiwin.dcc.model.constant.SQLConstants;
import com.digiwin.dcc.model.dto.Model;
import com.digiwin.dcc.model.dto.ModelLink;
import com.digiwin.dcc.model.dto.ModelLinkEditDTO;
import com.digiwin.dcc.model.dto.ModelLinkField;
import com.digiwin.dcc.model.dto.ModelProfile;
import com.digiwin.dcc.model.dto.ModelTable;
import com.digiwin.dcc.model.dto.RelationModelTable;
import com.digiwin.dcc.model.vo.ModelLinkEditVO;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public class ModelUtil {
    public static ModelProfile transferModelProfile(Model model) {
        Optional.ofNullable(model).map(Model::getId).orElseThrow(() -> new IllegalArgumentException("model id is null"));
        ModelProfile modelProfile = new ModelProfile();
        List<RelationModelTable> relationModelTables = ModelUtil.extractRelationModelTables(model);
        modelProfile.setRelationModelTables(relationModelTables);
        List<ModelLink> links = ModelUtil.extractLinks(model);
        modelProfile.setLinks(links);
        List tables = JSONObject.parseArray((String)JSONObject.toJSONString(model.getTables()), ModelTable.class);
        List<ModelLinkField> relationLinkFields = ModelUtil.extractRelationLinkFields(links, tables);
        modelProfile.setRelationLinkFields(relationLinkFields);
        return modelProfile;
    }

    private static List<RelationModelTable> extractRelationModelTables(Model model) {
        LinkedList<RelationModelTable> relationModelTables = new LinkedList<RelationModelTable>();
        for (JSONObject table : model.getTables()) {
            RelationModelTable relationModelTable = new RelationModelTable();
            relationModelTable.setModelId(model.getId());
            relationModelTable.setTableId(table.getLong("id"));
            relationModelTable.setModelType(model.getModelType());
            relationModelTable.setTableAlias(table.getString("tableAlias"));
            relationModelTables.add(relationModelTable);
        }
        return relationModelTables;
    }

    private static List<ModelLink> extractLinks(Model model) {
        LinkedList<ModelLink> modelLinks = new LinkedList<ModelLink>();
        long id = 0L;
        for (JSONObject link : model.getLinks()) {
            ModelLink modelLink = new ModelLink();
            BeanUtil.copyProperties((Object)link, (Object)modelLink, (String[])new String[]{"filter"});
            modelLink.setId(id++);
            modelLink.setModelId(model.getId());
            modelLink.setFilter(link.getJSONObject("filter") == null ? null : JSONObject.toJSONString((Object)link.getJSONObject("filter"), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            modelLinks.add(modelLink);
        }
        return modelLinks;
    }

    private static List<ModelLinkField> extractRelationLinkFields(List<ModelLink> links, List<ModelTable> tables) {
        LinkedList<ModelLinkField> relationLinkFields = new LinkedList<ModelLinkField>();
        for (ModelLink link : links) {
            ModelLinkEditDTO dto = new ModelLinkEditDTO(tables, link);
            ModelLinkEditVO vo = ModelLinkUtil.transferModelLinkAndField(dto);
            relationLinkFields.addAll(vo.getRelationLinkFields());
        }
        return relationLinkFields;
    }

    public static String getFieldGroupType(Integer dataType) {
        return SQLConstants.QUOTA_TYPE.contains(dataType) ? "m" : "d";
    }

    public static void main(String[] args) {
        Model model = (Model)JSONObject.parseObject((String)"{\"code\":\"qqqq\",\"dataSourceType\":null,\"dsType\":null,\"graph\":\"{\\\"zoom\\\":100,\\\"position\\\":[{\\\"tableId\\\":100,\\\"position\\\":{\\\"x\\\":-692,\\\"y\\\":-89.5}},{\\\"tableId\\\":107,\\\"position\\\":{\\\"x\\\":-350,\\\"y\\\":-150}}]}\",\"id\":95,\"links\":[{\"filter\":null,\"sourceField\":\"387\",\"targetTable\":107,\"sourceTable\":100,\"targetField\":\"438\",\"logical\":\"and\",\"unionType\":\"left\"}],\"modelType\":0,\"name\":\"qqq\",\"tables\":[{\"code\":\"yyyyy\",\"domainId\":0,\"modifyUser\":562165031600704,\"odsId\":30132,\"layerId\":0,\"modifyTime\":1730198257000,\"modifyName\":\"\u6731\u4e3d\",\"createTime\":1730198257000,\"name\":\"yyyyy\",\"tenantId\":649294760776256,\"createUser\":562165031600704,\"id\":100,\"fields\":[{\"dataType\":\"1\",\"description\":\"yyyyy\",\"sort\":0,\"latitudeMeasurement\":\"LATITUDE\",\"modifyUser\":562165031600704,\"modifyTime\":1730198257000,\"syncCarryOut\":1,\"isPk\":0,\"createTime\":1730198257000,\"name\":\"yyyyy\",\"createUser\":562165031600704,\"id\":387,\"fieldType\":2,\"fieldLength\":\"1000\"},{\"dataType\":\"1\",\"description\":\"tttt\",\"sort\":1,\"latitudeMeasurement\":\"LATITUDE\",\"modifyUser\":562165031600704,\"modifyTime\":1730198361000,\"syncCarryOut\":1,\"isPk\":0,\"createTime\":1730198361000,\"name\":\"tttt\",\"createUser\":562165031600704,\"id\":388,\"fieldType\":1,\"fieldLength\":\"1000\"},{\"dataType\":\"1\",\"description\":\"dgdf\",\"sort\":2,\"latitudeMeasurement\":\"LATITUDE\",\"modifyUser\":562165031600704,\"modifyTime\":1730198463000,\"syncCarryOut\":1,\"isPk\":0,\"createTime\":1730198463000,\"name\":\"gfdhfd\",\"createUser\":562165031600704,\"id\":389,\"fieldType\":3,\"fieldLength\":\"1000\"}],\"createName\":\"\u6731\u4e3d\"},{\"code\":\"ddd3\",\"domainId\":0,\"modifyUser\":562165031600704,\"odsId\":30132,\"layerId\":30012,\"modifyTime\":1730253190000,\"modifyName\":\"\u6731\u4e3d\",\"createTime\":1730253190000,\"name\":\"ddd3\",\"tenantId\":649294760776256,\"createUser\":562165031600704,\"id\":107,\"fields\":[{\"dataType\":\"1\",\"description\":\"ddd3\",\"sort\":0,\"latitudeMeasurement\":\"MEASUREMENT\",\"modifyUser\":562165031600704,\"modifyTime\":1730253190000,\"syncCarryOut\":1,\"isPk\":0,\"createTime\":1730253190000,\"name\":\"ddd3\",\"createUser\":562165031600704,\"id\":437,\"fieldType\":1,\"fieldLength\":\"1000\"},{\"dataType\":\"1\",\"description\":\"ddd4\",\"sort\":1,\"latitudeMeasurement\":\"LATITUDE\",\"modifyUser\":562165031600704,\"modifyTime\":1730253315000,\"syncCarryOut\":1,\"isPk\":0,\"createTime\":1730253315000,\"name\":\"ddd4\",\"createUser\":562165031600704,\"id\":438,\"fieldType\":2,\"fieldLength\":\"1000\"},{\"dataType\":\"1\",\"description\":\"ddd4\",\"sort\":2,\"latitudeMeasurement\":\"LATITUDE\",\"modifyUser\":562165031600704,\"modifyTime\":1730253317000,\"syncCarryOut\":1,\"isPk\":0,\"createTime\":1730253317000,\"name\":\"ddd5\",\"createUser\":562165031600704,\"id\":439,\"fieldType\":2,\"fieldLength\":\"1000\"},{\"dataType\":\"1\",\"description\":\"aaa\",\"sort\":3,\"latitudeMeasurement\":\"LATITUDE\",\"modifyUser\":562165031600704,\"modifyTime\":1730254819000,\"syncCarryOut\":1,\"isPk\":0,\"createTime\":1730254819000,\"name\":\"a\",\"createUser\":592594474062400,\"id\":440,\"fieldType\":3,\"fieldLength\":\"1000\"},{\"dataType\":\"1\",\"description\":\"bbb\",\"sort\":4,\"latitudeMeasurement\":\"LATITUDE\",\"modifyUser\":562165031600704,\"modifyTime\":1730254864000,\"syncCarryOut\":1,\"isPk\":0,\"createTime\":1730254864000,\"name\":\"b\",\"createUser\":592594474062400,\"id\":441,\"fieldType\":6,\"fieldLength\":\"1000\"},{\"dataType\":\"1\",\"description\":\"ccc\",\"sort\":5,\"latitudeMeasurement\":\"LATITUDE\",\"modifyUser\":562165031600704,\"modifyTime\":1730255231000,\"syncCarryOut\":1,\"isPk\":0,\"createTime\":1730255231000,\"name\":\"c\",\"createUser\":592594474062400,\"id\":442,\"fieldType\":4,\"fieldLength\":\"1000\"}],\"createName\":\"\u6731\u4e3d\"}]}", Model.class);
        System.out.println(model);
        model.setId(1111L);
        ModelProfile profile = ModelUtil.transferModelProfile(model);
        System.out.println(profile);
    }
}

