package com.digiwin.dmc.sdk.config;

public class NetworkOptions {

    /**
     * 每包传输的数据量，单位字节
     */
    private int packageSize;

    /**
     * 传输失败时的基础重试间隔时间，单位秒
     */
    private int retryInterval;

    /**
     * 传输失败时的重试次数
     */
    private int retryTimes;

    /**
     * 窄带默认设置，适用于传输速度有限或不稳定的外网传输，例如手机和移动设备
     */
    public static NetworkOptions NarrowbandDefault = new NetworkOptions(261120,2,5);

    /**
     * 宽带默认设置，适用一般的外网传输
     */
    public static NetworkOptions BroadbandDefault = new NetworkOptions(261120,1,3);

    /**
     * 默认设置，适用于企业内网或传输质量较好的专线网络
     */
    public static NetworkOptions Default = new NetworkOptions(261120,1,2);

    public NetworkOptions() { }

    public NetworkOptions(int packageSize, int retryInterval, int retryTimes) {
        this.packageSize = packageSize;
        this.retryInterval = retryInterval;
        this.retryTimes = retryTimes;
    }

    public int getPackageSize() {
        return packageSize;
    }

    public void setPackageSize(int packageSize) {
        this.packageSize = packageSize;
    }

    public int getRetryInterval() {
        return retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public int getRetryTimes() {
        return retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }
}
