package com.digiwin.dmc.sdk.config;

import com.digiwin.dmc.sdk.entity.BucketInfo;
import com.digiwin.dmc.sdk.entity.UserInfo;
import com.digiwin.dmc.sdk.entity.UserRole;
import com.digiwin.dmc.sdk.identity.UserIdentity;
import com.digiwin.dmc.sdk.service.impl.BucketManagerService;
import com.digiwin.dmc.sdk.service.impl.UserManagerService;
import com.digiwin.dmc.sdk.util.AESCipher;

import java.util.List;

/**
 * 服务器相关设定
 * @author chenxsza
 */
public final class ServerSetting {
    private static UserManagerService userManagerService = (UserManagerService) UserManagerService.userInstance();
    private static BucketManagerService bucketManagerService= (BucketManagerService) BucketManagerService.bucketInstance();
    /**
     * 文档服务地址
     */
    private static String serviceUrl;

    private static String identityName;

    private  static String identityPwd;

    private static String identityAdminName;

    private static String identityAdminPwd;

    private static String bucketName;


    public static String getBucketName() {
        return bucketName;
    }

    public static void setBucketName(String bucketName) {
        ServerSetting.bucketName = bucketName;
    }

    /**
     * 访问文档存储的身份信息
     */
    private static UserIdentity identity =new UserIdentity();

    /**
     * 访问文档存储的身份信息
     */
    private static UserIdentity admin =new UserIdentity();


    public static UserIdentity getUser() {
        return identity;
    }

    public static UserIdentity getAdmin() {
        return admin;
    }

    public static String getServiceUrl() {
        return serviceUrl;
    }

    public static void setServiceUrl(String serviceUrl) {
        if (serviceUrl==null || serviceUrl.length()==0){
            throw  new IllegalArgumentException("serviceUrl is null");
        }
        ServerSetting.serviceUrl = serviceUrl;
        DmcUrl.setServiceUrl(serviceUrl);
        DmcUrl.setResourceUrl(serviceUrl + "/api/dmc/v1");
        DmcUrl.setFilesResourceUrl(serviceUrl + "/api/dmc/v1/buckets/");
        DmcUrl.setUploadResourceUrl(serviceUrl + "/api/dmc/v1/buckets/");
        DmcUrl.setDirectoriesResourceUrl(serviceUrl + "/api/dmc/v1/buckets/");
        DmcUrl.setFileMetadataResourceUrl(serviceUrl + "/drive/files/metadata");
        DmcUrl.setTokenResourceUrl(serviceUrl + "/api/dmc/v1/tokens");
        DmcUrl.setIdentityResourceUrl(serviceUrl + "/api/dmc/v1/auth");
        DmcUrl.setBucketResourceUrl(serviceUrl + "/api/dmc/v1/buckets");
        DmcUrl.setUserResourceUrl(serviceUrl + "/api/dmc/v1/users");
    }

    public static String getIdentityName() {
        return identityName;
    }

    public static void setIdentityName(String identityName) {
        ServerSetting.identityName = identityName;
        identity.setUserName(identityName);
    }

    public static String getIdentityPwd() {
        return identityPwd;
    }

    public static void setIdentityPwd(String identityPwd) {
        ServerSetting.identityPwd = identityPwd;
        identity.setPasswordHash(AESCipher.getSHA256StrJava(identityPwd));
    }

    public static String getIdentityAdminName() {
        return identityAdminName;
    }

    public static void setIdentityAdminName(String identityAdminName) {
        ServerSetting.identityAdminName = identityAdminName;
        admin.setUserName(identityAdminName);
    }

    public static String getIdentityAdminPwd() {
        return identityAdminPwd;
    }

    public static void setIdentityAdminPwd(String identityAdminPwd) {
        ServerSetting.identityAdminPwd = identityAdminPwd;
            admin.setPasswordHash(AESCipher.getSHA256StrJava(identityAdminPwd));
    }

    public static void initialize() {
        String isExistUser=userManagerService.isExistUser(identityName);
        String isExistBucket=bucketManagerService.isExistBucket(bucketName);
        if ("false".equals(isExistUser)){
            UserInfo user=new UserInfo(identityName,identityPwd,"test", UserRole.BucketCreator);
            userManagerService.createUser(user);
        }
        if ("false".equals(isExistBucket)){
            BucketInfo bucket = new BucketInfo(bucketName, "test");
            bucketManagerService.createBucket(bucket);
        }
    }

}
