package com.digiwin.dmc.sdk.service;


import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.entity.SharedFile;
import com.digiwin.dmc.sdk.service.upload.IGeneralDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.IShareUploader;

import java.util.List;

public interface IShareFileService {

    /**
     *文件永久分享给所有人
     * @param bucketName
     * @param fileIds
     * @param driveToken
     * @return
     */
    List<String> perpetualShareFiles (String bucketName,List<String> fileIds,String driveToken);

    List<String> perpetualShareFiles (String bucketName,List<String> fileIds);

    List<String> perpetualShareFiles (List<String> fileIds);

    /**
     *文件限时分享给所有人
     * @param bucketName
     * @param fileIds
     * @param day
     * @param driveToken
     * @return
     */
    List<String> limitShareFiles (String bucketName,List<String> fileIds,int day,String driveToken);

    List<String> limitShareFiles (String bucketName,List<String> fileIds,int day);

    List<String> limitShareFiles (List<String> fileIds,int day);

    /**
     * 取消分享
     * @param bucketName
     * @param shareFileId
     * @param driveToken
     */
    void deleteShareFile(String bucketName,String shareFileId,String driveToken);

    void deleteShareFile(String bucketName,String shareFileId);

    void deleteShareFile(String shareFileId);

    /**
     * 获取我的分享
     * @param bucketName
     * @param driveToken
     */
    List<SharedFile> getMyShareFiles(String bucketName, String driveToken);

    List<SharedFile> getMyShareFiles(String bucketName);

    List<SharedFile> getMyShareFiles();

    IShareUploader uploadDocument(String bucketName, String localPath, FileInfo fileInfo, String driveToken);

    IShareUploader uploadDocument(String bucketName, String localPath, FileInfo fileInfo);

    IShareUploader uploadDocument(String localPath, FileInfo fileInfo);

    IShareUploader uploadDocument(String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken);

    IShareUploader uploadDocument(String bucketName, byte[] bytes, FileInfo fileInfo);

    IShareUploader uploadDocument(byte[] bytes, FileInfo fileInfo);
}
