package com.digiwin.dmc.sdk.service;


import com.digiwin.dmc.sdk.entity.UserInfo;
import com.digiwin.dmc.sdk.identity.UserIdentity;

import java.util.List;

public interface IUserManagerService {
    /**
     * 创建用户
     *
     * @param userInfo
     * @return
     */
     String createUser(UserInfo userInfo);

    /**
     * 获取用户信息
     *
     * @param userName
     * @return
     */
    UserInfo getUser(String userName);

    /**
     * 查询所有用户
     * @return
     */
    List<UserInfo> getUsers();

    /**
     * 用户是否存在
     *
     * @param userName
     * @return
     */
    String isExistUser(String userName);


    String getUserToken(UserIdentity identity);

}
