package com.digiwin.dmc.sdk.service.download;

/**
 * 下载器
 *
 * @author chenzwd
 * @date : 2018-06-14 10:34
 * @Description:
 */
public interface ISegmentDocumentDownloader {

    /**
     * 异步下载文件内容
     */
    ISegmentDocumentDownloader beginDownload();

    /**
     * 设置响应进度
     */
    ISegmentDocumentDownloader onProgressChanged(IDownLoadCallbackable callbackable);

    /**
     * 设置完成
     */
    ISegmentDocumentDownloader onCompleted(IDownLoadCallbackable callbackable);

    /**
     * 暂停下载
     */
    void pauseDownload();

    /**
     * 继续下载
     */
    void continueDownload();

    /**
     * 停止下载
     */
    void stopDownload();

}
