package com.digiwin.dmc.sdk.service.upload;

import com.digiwin.dmc.sdk.config.DmcUrl;
import com.digiwin.dmc.sdk.config.NetworkOptions;
import com.digiwin.dmc.sdk.config.SDKConstants;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.service.impl.UserManagerService;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.StringUtil;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CoverGeneralDocumentUploader implements ICoverGeneralDocumentUploader {
    private String tenantId;
    private String bucketName;
    private String driveToken;
    private String fileId;
    private FileInputStream fileInputStream;
    private InputStream inputStream;
    private IUpLoadCallbackable completeCallback;
    private UploadProgressEventArgs eventArgs = new UploadProgressEventArgs();

    private static ExecutorService es = Executors.newCachedThreadPool();
    private static IUserManagerService userManagerService = UserManagerService.userInstance();

    public CoverGeneralDocumentUploader(String tenantId, String bucketName, String localPath, String fileId, String driveToken) {
        try {
            File file = new File(localPath);
            FileInputStream fileInputStream = new FileInputStream(file);
            this.fileInputStream = fileInputStream;
        } catch (Exception e) {
            throw new OperateException(e);
        }
        this.tenantId = tenantId;
        this.fileId = fileId;
        this.bucketName = bucketName;
        this.driveToken = driveToken;
    }

    public CoverGeneralDocumentUploader(String tenantId, String bucketName, byte[] bytes, String fileId, String driveToken) {
        try {
            this.inputStream= new ByteArrayInputStream(bytes);
        }catch (Exception e){
            throw new OperateException(e);
        }
        this.tenantId = tenantId;
        this.fileId = fileId;
        this.bucketName = bucketName;
        this.driveToken = driveToken;
    }

    /**
     * 上传Stream中的文件内容，同步模式
     *
     * @return
     */
    @Override
    public ICoverGeneralDocumentUploader upload() {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String uploadResourceUrl = DmcUrl.getUploadResourceUrl()
                + bucketName + "/files/"+fileId+"/cover";
        try {
            Map<String, String> headers = new HashMap<>();
            if (StringUtil.isEmpty(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            if (tenantId != null){
                headers.put(SDKConstants.HTTP_HEADER_TENANTID_KEY, tenantId);
            }
            Runnable runnable = () -> {
                Map<String, String> result = HttpRequestUtil.uploadFile(uploadResourceUrl, headers, fileInputStream, HashMap.class);
                if (completeCallback != null) {
                    eventArgs.setFileId(fileId);
                    eventArgs.setPercentage(1);
                    completeCallback.callback(eventArgs);
                }
            };
            es.execute(runnable);
            return this;
        } catch (Exception e) {
            throw new OperateException(e);
        }
    }

    /**
     * 设置完成
     *
     * @param callbackable
     */
    @Override
    public ICoverGeneralDocumentUploader onCompleted(IUpLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }
}
