/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.identity;

import com.digiwin.dmc.sdk.util.AESCipher;

public class UserIdentity {
    private String userName;
    private String password;
    private String passwordHash;

    public static UserIdentity getUserIdentity(String userName, String password) throws Exception {
        return new UserIdentity(userName, password);
    }

    public static UserIdentity getSecureUserIdentity(String userName, String passwordHash) throws Exception {
        return new UserIdentity(userName, passwordHash, true);
    }

    public UserIdentity(String userName, String password, boolean hash) throws Exception {
        this.userName = userName;
        if (hash) {
            this.password = password;
        } else {
            this.password = password;
            this.passwordHash = AESCipher.getSHA256StrJava(password);
        }
    }

    public UserIdentity(String userName, String password) throws Exception {
        this(userName, password, false);
    }

    public UserIdentity() {
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public void setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof UserIdentity) {
            UserIdentity item = (UserIdentity)obj;
            return this.hashCode() == item.hashCode();
        }
        return false;
    }

    public int hashCode() {
        int hash = 0;
        if (this.password != null) {
            hash = this.password.hashCode();
        }
        if (this.passwordHash != null) {
            hash ^= this.passwordHash.hashCode();
        }
        if (this.userName != null) {
            hash ^= this.userName.hashCode();
        }
        return hash;
    }
}

