/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.download;

import com.digiwin.dmc.sdk.config.DmcUrl;
import com.digiwin.dmc.sdk.config.SDKConstants;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.service.download.DownloadProgressEventArgs;
import com.digiwin.dmc.sdk.service.download.IDownLoadCallbackable;
import com.digiwin.dmc.sdk.service.download.IGeneralDocumentDownloader;
import com.digiwin.dmc.sdk.service.impl.UserManagerService;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class GeneralDocumentDownloader
implements IGeneralDocumentDownloader {
    private String fileId;
    private String tenantId;
    private String bucketName;
    private String driveToken;
    private FileOutputStream fileOutputStream;
    private IDownLoadCallbackable completeCallback;
    private DownloadProgressEventArgs eventArgs = new DownloadProgressEventArgs();
    private static ExecutorService es = Executors.newCachedThreadPool();
    private static IUserManagerService userManagerService = UserManagerService.userInstance();

    public GeneralDocumentDownloader(String tenantId, String bucketName, String fileId, String saveToPath, String driveToken) {
        try {
            File file = new File(saveToPath);
            if (!file.exists()) {
                file.createNewFile();
            }
            this.fileOutputStream = new FileOutputStream(file);
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
        this.fileId = fileId;
        this.tenantId = tenantId;
        this.bucketName = bucketName;
        this.driveToken = driveToken;
        this.eventArgs.setPercentage(0.0);
        this.eventArgs.setCompletedBytes(0);
    }

    @Override
    public IGeneralDocumentDownloader download() {
        if (StringUtil.isEmpty(this.bucketName)) {
            this.bucketName = ServerSetting.getBucketName();
        }
        String downloadDocumentUrl = DmcUrl.getFilesResourceUrl() + this.bucketName + "/files/" + this.fileId;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtil.isEmpty(this.driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, this.driveToken);
        }
        if (this.tenantId != null) {
            headers.put("tenantId", this.tenantId);
        }
        Runnable runnable = () -> {
            HttpRequestUtil.downloadFile(downloadDocumentUrl, headers, this.fileOutputStream);
            if (this.completeCallback != null) {
                this.eventArgs.setPercentage(1.0);
                this.completeCallback.callback(this.eventArgs);
            }
        };
        es.execute(runnable);
        return this;
    }

    @Override
    public IGeneralDocumentDownloader onCompleted(IDownLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }
}

