/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.download;

import com.digiwin.dmc.sdk.config.DmcUrl;
import com.digiwin.dmc.sdk.config.NetworkOptions;
import com.digiwin.dmc.sdk.config.SDKConstants;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.service.download.DownloadProcessState;
import com.digiwin.dmc.sdk.service.download.DownloadProgressEventArgs;
import com.digiwin.dmc.sdk.service.download.IDownLoadCallbackable;
import com.digiwin.dmc.sdk.service.download.ISegmentDocumentDownloader;
import com.digiwin.dmc.sdk.service.impl.UserManagerService;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SegmentSegmentDocumentDownloader
implements ISegmentDocumentDownloader {
    private String fileId;
    private int bufferSize;
    private String tenantId;
    private String bucketName;
    private String driveToken;
    private DownloadProcessState state;
    private FileOutputStream fileOutputStream;
    private IDownLoadCallbackable completeCallback;
    private IDownLoadCallbackable progressChangedCallback;
    private DownloadProgressEventArgs eventArgs = new DownloadProgressEventArgs();
    private static ExecutorService es = Executors.newCachedThreadPool();
    private static IUserManagerService userManagerService = UserManagerService.userInstance();

    public SegmentSegmentDocumentDownloader(String tenantId, String bucketName, String fileId, String saveToPath, int fileSize, String driveToken) {
        try {
            File file = new File(saveToPath);
            if (!file.exists()) {
                file.createNewFile();
            }
            this.fileOutputStream = new FileOutputStream(file);
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
        this.fileId = fileId;
        this.bucketName = bucketName;
        this.driveToken = driveToken;
        this.eventArgs.setPercentage(0.0);
        this.eventArgs.setCompletedBytes(0);
        this.eventArgs.setTotalBytes(fileSize);
        this.tenantId = tenantId;
        this.state = DownloadProcessState.NotStarted;
        this.bufferSize = NetworkOptions.Default.getPackageSize();
    }

    @Override
    public ISegmentDocumentDownloader beginDownload() {
        if (this.state != DownloadProcessState.NotStarted) {
            throw new OperateException("\u4e0b\u8f7d\u5df2\u5f00\u59cb\uff0c\u65e0\u6cd5\u518d\u6b21\u542f\u52a8\u4e0b\u8f7d\uff0c\u8bf7\u5f00\u542f\u65b0\u7684\u4e0b\u8f7d");
        }
        this.continueDownload();
        Runnable runnable = () -> this.multipartDownload(this.bucketName);
        es.execute(runnable);
        return this;
    }

    public void multipartDownload(String bucketName) {
        try {
            while (true) {
                int totalBytes = this.eventArgs.getTotalBytes();
                int bytesReaded = this.eventArgs.getCompletedBytes();
                if (this.state == DownloadProcessState.Stopped) {
                    return;
                }
                if (this.state == DownloadProcessState.Paused) {
                    Thread.sleep(86400000L);
                    if (this.state != DownloadProcessState.Paused) continue;
                    this.state = DownloadProcessState.Timeout;
                    return;
                }
                int from = bytesReaded;
                if (bytesReaded + this.bufferSize >= totalBytes) {
                    this.download(bucketName, from, totalBytes - bytesReaded);
                    this.eventArgs.setCompletedBytes(totalBytes);
                    this.eventArgs.setPercentage(1.0);
                    if (this.progressChangedCallback != null) {
                        this.progressChangedCallback.callback(this.eventArgs);
                    }
                    if (this.completeCallback != null) {
                        this.completeCallback.callback(this.eventArgs);
                    }
                    return;
                }
                this.download(bucketName, from, this.bufferSize);
                this.eventArgs.setCompletedBytes(bytesReaded + this.bufferSize);
                this.eventArgs.setPercentage((double)this.eventArgs.getCompletedBytes() / (double)totalBytes);
                if (this.progressChangedCallback == null) continue;
                this.progressChangedCallback.callback(this.eventArgs);
            }
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    public void download(String bucketName, int bytesReaded, int count) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String downloadResourceUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + this.fileId + "/" + bytesReaded + "/" + count;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            if (StringUtil.isEmpty(this.driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, this.driveToken);
            }
            if (this.tenantId != null) {
                headers.put("tenantId", this.tenantId);
            }
            this.fileOutputStream = HttpRequestUtil.downloadSegFile(downloadResourceUrl, headers, count, this.fileOutputStream);
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public ISegmentDocumentDownloader onProgressChanged(IDownLoadCallbackable callbackable) {
        this.progressChangedCallback = callbackable;
        return this;
    }

    @Override
    public ISegmentDocumentDownloader onCompleted(IDownLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }

    @Override
    public void pauseDownload() {
        this.state = DownloadProcessState.Paused;
    }

    @Override
    public void continueDownload() {
        this.state = DownloadProcessState.Downloading;
    }

    @Override
    public void stopDownload() {
        this.state = DownloadProcessState.Stopped;
    }
}

