/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.impl;

import com.digiwin.dmc.sdk.config.DmcUrl;
import com.digiwin.dmc.sdk.config.SDKConstants;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.BatchOperationIds;
import com.digiwin.dmc.sdk.entity.ContentsResult;
import com.digiwin.dmc.sdk.entity.DirInfo;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.entity.Query.FileInfoQuery;
import com.digiwin.dmc.sdk.entity.Query.FullTextCondition;
import com.digiwin.dmc.sdk.entity.Query.QueryResult;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.IDocumentStorageService;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.service.download.GeneralDocumentDownloader;
import com.digiwin.dmc.sdk.service.download.IGeneralDocumentDownloader;
import com.digiwin.dmc.sdk.service.download.ISegmentDocumentDownloader;
import com.digiwin.dmc.sdk.service.download.SegmentSegmentDocumentDownloader;
import com.digiwin.dmc.sdk.service.impl.UserManagerService;
import com.digiwin.dmc.sdk.service.upload.CoverGeneralDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.CoverSegmentDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.GeneralDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.ICoverGeneralDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.ICoverSegmentDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.IGeneralDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.ISegmentDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.SegmentDocumentUploader;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.ObjectMapperUtil;
import com.digiwin.dmc.sdk.util.StringUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class DocumentStorageService
implements IDocumentStorageService {
    private static DocumentStorageService documentStorageService;
    private static IUserManagerService userManagerService;
    private static final String EMPTY_OBJECT_ID_STR = "00000000-0000-0000-0000-000000000000";

    public static IDocumentStorageService instance() {
        if (documentStorageService == null) {
            documentStorageService = new DocumentStorageService();
        }
        return documentStorageService;
    }

    @Override
    public ICoverGeneralDocumentUploader coverUploadDocument(String localPath, String fileId) {
        return this.coverUploadDocument(null, localPath, fileId, null);
    }

    @Override
    public ICoverGeneralDocumentUploader coverUploadDocument(String bucketName, String localPath, String fileId) {
        return this.coverUploadDocument(null, localPath, fileId, null);
    }

    @Override
    public ICoverGeneralDocumentUploader coverUploadDocument(String bucketName, String localPath, String fileId, String driveToken) {
        if (localPath == null) {
            throw new IllegalArgumentException("The localPath is null ");
        }
        if (StringUtil.isEmpty(fileId)) {
            throw new IllegalArgumentException("The fileId is null ");
        }
        return new CoverGeneralDocumentUploader(null, bucketName, localPath, fileId, driveToken);
    }

    @Override
    public ICoverGeneralDocumentUploader coverUploadDocument(byte[] bytes, String fileId) {
        return this.coverUploadDocument(null, bytes, fileId, null);
    }

    @Override
    public ICoverGeneralDocumentUploader coverUploadDocument(String bucketName, byte[] bytes, String fileId) {
        return this.coverUploadDocument(null, bytes, fileId, null);
    }

    @Override
    public ICoverGeneralDocumentUploader coverUploadDocument(String bucketName, byte[] bytes, String fileId, String driveToken) {
        if (bytes == null) {
            throw new IllegalArgumentException("The bytes is null ");
        }
        if (StringUtil.isEmpty(fileId)) {
            throw new IllegalArgumentException("The fileId is null ");
        }
        return new CoverGeneralDocumentUploader(null, bucketName, bytes, fileId, driveToken);
    }

    @Override
    public ICoverSegmentDocumentUploader getUploader(String localPath, String fileId) {
        return this.getUploader(null, localPath, fileId, null);
    }

    @Override
    public ICoverSegmentDocumentUploader getUploader(String bucketName, String localPath, String fileId) {
        return this.getUploader(bucketName, localPath, fileId, null);
    }

    @Override
    public ICoverSegmentDocumentUploader getUploader(String bucketName, String localPath, String fileId, String driveToken) {
        if (localPath == null) {
            throw new IllegalArgumentException("The localPath is null");
        }
        if (StringUtil.isEmpty(fileId)) {
            throw new IllegalArgumentException("The fileId is null");
        }
        return new CoverSegmentDocumentUploader(null, bucketName, localPath, fileId, driveToken);
    }

    @Override
    public ICoverSegmentDocumentUploader getUploader(byte[] bytes, String fileId) {
        return this.getUploader(null, bytes, fileId, null);
    }

    @Override
    public ICoverSegmentDocumentUploader getUploader(String bucketName, byte[] bytes, String fileId) {
        return this.getUploader(bucketName, bytes, fileId, null);
    }

    @Override
    public ICoverSegmentDocumentUploader getUploader(String bucketName, byte[] bytes, String fileId, String driveToken) {
        if (bytes == null) {
            throw new IllegalArgumentException("The bytes is null");
        }
        if (StringUtil.isEmpty(fileId)) {
            throw new IllegalArgumentException("The fileId is null");
        }
        return new CoverSegmentDocumentUploader(null, bucketName, bytes, fileId, driveToken);
    }

    @Override
    public IGeneralDocumentUploader uploadDocument(String localPath, FileInfo fileInfo) {
        return this.uploadDocument(null, localPath, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocument(String bucketName, String localPath, FileInfo fileInfo) {
        return this.uploadDocument(bucketName, localPath, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocument(String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        if (localPath == null) {
            throw new IllegalArgumentException("The localPath is null ");
        }
        if (fileInfo == null) {
            throw new IllegalArgumentException("The fileInfo is null ");
        }
        return new GeneralDocumentUploader(null, bucketName, localPath, fileInfo, driveToken);
    }

    @Override
    public IGeneralDocumentUploader uploadDocument(byte[] bytes, FileInfo fileInfo) {
        return this.uploadDocument(null, bytes, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocument(String bucketName, byte[] bytes, FileInfo fileInfo) {
        return this.uploadDocument(bucketName, bytes, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocument(String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        if (bytes == null) {
            throw new IllegalArgumentException("The bytes is null ");
        }
        if (fileInfo == null) {
            throw new IllegalArgumentException("The fileInfo is null ");
        }
        return new GeneralDocumentUploader(null, bucketName, bytes, fileInfo, driveToken);
    }

    @Override
    public IGeneralDocumentUploader uploadDocumentByTenant(String tenantId, String localPath, FileInfo fileInfo) {
        return this.uploadDocumentByTenant(tenantId, null, localPath, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocumentByTenant(String tenantId, String bucketName, String localPath, FileInfo fileInfo) {
        return this.uploadDocumentByTenant(tenantId, bucketName, localPath, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocumentByTenant(String tenantId, String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        if (localPath == null) {
            throw new IllegalArgumentException("The localPath is null ");
        }
        if (fileInfo == null) {
            throw new IllegalArgumentException("The fileInfo is null ");
        }
        return new GeneralDocumentUploader(tenantId, bucketName, localPath, fileInfo, driveToken);
    }

    @Override
    public IGeneralDocumentUploader uploadDocumentByTenant(String tenantId, byte[] bytes, FileInfo fileInfo) {
        return this.uploadDocumentByTenant(tenantId, null, bytes, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocumentByTenant(String tenantId, String bucketName, byte[] bytes, FileInfo fileInfo) {
        return this.uploadDocumentByTenant(tenantId, bucketName, bytes, fileInfo, null);
    }

    @Override
    public IGeneralDocumentUploader uploadDocumentByTenant(String tenantId, String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        if (bytes == null) {
            throw new IllegalArgumentException("The bytes is null ");
        }
        if (fileInfo == null) {
            throw new IllegalArgumentException("The fileInfo is null ");
        }
        return new GeneralDocumentUploader(tenantId, bucketName, bytes, fileInfo, driveToken);
    }

    @Override
    public ISegmentDocumentUploader getUploader(String localPath, FileInfo fileInfo) {
        return this.getUploader(null, localPath, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploader(String bucketName, String localPath, FileInfo fileInfo) {
        return this.getUploader(bucketName, localPath, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploader(String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        if (localPath == null) {
            throw new IllegalArgumentException("The localPath is null");
        }
        if (fileInfo == null) {
            throw new IllegalArgumentException("The fileInfo is null");
        }
        return new SegmentDocumentUploader(null, bucketName, localPath, fileInfo, driveToken);
    }

    @Override
    public ISegmentDocumentUploader getUploader(byte[] bytes, FileInfo fileInfo) {
        return this.getUploader(null, bytes, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploader(String bucketName, byte[] bytes, FileInfo fileInfo) {
        return this.getUploader(bucketName, bytes, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploader(String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        if (bytes == null) {
            throw new IllegalArgumentException("The bytes is null");
        }
        if (fileInfo == null) {
            throw new IllegalArgumentException("The fileInfo is null");
        }
        return new SegmentDocumentUploader(null, bucketName, bytes, fileInfo, driveToken);
    }

    @Override
    public ISegmentDocumentUploader getUploaderByTenant(String tenantId, String localPath, FileInfo fileInfo) {
        return this.getUploaderByTenant(tenantId, null, localPath, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploaderByTenant(String tenantId, String bucketName, String localPath, FileInfo fileInfo) {
        return this.getUploaderByTenant(tenantId, bucketName, localPath, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploaderByTenant(String tenantId, String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        if (localPath == null) {
            throw new IllegalArgumentException("The localPath is null");
        }
        if (fileInfo == null) {
            throw new IllegalArgumentException("The fileInfo is null");
        }
        return new SegmentDocumentUploader(tenantId, bucketName, localPath, fileInfo, driveToken);
    }

    @Override
    public ISegmentDocumentUploader getUploaderByTenant(String tenantId, byte[] bytes, FileInfo fileInfo) {
        return this.getUploaderByTenant(tenantId, null, bytes, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploaderByTenant(String tenantId, String bucketName, byte[] bytes, FileInfo fileInfo) {
        return this.getUploaderByTenant(tenantId, bucketName, bytes, fileInfo, null);
    }

    @Override
    public ISegmentDocumentUploader getUploaderByTenant(String tenantId, String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        if (bytes == null) {
            throw new IllegalArgumentException("The bytes is null");
        }
        if (fileInfo == null) {
            throw new IllegalArgumentException("The fileInfo is null");
        }
        return new SegmentDocumentUploader(tenantId, bucketName, bytes, fileInfo, driveToken);
    }

    @Override
    public IGeneralDocumentDownloader downloadDocument(String fileId, String saveToPath) {
        return this.downloadDocument(null, fileId, saveToPath, null);
    }

    @Override
    public IGeneralDocumentDownloader downloadDocument(String bucketName, String fileId, String saveToPath) {
        return this.downloadDocument(bucketName, fileId, saveToPath, null);
    }

    @Override
    public IGeneralDocumentDownloader downloadDocument(String bucketName, String fileId, String saveToPath, String driveToken) {
        if (fileId == null || saveToPath == null) {
            throw new IllegalArgumentException("parameter is null");
        }
        File file = new File(saveToPath);
        if (file.isDirectory()) {
            FileInfo fileInfo = this.getDocumentInfoByTenant(bucketName, fileId);
            saveToPath = saveToPath + "\\" + fileInfo.getFileName();
        }
        return new GeneralDocumentDownloader(null, bucketName, fileId, saveToPath, driveToken);
    }

    @Override
    public IGeneralDocumentDownloader downloadDocumentByTenant(String tenantId, String fileId, String saveToPath) {
        return this.downloadDocumentByTenant(tenantId, null, fileId, saveToPath, null);
    }

    @Override
    public IGeneralDocumentDownloader downloadDocumentByTenant(String tenantId, String bucketName, String fileId, String saveToPath) {
        return this.downloadDocumentByTenant(tenantId, bucketName, fileId, saveToPath, null);
    }

    @Override
    public IGeneralDocumentDownloader downloadDocumentByTenant(String tenantId, String bucketName, String fileId, String saveToPath, String driveToken) {
        if (fileId == null || saveToPath == null) {
            throw new IllegalArgumentException("parameter is null");
        }
        File file = new File(saveToPath);
        if (file.isDirectory()) {
            FileInfo fileInfo = this.getDocumentInfoByTenant(bucketName, fileId);
            saveToPath = saveToPath + "\\" + fileInfo.getFileName();
        }
        return new GeneralDocumentDownloader(tenantId, bucketName, fileId, saveToPath, driveToken);
    }

    @Override
    public ISegmentDocumentDownloader getDownloader(String fileId, String saveToPath) {
        return this.getDownloader(null, fileId, saveToPath, null);
    }

    @Override
    public ISegmentDocumentDownloader getDownloader(String bucketName, String fileId, String saveToPath) {
        return this.getDownloader(bucketName, fileId, saveToPath, null);
    }

    @Override
    public ISegmentDocumentDownloader getDownloader(String bucketName, String fileId, String saveToPath, String driveToken) {
        if (fileId == null || saveToPath == null) {
            throw new IllegalArgumentException("parameter is null");
        }
        FileInfo fileInfo = this.getDocumentInfoByTenant(bucketName, fileId);
        File file = new File(saveToPath);
        if (file.isDirectory()) {
            saveToPath = saveToPath + "\\" + fileInfo.getFileName();
        }
        return new SegmentSegmentDocumentDownloader(null, bucketName, fileId, saveToPath, (int)fileInfo.getSize(), driveToken);
    }

    @Override
    public ISegmentDocumentDownloader getDownloaderByTenant(String tenantId, String fileId, String saveToPath) {
        return this.getDownloaderByTenant(tenantId, null, fileId, saveToPath, null);
    }

    @Override
    public ISegmentDocumentDownloader getDownloaderByTenant(String tenantId, String bucketName, String fileId, String saveToPath) {
        return this.getDownloaderByTenant(tenantId, bucketName, fileId, saveToPath, null);
    }

    @Override
    public ISegmentDocumentDownloader getDownloaderByTenant(String tenantId, String bucketName, String fileId, String saveToPath, String driveToken) {
        if (fileId == null || saveToPath == null) {
            throw new IllegalArgumentException("parameter is null");
        }
        FileInfo fileInfo = this.getDocumentInfoByTenant(bucketName, fileId);
        File file = new File(saveToPath);
        if (file.isDirectory()) {
            saveToPath = saveToPath + "\\" + fileInfo.getFileName();
        }
        return new SegmentSegmentDocumentDownloader(tenantId, bucketName, fileId, saveToPath, (int)fileInfo.getSize(), driveToken);
    }

    @Override
    public String deleteDocument(String bucketName, String fileId) {
        return this.deleteDocument(bucketName, fileId, null);
    }

    @Override
    public String deleteDocument(String fileId) {
        return this.deleteDocument(null, fileId, null);
    }

    @Override
    public String deleteDocument(String bucketName, String fileId, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (StringUtil.isEmpty(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String deleteFileUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + fileId;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtil.isEmpty(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        HashMap responseEntity = HttpRequestUtil.delete(deleteFileUrl, headers, HashMap.class);
        if (null == responseEntity || !responseEntity.containsKey("recycleBinId")) {
            return null;
        }
        return responseEntity.get("recycleBinId").toString();
    }

    @Override
    public String deleteDocumentByTenant(String tenantId, String fileId) {
        return this.deleteDocumentByTenant(tenantId, null, fileId, null);
    }

    @Override
    public String deleteDocumentByTenant(String tenantId, String bucketName, String fileId) {
        return this.deleteDocumentByTenant(tenantId, bucketName, fileId, null);
    }

    @Override
    public String deleteDocumentByTenant(String tenantId, String bucketName, String fileId, String driveToken) {
        HashMap responseEntity;
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (StringUtil.isEmpty(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String deleteFileUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + fileId;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtil.isEmpty(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        if (tenantId != null) {
            headers.put("tenantId", tenantId);
        }
        if (null == (responseEntity = HttpRequestUtil.delete(deleteFileUrl, headers, HashMap.class)) || !responseEntity.containsKey("recycleBinId")) {
            return null;
        }
        return responseEntity.get("recycleBinId").toString();
    }

    @Override
    public void deleteManyDocument(BatchOperationIds operationIds) {
        this.deleteManyDocument(null, operationIds);
    }

    @Override
    public void deleteManyDocument(String bucketName, BatchOperationIds operationIds) {
        this.deleteManyDocument(bucketName, operationIds, null);
    }

    @Override
    public void deleteManyDocument(String bucketName, BatchOperationIds operationIds, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (operationIds == null) {
            throw new IllegalArgumentException("\u53c2\u6570operationIds is null");
        }
        String deleteFileUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/delete/batch";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        try {
            HttpRequestUtil.postJson(deleteFileUrl, ObjectMapperUtil.writeValueAsString(operationIds), headers, ArrayList.class);
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public void deleteManyDocumentByTenant(String tenantId, BatchOperationIds operationIds) {
        this.deleteManyDocumentByTenant(tenantId, null, operationIds, null);
    }

    @Override
    public void deleteManyDocumentByTenant(String tenantId, String bucketName, BatchOperationIds operationIds) {
        this.deleteManyDocumentByTenant(tenantId, bucketName, operationIds, null);
    }

    @Override
    public void deleteManyDocumentByTenant(String tenantId, String bucketName, BatchOperationIds operationIds, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (operationIds == null) {
            throw new IllegalArgumentException("\u53c2\u6570operationIds is null");
        }
        String deleteFileUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/delete/batch";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtil.isEmpty(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        if (tenantId != null) {
            headers.put("tenantId", tenantId);
        }
        try {
            HttpRequestUtil.deleteJson(deleteFileUrl, ObjectMapperUtil.writeValueAsString(operationIds), headers, ArrayList.class);
        }
        catch (JsonProcessingException e) {
            throw new OperateException(e);
        }
    }

    @Override
    public FileInfo getDocumentInfo(String bucketName, String fileId) {
        return this.getDocumentInfo(bucketName, fileId, null);
    }

    @Override
    public FileInfo getDocumentInfo(String fileId) {
        return this.getDocumentInfo(null, fileId, null);
    }

    @Override
    public FileInfo getDocumentInfo(String bucketName, String fileId, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String documentInfoUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + fileId + "/info";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        FileInfo fileInfo = HttpRequestUtil.get(documentInfoUrl, headers, FileInfo.class);
        if (fileInfo == null) {
            return null;
        }
        return fileInfo;
    }

    @Override
    public FileInfo getDocumentInfoByTenant(String tenantId, String fileId) {
        return this.getDocumentInfoByTenant(tenantId, null, fileId, null);
    }

    @Override
    public FileInfo getDocumentInfoByTenant(String tenantId, String bucketName, String fileId) {
        return this.getDocumentInfoByTenant(tenantId, bucketName, fileId, null);
    }

    @Override
    public FileInfo getDocumentInfoByTenant(String tenantId, String bucketName, String fileId, String driveToken) {
        FileInfo fileInfo;
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String documentInfoUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + fileId + "/info";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        if (tenantId != null) {
            headers.put("tenantId", tenantId);
        }
        if ((fileInfo = HttpRequestUtil.get(documentInfoUrl, headers, FileInfo.class)) == null) {
            return null;
        }
        return fileInfo;
    }

    @Override
    public void updateDocument(String bucketName, String fileId, String fileName) {
        this.updateDocument(bucketName, fileId, fileName, null);
    }

    @Override
    public void updateDocument(String fileId, String fileName) {
        this.updateDocument(null, fileId, fileName, null);
    }

    @Override
    public void updateDocument(String bucketName, String fileId, String fileName, String driveToken) {
        try {
            if (fileId == null || "".equals(fileId) || fileName == null || "".equals(fileName)) {
                throw new IllegalArgumentException("\u8bf7\u68c0\u67e5\u53c2\u6570");
            }
            if (StringUtil.isEmpty(bucketName)) {
                bucketName = ServerSetting.getBucketName();
            }
            String updateDocumentInfoUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + fileId + "/rename/" + fileName;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (driveToken == null || "".equals(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            HttpRequestUtil.postJson(updateDocumentInfoUrl, "", headers, String.class);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    @Override
    public void updateDocumentByTenant(String tenantId, String fileId, String fileName) {
        this.updateDocumentByTenant(tenantId, null, fileId, fileName, null);
    }

    @Override
    public void updateDocumentByTenant(String tenantId, String bucketName, String fileId, String fileName) {
        this.updateDocumentByTenant(tenantId, bucketName, fileId, fileName, null);
    }

    @Override
    public void updateDocumentByTenant(String tenantId, String bucketName, String fileId, String fileName, String driveToken) {
        try {
            if (fileId == null || "".equals(fileId) || fileName == null || "".equals(fileName)) {
                throw new IllegalArgumentException("\u8bf7\u68c0\u67e5\u53c2\u6570");
            }
            if (StringUtil.isEmpty(bucketName)) {
                bucketName = ServerSetting.getBucketName();
            }
            String updateDocumentInfoUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + fileId + "/rename/" + fileName;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (driveToken == null || "".equals(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            if (tenantId != null) {
                headers.put("tenantId", tenantId);
            }
            HttpRequestUtil.postJson(updateDocumentInfoUrl, "", headers, String.class);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    @Override
    public void moveDocument(String bucketName, String fileId, String targetDirectoryId) {
        this.moveDocument(bucketName, fileId, targetDirectoryId, null);
    }

    @Override
    public void moveDocument(String fileId, String targetDirectoryId) {
        this.moveDocument(null, fileId, targetDirectoryId, null);
    }

    @Override
    public void moveDocument(String bucketName, String fileId, String targetDirectoryId, String driveToken) {
        try {
            if (fileId == null || "".equals(fileId)) {
                throw new IllegalArgumentException("\u53c2\u6570 fileId is null");
            }
            if (StringUtil.isEmpty(targetDirectoryId)) {
                targetDirectoryId = EMPTY_OBJECT_ID_STR;
            }
            if (StringUtil.isEmpty(bucketName)) {
                bucketName = ServerSetting.getBucketName();
            }
            String moveDocumentUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + fileId + "/moveto/directory/" + targetDirectoryId;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (driveToken == null || "".equals(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            HttpRequestUtil.postJson(moveDocumentUrl, "", headers, String.class);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    @Override
    public void moveDocumentByTenant(String tenantId, String fileId, String targetDirectoryId) {
        this.moveDocumentByTenant(tenantId, null, fileId, targetDirectoryId, null);
    }

    @Override
    public void moveDocumentByTenant(String tenantId, String bucketName, String fileId, String targetDirectoryId) {
        this.moveDocumentByTenant(tenantId, bucketName, fileId, targetDirectoryId, null);
    }

    @Override
    public void moveDocumentByTenant(String tenantId, String bucketName, String fileId, String targetDirectoryId, String driveToken) {
        try {
            if (fileId == null || "".equals(fileId)) {
                throw new IllegalArgumentException("\u53c2\u6570 fileId is null");
            }
            if (StringUtil.isEmpty(targetDirectoryId)) {
                targetDirectoryId = EMPTY_OBJECT_ID_STR;
            }
            if (StringUtil.isEmpty(bucketName)) {
                bucketName = ServerSetting.getBucketName();
            }
            String moveDocumentUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + fileId + "/moveto/directory/" + targetDirectoryId;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (driveToken == null || "".equals(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            if (tenantId != null) {
                headers.put("tenantId", tenantId);
            }
            HttpRequestUtil.postJson(moveDocumentUrl, "", headers, String.class);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    @Override
    public void moveManyDocument(BatchOperationIds operationIds, String targetDirectoryId) {
        this.moveManyDocument(null, operationIds, targetDirectoryId, null);
    }

    @Override
    public void moveManyDocument(String bucketName, BatchOperationIds operationIds, String targetDirectoryId) {
        this.moveManyDocument(bucketName, operationIds, targetDirectoryId, null);
    }

    @Override
    public void moveManyDocument(String bucketName, BatchOperationIds operationIds, String targetDirectoryId, String driveToken) {
        try {
            if (operationIds == null) {
                throw new IllegalArgumentException("\u53c2\u6570 operationIds is null");
            }
            if (StringUtil.isEmpty(targetDirectoryId)) {
                targetDirectoryId = EMPTY_OBJECT_ID_STR;
            }
            if (StringUtil.isEmpty(bucketName)) {
                bucketName = ServerSetting.getBucketName();
            }
            String moveDocumentUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/move/batch/directory/" + targetDirectoryId;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (driveToken == null || "".equals(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            HttpRequestUtil.postJson(moveDocumentUrl, ObjectMapperUtil.writeValueAsString(operationIds), headers, String.class);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    @Override
    public void moveManyDocumentByTenant(String tenantId, BatchOperationIds operationIds, String targetDirectoryId) {
        this.moveManyDocumentByTenant(tenantId, null, operationIds, targetDirectoryId, null);
    }

    @Override
    public void moveManyDocumentByTenant(String tenantId, String bucketName, BatchOperationIds operationIds, String targetDirectoryId) {
        this.moveManyDocumentByTenant(tenantId, bucketName, operationIds, targetDirectoryId, null);
    }

    @Override
    public void moveManyDocumentByTenant(String tenantId, String bucketName, BatchOperationIds operationIds, String targetDirectoryId, String driveToken) {
        try {
            if (operationIds == null) {
                throw new IllegalArgumentException("\u53c2\u6570 operationIds is null");
            }
            if (StringUtil.isEmpty(targetDirectoryId)) {
                targetDirectoryId = EMPTY_OBJECT_ID_STR;
            }
            if (StringUtil.isEmpty(bucketName)) {
                bucketName = ServerSetting.getBucketName();
            }
            String moveDocumentUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/move/batch/directory/" + targetDirectoryId;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (driveToken == null || "".equals(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            if (tenantId != null) {
                headers.put("tenantId", tenantId);
            }
            HttpRequestUtil.postJson(moveDocumentUrl, ObjectMapperUtil.writeValueAsString(operationIds), headers, String.class);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    @Override
    public String copyDocument(String bucketName, String fileId, String targetDirectoryId) {
        return this.copyDocument(bucketName, fileId, targetDirectoryId, null);
    }

    @Override
    public String copyDocument(String fileId, String targetDirectoryId) {
        return this.copyDocument(null, fileId, targetDirectoryId, null);
    }

    @Override
    public String copyDocument(String bucketName, String fileId, String targetDirectoryId, String driveToken) {
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570 fileId is null");
        }
        if (StringUtil.isEmpty(targetDirectoryId)) {
            targetDirectoryId = EMPTY_OBJECT_ID_STR;
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String copyDocumentUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + fileId + "/copyto/directory/" + targetDirectoryId;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            if (driveToken == null || "".equals(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            HashMap responseEntity = HttpRequestUtil.postJson(copyDocumentUrl, "", headers, HashMap.class);
            if (null == responseEntity || !responseEntity.containsKey("id")) {
                return null;
            }
            return responseEntity.get("id").toString();
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public String copyDocumentByTenant(String tenantId, String fileId, String targetDirectoryId) {
        return this.copyDocumentByTenant(tenantId, null, fileId, targetDirectoryId, null);
    }

    @Override
    public String copyDocumentByTenant(String tenantId, String bucketName, String fileId, String targetDirectoryId) {
        return this.copyDocumentByTenant(tenantId, bucketName, fileId, targetDirectoryId, null);
    }

    @Override
    public String copyDocumentByTenant(String tenantId, String bucketName, String fileId, String targetDirectoryId, String driveToken) {
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570 fileId is null");
        }
        if (StringUtil.isEmpty(targetDirectoryId)) {
            targetDirectoryId = EMPTY_OBJECT_ID_STR;
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String copyDocumentUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/" + fileId + "/copyto/directory/" + targetDirectoryId;
        try {
            HashMap responseEntity;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (driveToken == null || "".equals(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            if (tenantId != null) {
                headers.put("tenantId", tenantId);
            }
            if (null == (responseEntity = HttpRequestUtil.postJson(copyDocumentUrl, "", headers, HashMap.class)) || !responseEntity.containsKey("id")) {
                return null;
            }
            return responseEntity.get("id").toString();
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public void copyManyDocument(BatchOperationIds operationIds, String targetDirectoryId) {
        this.copyManyDocument(null, operationIds, targetDirectoryId, null);
    }

    @Override
    public void copyManyDocument(String bucketName, BatchOperationIds operationIds, String targetDirectoryId) {
        this.copyManyDocument(bucketName, operationIds, targetDirectoryId, null);
    }

    @Override
    public void copyManyDocument(String bucketName, BatchOperationIds operationIds, String targetDirectoryId, String driveToken) {
        if (operationIds == null) {
            throw new IllegalArgumentException("\u53c2\u6570 fileId is null");
        }
        if (StringUtil.isEmpty(targetDirectoryId)) {
            targetDirectoryId = EMPTY_OBJECT_ID_STR;
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String copyDocumentUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/copy/batch/directory/" + targetDirectoryId;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            if (driveToken == null || "".equals(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            HttpRequestUtil.postJson(copyDocumentUrl, ObjectMapperUtil.writeValueAsString(operationIds), headers, HashMap.class);
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public void copyManyDocumentByTenant(String tenantId, BatchOperationIds operationIds, String targetDirectoryId) {
        this.copyManyDocumentByTenant(tenantId, null, operationIds, targetDirectoryId, null);
    }

    @Override
    public void copyManyDocumentByTenant(String tenantId, String bucketName, BatchOperationIds operationIds, String targetDirectoryId) {
        this.copyManyDocumentByTenant(tenantId, bucketName, operationIds, targetDirectoryId, null);
    }

    @Override
    public void copyManyDocumentByTenant(String tenantId, String bucketName, BatchOperationIds operationIds, String targetDirectoryId, String driveToken) {
        if (operationIds == null) {
            throw new IllegalArgumentException("\u53c2\u6570 fileId is null");
        }
        if (StringUtil.isEmpty(targetDirectoryId)) {
            targetDirectoryId = EMPTY_OBJECT_ID_STR;
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String copyDocumentUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/files/copy/batch/directory/" + targetDirectoryId;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            if (driveToken == null || "".equals(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            if (tenantId != null) {
                headers.put("tenantId", tenantId);
            }
            HttpRequestUtil.postJson(copyDocumentUrl, ObjectMapperUtil.writeValueAsString(operationIds), headers, HashMap.class);
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public String createDirectory(String bucketName, String directoryName, String parentDirectoryId) {
        return this.createDirectory(bucketName, directoryName, parentDirectoryId, null);
    }

    @Override
    public String createDirectory(String directoryName, String parentDirectoryId) {
        return this.createDirectory(null, directoryName, parentDirectoryId, null);
    }

    @Override
    public String createDirectory(String bucketName, String directoryName, String parentDirectoryId, String driveToken) {
        if (directoryName == null || "".equals(directoryName)) {
            throw new IllegalArgumentException("\u53c2\u6570 directoryName is null");
        }
        if (StringUtil.isEmpty(parentDirectoryId)) {
            parentDirectoryId = EMPTY_OBJECT_ID_STR;
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String directoriesResourceUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys";
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("parentId", parentDirectoryId);
            parameters.put("name", directoryName);
            HashMap<String, String> headers = new HashMap<String, String>();
            if (driveToken == null || "".equals(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            HashMap responseEntity = HttpRequestUtil.postJson(directoriesResourceUrl, ObjectMapperUtil.writeValueAsString(parameters), headers, HashMap.class);
            if (null == responseEntity || !responseEntity.containsKey("dirId")) {
                return null;
            }
            return responseEntity.get("dirId").toString();
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public String createDirectoryByTenant(String tenantId, String directoryName, String parentDirectoryId) {
        return this.createDirectoryByTenant(tenantId, null, directoryName, parentDirectoryId, null);
    }

    @Override
    public String createDirectoryByTenant(String tenantId, String bucketName, String directoryName, String parentDirectoryId) {
        return this.createDirectoryByTenant(tenantId, bucketName, directoryName, parentDirectoryId, null);
    }

    @Override
    public String createDirectoryByTenant(String tenantId, String bucketName, String directoryName, String parentDirectoryId, String driveToken) {
        if (directoryName == null || "".equals(directoryName)) {
            throw new IllegalArgumentException("\u53c2\u6570 directoryName is null");
        }
        if (StringUtil.isEmpty(parentDirectoryId)) {
            parentDirectoryId = EMPTY_OBJECT_ID_STR;
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String directoriesResourceUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys";
        try {
            HashMap responseEntity;
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("parentId", parentDirectoryId);
            parameters.put("name", directoryName);
            HashMap<String, String> headers = new HashMap<String, String>();
            if (driveToken == null || "".equals(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            if (tenantId != null) {
                headers.put("tenantId", tenantId);
            }
            if (null == (responseEntity = HttpRequestUtil.postJson(directoriesResourceUrl, ObjectMapperUtil.writeValueAsString(parameters), headers, HashMap.class)) || !responseEntity.containsKey("dirId")) {
                return null;
            }
            return responseEntity.get("dirId").toString();
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public DirInfo getDirectoryInfo(String bucketName, String directoryId) {
        return this.getDirectoryInfo(bucketName, directoryId, null);
    }

    @Override
    public DirInfo getDirectoryInfo(String directoryId) {
        return this.getDirectoryInfo(null, directoryId, null);
    }

    @Override
    public DirInfo getDirectoryInfo(String bucketName, String directoryId, String driveToken) {
        if (directoryId == null || "".equals(directoryId)) {
            throw new IllegalArgumentException("\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String documentInfoUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys/" + directoryId;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.get(documentInfoUrl, headers, DirInfo.class);
    }

    @Override
    public DirInfo getDirectoryInfoByTenant(String tenantId, String directoryId) {
        return this.getDirectoryInfoByTenant(tenantId, null, directoryId, null);
    }

    @Override
    public DirInfo getDirectoryInfoByTenant(String tenantId, String bucketName, String directoryId) {
        return this.getDirectoryInfoByTenant(tenantId, bucketName, directoryId, null);
    }

    @Override
    public DirInfo getDirectoryInfoByTenant(String tenantId, String bucketName, String directoryId, String driveToken) {
        if (directoryId == null || "".equals(directoryId)) {
            throw new IllegalArgumentException("\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String documentInfoUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys/" + directoryId;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        if (tenantId != null) {
            headers.put("tenantId", tenantId);
        }
        return HttpRequestUtil.get(documentInfoUrl, headers, DirInfo.class);
    }

    @Override
    public String deleteDirectory(String bucketName, String directoryId) {
        return this.deleteDirectory(bucketName, directoryId, null);
    }

    @Override
    public String deleteDirectory(String directoryId) {
        return this.deleteDirectory(null, directoryId, null);
    }

    @Override
    public String deleteDirectory(String bucketName, String directoryId, String driveToken) {
        if (directoryId == null || "".equals(directoryId)) {
            throw new IllegalArgumentException("\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String deleteDirectoryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys/" + directoryId;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        HashMap responseEntity = HttpRequestUtil.delete(deleteDirectoryUrl, headers, HashMap.class);
        if (null == responseEntity || !responseEntity.containsKey("recycleBinId")) {
            return null;
        }
        return responseEntity.get("recycleBinId").toString();
    }

    @Override
    public String deleteDirectoryByTenant(String tenantId, String directoryId) {
        return this.deleteDirectoryByTenant(tenantId, null, directoryId, null);
    }

    @Override
    public String deleteDirectoryByTenant(String tenantId, String bucketName, String directoryId) {
        return this.deleteDirectoryByTenant(tenantId, bucketName, directoryId, null);
    }

    @Override
    public String deleteDirectoryByTenant(String tenantId, String bucketName, String directoryId, String driveToken) {
        HashMap responseEntity;
        if (directoryId == null || "".equals(directoryId)) {
            throw new IllegalArgumentException("\u8bf7\u68c0\u67e5\u53c2\u6570");
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String deleteDirectoryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys/" + directoryId;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        if (tenantId != null) {
            headers.put("tenantId", tenantId);
        }
        if (null == (responseEntity = HttpRequestUtil.delete(deleteDirectoryUrl, headers, HashMap.class)) || !responseEntity.containsKey("recycleBinId")) {
            return null;
        }
        return responseEntity.get("recycleBinId").toString();
    }

    @Override
    public void updateDirectory(String bucketName, String directoryId, String directoryName) {
        this.updateDirectory(bucketName, directoryId, directoryName, null);
    }

    @Override
    public void updateDirectory(String directoryId, String directoryName) {
        this.updateDirectory(null, directoryId, directoryName, null);
    }

    @Override
    public void updateDirectory(String bucketName, String directoryId, String directoryName, String driveToken) {
        try {
            if (directoryId == null || "".equals(directoryId) || directoryName == null || "".equals(directoryName)) {
                throw new IllegalArgumentException("\u8bf7\u68c0\u67e5\u53c2\u6570");
            }
            if (StringUtil.isEmpty(bucketName)) {
                bucketName = ServerSetting.getBucketName();
            }
            String updateDirectoryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys/" + directoryId + "/rename/" + directoryName;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (driveToken == null || "".equals(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            HttpRequestUtil.postJson(updateDirectoryUrl, "", headers, String.class);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    @Override
    public void updateDirectoryByTenant(String tenantId, String directoryId, String directoryName) {
        this.updateDirectoryByTenant(tenantId, null, directoryId, directoryName, null);
    }

    @Override
    public void updateDirectoryByTenant(String tenantId, String bucketName, String directoryId, String directoryName) {
        this.updateDirectoryByTenant(tenantId, bucketName, directoryId, directoryName, null);
    }

    @Override
    public void updateDirectoryByTenant(String tenantId, String bucketName, String directoryId, String directoryName, String driveToken) {
        try {
            if (directoryId == null || "".equals(directoryId) || directoryName == null || "".equals(directoryName)) {
                throw new IllegalArgumentException("\u8bf7\u68c0\u67e5\u53c2\u6570");
            }
            if (StringUtil.isEmpty(bucketName)) {
                bucketName = ServerSetting.getBucketName();
            }
            String updateDirectoryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys/" + directoryId + "/rename/" + directoryName;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (driveToken == null || "".equals(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            if (tenantId != null) {
                headers.put("tenantId", tenantId);
            }
            HttpRequestUtil.postJson(updateDirectoryUrl, "", headers, String.class);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    @Override
    public void moveDirectory(String bucketName, String directoryId, String targetDirectoryId) {
        this.moveDirectory(bucketName, directoryId, targetDirectoryId, null);
    }

    @Override
    public void moveDirectory(String directoryId, String targetDirectoryId) {
        this.moveDirectory(null, directoryId, targetDirectoryId, null);
    }

    @Override
    public void moveDirectory(String bucketName, String directoryId, String targetDirectoryId, String driveToken) {
        try {
            if (directoryId == null || "".equals(directoryId)) {
                throw new IllegalArgumentException("\u53c2\u6570directoryId is null");
            }
            if (targetDirectoryId == null || "".equals(targetDirectoryId)) {
                directoryId = EMPTY_OBJECT_ID_STR;
            }
            if (StringUtil.isEmpty(bucketName)) {
                bucketName = ServerSetting.getBucketName();
            }
            String moveDirectoryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys/" + directoryId + "/moveto/" + targetDirectoryId;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (driveToken == null || "".equals(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            HttpRequestUtil.postJson(moveDirectoryUrl, "", headers, String.class);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    @Override
    public void moveDirectoryByTenant(String tenantId, String directoryId, String targetDirectoryId) {
        this.moveDirectoryByTenant(tenantId, null, directoryId, targetDirectoryId, null);
    }

    @Override
    public void moveDirectoryByTenant(String tenantId, String bucketName, String directoryId, String targetDirectoryId) {
        this.moveDirectoryByTenant(tenantId, bucketName, directoryId, targetDirectoryId, null);
    }

    @Override
    public void moveDirectoryByTenant(String tenantId, String bucketName, String directoryId, String targetDirectoryId, String driveToken) {
        try {
            if (directoryId == null || "".equals(directoryId)) {
                throw new IllegalArgumentException("\u53c2\u6570directoryId is null");
            }
            if (targetDirectoryId == null || "".equals(targetDirectoryId)) {
                directoryId = EMPTY_OBJECT_ID_STR;
            }
            if (StringUtil.isEmpty(bucketName)) {
                bucketName = ServerSetting.getBucketName();
            }
            String moveDirectoryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys/" + directoryId + "/moveto/" + targetDirectoryId;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (driveToken == null || "".equals(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            if (tenantId != null) {
                headers.put("tenantId", tenantId);
            }
            HttpRequestUtil.postJson(moveDirectoryUrl, "", headers, String.class);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    @Override
    public String copyDirectory(String bucketName, String directoryId, String targetDirectoryId) {
        return this.copyDirectory(bucketName, directoryId, targetDirectoryId, null);
    }

    @Override
    public String copyDirectory(String directoryId, String targetDirectoryId) {
        return this.copyDirectory(null, directoryId, targetDirectoryId, null);
    }

    @Override
    public String copyDirectory(String bucketName, String directoryId, String targetDirectoryId, String driveToken) {
        if (directoryId == null || "".equals(directoryId)) {
            throw new IllegalArgumentException("\u53c2\u6570directoryId is null");
        }
        if (targetDirectoryId == null || "".equals(targetDirectoryId)) {
            directoryId = EMPTY_OBJECT_ID_STR;
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String copyDirectoryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys/" + directoryId + "/copyto/" + targetDirectoryId;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            if (driveToken == null || "".equals(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            HashMap responseEntity = HttpRequestUtil.postJson(copyDirectoryUrl, "", headers, HashMap.class);
            if (responseEntity == null || !responseEntity.containsKey("dirId")) {
                return null;
            }
            return responseEntity.get("dirId").toString();
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public String copyDirectoryByTenant(String tenantId, String directoryId, String targetDirectoryId) {
        return this.copyDirectoryByTenant(tenantId, null, directoryId, targetDirectoryId, null);
    }

    @Override
    public String copyDirectoryByTenant(String tenantId, String bucketName, String directoryId, String targetDirectoryId) {
        return this.copyDirectoryByTenant(tenantId, bucketName, directoryId, targetDirectoryId, null);
    }

    @Override
    public String copyDirectoryByTenant(String tenantId, String bucketName, String directoryId, String targetDirectoryId, String driveToken) {
        if (directoryId == null || "".equals(directoryId)) {
            throw new IllegalArgumentException("\u53c2\u6570directoryId is null");
        }
        if (targetDirectoryId == null || "".equals(targetDirectoryId)) {
            directoryId = EMPTY_OBJECT_ID_STR;
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String copyDirectoryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys/" + directoryId + "/copyto/" + targetDirectoryId;
        try {
            HashMap responseEntity;
            HashMap<String, String> headers = new HashMap<String, String>();
            if (driveToken == null || "".equals(driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
            }
            if (tenantId != null) {
                headers.put("tenantId", tenantId);
            }
            if ((responseEntity = HttpRequestUtil.postJson(copyDirectoryUrl, "", headers, HashMap.class)) == null || !responseEntity.containsKey("dirId")) {
                return null;
            }
            return responseEntity.get("dirId").toString();
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public ContentsResult listContents(String bucketName, String directoryId) {
        return this.listContents(bucketName, directoryId, null);
    }

    @Override
    public ContentsResult listContents(String directoryId) {
        return this.listContents(null, directoryId, null);
    }

    @Override
    public ContentsResult listContents(String bucketName, String directoryId, String driveToken) {
        if (directoryId == null || "".equals(directoryId)) {
            directoryId = EMPTY_OBJECT_ID_STR;
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String listContentsUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys/" + directoryId + "/list";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        ContentsResult responseEntity = HttpRequestUtil.get(listContentsUrl, headers, ContentsResult.class);
        if (null == responseEntity) {
            return null;
        }
        return responseEntity;
    }

    @Override
    public ContentsResult listContentsByTenant(String tenantId, String directoryId) {
        return this.listContentsByTenant(tenantId, null, directoryId, null);
    }

    @Override
    public ContentsResult listContentsByTenant(String tenantId, String bucketName, String directoryId) {
        return this.listContentsByTenant(tenantId, bucketName, directoryId, null);
    }

    @Override
    public ContentsResult listContentsByTenant(String tenantId, String bucketName, String directoryId, String driveToken) {
        ContentsResult responseEntity;
        if (directoryId == null || "".equals(directoryId)) {
            directoryId = EMPTY_OBJECT_ID_STR;
        }
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String listContentsUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/directorys/" + directoryId + "/list";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        if (tenantId != null) {
            headers.put("tenantId", tenantId);
        }
        if (null == (responseEntity = HttpRequestUtil.get(listContentsUrl, headers, ContentsResult.class))) {
            return null;
        }
        return responseEntity;
    }

    @Override
    public QueryResult queryFileInfoByFileInfoQuery(FileInfoQuery query) {
        return this.queryFileInfoByFileInfoQuery(null, query, null);
    }

    @Override
    public QueryResult queryFileInfoByFileInfoQuery(String bucketName, FileInfoQuery query) {
        return this.queryFileInfoByFileInfoQuery(bucketName, query, null);
    }

    @Override
    public QueryResult queryFileInfoByFileInfoQuery(String bucketName, FileInfoQuery query, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String queryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/query";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        try {
            String json = ObjectMapperUtil.writeValueAsString(query);
            QueryResult responseEntity = HttpRequestUtil.postJson(queryUrl, json, headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public QueryResult queryFileInfoByFileInfoQueryByTenant(String tenantId, String bucketName, FileInfoQuery query, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String queryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/query";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        if (tenantId != null) {
            headers.put("tenantId", tenantId);
        }
        try {
            String json = ObjectMapperUtil.writeValueAsString(query);
            QueryResult responseEntity = HttpRequestUtil.postJson(queryUrl, json, headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public QueryResult queryFileInfoByFileInfoQueryByTenant(String tenantId, String bucketName, FileInfoQuery query) {
        return this.queryFileInfoByFileInfoQueryByTenant(tenantId, bucketName, query, null);
    }

    @Override
    public QueryResult queryFileInfoByFileInfoQueryByTenant(String tenantId, FileInfoQuery query) {
        return this.queryFileInfoByFileInfoQueryByTenant(tenantId, null, query, null);
    }

    @Override
    public QueryResult queryFileInfoByField(String field, String value) {
        return this.queryFileInfoByField(null, field, value, null);
    }

    @Override
    public QueryResult queryFileInfoByField(String bucketName, String field, String value) {
        return this.queryFileInfoByField(bucketName, field, value, null);
    }

    @Override
    public QueryResult queryFileInfoByField(String bucketName, String field, String value, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String queryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/query/fields/" + field + "/values/" + value + "/";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        try {
            QueryResult responseEntity = HttpRequestUtil.get(queryUrl, headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public QueryResult queryFileInfoByFieldByTenant(String tenantId, String bucketName, String field, String value, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String queryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/query/fields/" + field + "/values/" + value + "/";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        if (tenantId != null) {
            headers.put("tenantId", tenantId);
        }
        try {
            QueryResult responseEntity = HttpRequestUtil.get(queryUrl, headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public QueryResult queryFileInfoByFieldByTenant(String tenantId, String bucketName, String field, String value) {
        return this.queryFileInfoByFieldByTenant(tenantId, bucketName, field, value, null);
    }

    @Override
    public QueryResult queryFileInfoByFieldByTenant(String tenantId, String field, String value) {
        return this.queryFileInfoByFieldByTenant(tenantId, null, field, value, null);
    }

    @Override
    public QueryResult queryFileInfoByFieldWithPage(String field, String value, String pageNum, String pageSize) {
        return this.queryFileInfoByFieldWithPage(null, field, value, pageNum, pageSize, null);
    }

    @Override
    public QueryResult queryFileInfoByFieldWithPage(String bucketName, String field, String value, String pageNum, String pageSize) {
        return this.queryFileInfoByFieldWithPage(bucketName, field, value, pageNum, pageSize, null);
    }

    @Override
    public QueryResult queryFileInfoByFieldWithPage(String bucketName, String field, String value, String pageNum, String pageSize, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String queryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/query/fields/" + field + "/values/" + value + "/" + pageNum + "/" + pageSize;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        try {
            QueryResult responseEntity = HttpRequestUtil.get(queryUrl, headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public QueryResult queryFileInfoByFieldWithPageByTenant(String tenantId, String bucketName, String field, String value, String pageNum, String pageSize, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String queryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/query/fields/" + field + "/values/" + value + "/" + pageNum + "/" + pageSize;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        if (tenantId != null) {
            headers.put("tenantId", tenantId);
        }
        try {
            QueryResult responseEntity = HttpRequestUtil.get(queryUrl, headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public QueryResult queryFileInfoByFieldWithPageByTenant(String tenantId, String bucketName, String field, String value, String pageNum, String pageSize) {
        return this.queryFileInfoByFieldWithPageByTenant(tenantId, bucketName, field, value, pageNum, pageSize, null);
    }

    @Override
    public QueryResult queryFileInfoByFieldWithPageByTenant(String tenantId, String field, String value, String pageNum, String pageSize) {
        return this.queryFileInfoByFieldWithPageByTenant(tenantId, null, field, value, pageNum, pageSize, null);
    }

    @Override
    public QueryResult queryFileInfoByOperatorWithPage(String field, String operator, String value, String pageNum, String pageSize) {
        return this.queryFileInfoByOperatorWithPage(null, field, operator, value, pageNum, pageSize, null);
    }

    @Override
    public QueryResult queryFileInfoByOperatorWithPage(String bucketName, String field, String operator, String value, String pageNum, String pageSize) {
        return this.queryFileInfoByOperatorWithPage(bucketName, field, operator, value, pageNum, pageSize, null);
    }

    @Override
    public QueryResult queryFileInfoByOperatorWithPage(String bucketName, String field, String operator, String value, String pageNum, String pageSize, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String queryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/query/fields/" + field + "/operators/" + operator + "/values/" + value + "/" + pageNum + "/" + pageSize;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        try {
            QueryResult responseEntity = HttpRequestUtil.get(queryUrl, headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public QueryResult queryFileInfoByOperatorWithPageByTenant(String tenantId, String bucketName, String field, String operator, String value, String pageNum, String pageSize, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String queryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/query/fields/" + field + "/operators/" + operator + "/values/" + value + "/" + pageNum + "/" + pageSize;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        if (tenantId != null) {
            headers.put("tenantId", tenantId);
        }
        try {
            QueryResult responseEntity = HttpRequestUtil.get(queryUrl, headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public QueryResult queryFileInfoByOperatorWithPageByTenant(String tenantId, String bucketName, String field, String operator, String value, String pageNum, String pageSize) {
        return this.queryFileInfoByOperatorWithPageByTenant(tenantId, bucketName, field, operator, value, pageNum, pageSize, null);
    }

    @Override
    public QueryResult queryFileInfoByOperatorWithPageByTenant(String tenantId, String field, String operator, String value, String pageNum, String pageSize) {
        return this.queryFileInfoByOperatorWithPageByTenant(tenantId, null, field, operator, value, pageNum, pageSize, null);
    }

    @Override
    public QueryResult queryFileInfoByOperator(String field, String operator, String value) {
        return this.queryFileInfoByOperator(null, field, operator, value, null);
    }

    @Override
    public QueryResult queryFileInfoByOperator(String bucketName, String field, String operator, String value) {
        return this.queryFileInfoByOperator(bucketName, field, operator, value, null);
    }

    @Override
    public QueryResult queryFileInfoByOperator(String bucketName, String field, String operator, String value, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String queryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/query/fields/" + field + "/operators/" + operator + "/values/" + value + "/";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        try {
            QueryResult responseEntity = HttpRequestUtil.get(queryUrl, headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public QueryResult queryFileInfoByOperatorByTenant(String tenantId, String bucketName, String field, String operator, String value, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String queryUrl = DmcUrl.getDirectoriesResourceUrl() + bucketName + "/query/fields/" + field + "/operators/" + operator + "/values/" + value + "/";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        if (tenantId != null) {
            headers.put("tenantId", tenantId);
        }
        try {
            QueryResult responseEntity = HttpRequestUtil.get(queryUrl, headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public QueryResult queryFileInfoByOperatorByTenant(String tenantId, String bucketName, String field, String operator, String value) {
        return this.queryFileInfoByOperatorByTenant(tenantId, bucketName, field, operator, value, null);
    }

    @Override
    public QueryResult queryFileInfoByOperatorByTenant(String tenantId, String field, String operator, String value) {
        return this.queryFileInfoByOperatorByTenant(tenantId, null, field, operator, value, null);
    }

    @Override
    public QueryResult queryFileInfoByFullText(FullTextCondition search) {
        return this.queryFileInfoByFullText(null, search, null);
    }

    @Override
    public QueryResult queryFileInfoByFullText(String bucketName, FullTextCondition search) {
        return this.queryFileInfoByFullText(bucketName, search, null);
    }

    @Override
    public QueryResult queryFileInfoByFullText(String bucketName, FullTextCondition search, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String queryUrl = DmcUrl.getResourceUrl() + "/buckets/" + bucketName + "/query/fulltext";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        try {
            QueryResult responseEntity = HttpRequestUtil.postJson(queryUrl, ObjectMapperUtil.writeValueAsString(search), headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public QueryResult queryFileInfoByFullTextByTenant(String tenantId, String bucketName, FullTextCondition search, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String queryUrl = DmcUrl.getResourceUrl() + "/buckets/" + bucketName + "/query/fulltext";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        if (tenantId != null) {
            headers.put("tenantId", tenantId);
        }
        try {
            QueryResult responseEntity = HttpRequestUtil.postJson(queryUrl, ObjectMapperUtil.writeValueAsString(search), headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public QueryResult queryFileInfoByFullTextByTenant(String tenantId, String bucketName, FullTextCondition search) {
        return this.queryFileInfoByFullTextByTenant(tenantId, bucketName, search, null);
    }

    @Override
    public QueryResult queryFileInfoByFullTextByTenant(String tenantId, FullTextCondition search) {
        return this.queryFileInfoByFullTextByTenant(tenantId, null, search, null);
    }

    @Override
    public QueryResult queryFileInfoByFullText(FullTextCondition search, String accessToken) {
        String queryUrl = DmcUrl.getResourceUrl() + "/query/fulltext";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(SDKConstants.HttpHeaderAccessTokenKey, accessToken);
        try {
            QueryResult responseEntity = HttpRequestUtil.postJson(queryUrl, ObjectMapperUtil.writeValueAsString(search), headers, QueryResult.class);
            return responseEntity;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    static {
        userManagerService = UserManagerService.userInstance();
    }
}

