/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.impl;

import com.digiwin.dmc.sdk.config.DmcUrl;
import com.digiwin.dmc.sdk.config.SDKConstants;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.ImageCacheFile;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.IHandleImageService;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.service.impl.UserManagerService;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.ObjectMapperUtil;
import com.digiwin.dmc.sdk.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HandleImageService
implements IHandleImageService {
    private static IHandleImageService handleImageService;
    private static IUserManagerService userManagerService;

    public static IHandleImageService handleImageInstance() {
        if (handleImageService == null) {
            handleImageService = new HandleImageService();
        }
        return handleImageService;
    }

    @Override
    public byte[] dealImagePng(String bucketName, String fileId, int scale, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/0/scale/" + scale;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImagePng(String bucketName, String fileId, int scale) {
        return this.dealImagePng(bucketName, fileId, scale, null);
    }

    @Override
    public byte[] dealImagePng(String fileId, int scale) {
        return this.dealImagePng(null, fileId, scale, null);
    }

    @Override
    public byte[] dealImageRound(String bucketName, String fileId, int scale, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/0/scale/" + scale + "/" + cornerRadius;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageRound(String bucketName, String fileId, int scale, int cornerRadius) {
        return this.dealImageRound(bucketName, fileId, scale, cornerRadius, null);
    }

    @Override
    public byte[] dealImageRound(String fileId, int scale, int cornerRadius) {
        return this.dealImageRound(null, fileId, scale, cornerRadius, null);
    }

    @Override
    public byte[] dealImage(String bucketName, String fileId, int scale, String format, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/0/scale/" + scale + "/format/" + format;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImage(String bucketName, String fileId, int scale, String format) {
        return this.dealImage(bucketName, fileId, scale, format, null);
    }

    @Override
    public byte[] dealImage(String fileId, int scale, String format) {
        return this.dealImage(null, fileId, scale, format, null);
    }

    @Override
    public byte[] dealImageSetWidth(String bucketName, String fileId, int width, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/0/w/" + width;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageSetWidth(String bucketName, String fileId, int width) {
        return this.dealImage(bucketName, fileId, width, null);
    }

    @Override
    public byte[] dealImageSetWidth(String fileId, int width) {
        return this.dealImage(null, fileId, width, null);
    }

    @Override
    public byte[] dealImageSetWidthRound(String bucketName, String fileId, int width, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/0/w/" + width + "/" + cornerRadius;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageSetWidthRound(String bucketName, String fileId, int width, int cornerRadius) {
        return this.dealImageSetWidthRound(bucketName, fileId, width, cornerRadius, null);
    }

    @Override
    public byte[] dealImageSetWidthRound(String fileId, int width, int cornerRadius) {
        return this.dealImageSetWidthRound(null, fileId, width, cornerRadius, null);
    }

    @Override
    public byte[] dealImageSetWidthFormat(String bucketName, String fileId, int width, String format, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/0/w/" + width + "/format/" + format;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageSetWidthFormat(String bucketName, String fileId, int width, String format) {
        return this.dealImageSetWidthFormat(bucketName, fileId, width, format, null);
    }

    @Override
    public byte[] dealImageSetWidthFormat(String fileId, int width, String format) {
        return this.dealImageSetWidthFormat(null, fileId, width, format, null);
    }

    @Override
    public byte[] dealImageSetHeight(String bucketName, String fileId, int height, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/0/h/" + height;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageSetHeight(String bucketName, String fileId, int height) {
        return this.dealImageSetHeight(bucketName, fileId, height, null);
    }

    @Override
    public byte[] dealImageSetHeight(String fileId, int height) {
        return this.dealImageSetHeight(null, fileId, height, null);
    }

    @Override
    public byte[] dealImageSetHeightRound(String bucketName, String fileId, int height, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/0/h/" + height + "/" + cornerRadius;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageSetHeightRound(String bucketName, String fileId, int height, int cornerRadius) {
        return this.dealImageSetHeightRound(bucketName, fileId, height, cornerRadius, null);
    }

    @Override
    public byte[] dealImageSetHeightRound(String fileId, int height, int cornerRadius) {
        return this.dealImageSetHeightRound(null, fileId, height, cornerRadius, null);
    }

    @Override
    public byte[] dealImageSetHeightFormat(String bucketName, String fileId, int height, String format, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/0/h/" + height + "/format/" + format;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageSetHeightFormat(String bucketName, String fileId, int height, String format) {
        return this.dealImageSetHeightFormat(bucketName, fileId, height, format, null);
    }

    @Override
    public byte[] dealImageSetHeightFormat(String fileId, int height, String format) {
        return this.dealImageSetHeightFormat(null, fileId, height, format, null);
    }

    @Override
    public byte[] dealImageClipPng(String bucketName, String fileId, int width, int height, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/1/w/" + width + "/h/" + height;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageClipPng(String bucketName, String fileId, int width, int height) {
        return this.dealImageClipPng(bucketName, fileId, width, height, null);
    }

    @Override
    public byte[] dealImageClipPng(String fileId, int width, int height) {
        return this.dealImageClipPng(null, fileId, width, height, null);
    }

    @Override
    public byte[] dealImageClipRound(String bucketName, String fileId, int width, int height, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/1/w/" + width + "/h/" + height + "/" + cornerRadius;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageClipRound(String bucketName, String fileId, int width, int height, int cornerRadius) {
        return this.dealImageClipRound(bucketName, fileId, width, height, cornerRadius, null);
    }

    @Override
    public byte[] dealImageClipRound(String fileId, int width, int height, int cornerRadius) {
        return this.dealImageClipRound(null, fileId, width, height, cornerRadius, null);
    }

    @Override
    public byte[] dealImageClipFormat(String bucketName, String fileId, int width, int height, String format, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/1/w/" + width + "/h/" + height + "/format/" + format;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageClipFormat(String bucketName, String fileId, int width, int height, String format) {
        return this.dealImageClipFormat(bucketName, fileId, width, height, format, null);
    }

    @Override
    public byte[] dealImageClipFormat(String fileId, int width, int height, String format) {
        return this.dealImageClipFormat(null, fileId, width, height, format, null);
    }

    @Override
    public byte[] dealImageClipSetWidth(String bucketName, String fileId, int width, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/1/w/" + width;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageClipSetWidth(String bucketName, String fileId, int width) {
        return this.dealImageClipSetWidth(bucketName, fileId, width, null);
    }

    @Override
    public byte[] dealImageClipSetWidth(String fileId, int width) {
        return this.dealImageClipSetWidth(null, fileId, width, null);
    }

    @Override
    public byte[] dealImageClipSetWidthRound(String bucketName, String fileId, int width, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/1/w/" + width + "/" + cornerRadius;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageClipSetWidthRound(String bucketName, String fileId, int width, int cornerRadius) {
        return this.dealImageClipSetWidthRound(bucketName, fileId, width, cornerRadius, null);
    }

    @Override
    public byte[] dealImageClipSetWidthRound(String fileId, int width, int cornerRadius) {
        return this.dealImageClipSetWidthRound(null, fileId, width, cornerRadius, null);
    }

    @Override
    public byte[] dealImageClipSetWidthFormat(String bucketName, String fileId, int width, String format, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/1/w/" + width + "/format/" + format;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageClipSetWidthFormat(String bucketName, String fileId, int width, String format) {
        return this.dealImageClipSetWidthFormat(bucketName, fileId, width, format, null);
    }

    @Override
    public byte[] dealImageClipSetWidthFormat(String fileId, int width, String format) {
        return this.dealImageClipSetWidthFormat(null, fileId, width, format, null);
    }

    @Override
    public byte[] dealImageClipSetHeight(String bucketName, String fileId, int height, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/1/h/" + height;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageClipSetHeight(String bucketName, String fileId, int height) {
        return this.dealImageClipSetHeight(bucketName, fileId, height, null);
    }

    @Override
    public byte[] dealImageClipSetHeight(String fileId, int height) {
        return this.dealImageClipSetHeight(null, fileId, height, null);
    }

    @Override
    public byte[] dealImageClipSetHeightRound(String bucketName, String fileId, int height, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/1/h/" + height + "/" + cornerRadius;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageClipSetHeightRound(String bucketName, String fileId, int height, int cornerRadius) {
        return this.dealImageClipSetHeightRound(bucketName, fileId, height, cornerRadius, null);
    }

    @Override
    public byte[] dealImageClipSetHeightRound(String fileId, int height, int cornerRadius) {
        return this.dealImageClipSetHeightRound(null, fileId, height, cornerRadius, null);
    }

    @Override
    public byte[] dealImageClipSetHeightFormat(String bucketName, String fileId, int height, String format, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/1/h/" + height + "/format/" + format;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageClipSetHeightFormat(String bucketName, String fileId, int height, String format) {
        return this.dealImageClipSetHeightFormat(bucketName, fileId, height, format, null);
    }

    @Override
    public byte[] dealImageClipSetHeightFormat(String fileId, int height, String format) {
        return this.dealImageClipSetHeightFormat(null, fileId, height, format, null);
    }

    @Override
    public byte[] dealImageLarger(String bucketName, String fileId, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/larger/" + cornerRadius;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageLarger(String bucketName, String fileId, int cornerRadius) {
        return this.dealImageLarger(bucketName, fileId, cornerRadius, null);
    }

    @Override
    public byte[] dealImageLarger(String fileId, int cornerRadius) {
        return this.dealImageLarger(null, fileId, cornerRadius, null);
    }

    @Override
    public byte[] dealImageLarge(String bucketName, String fileId, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/large/" + cornerRadius;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageLarge(String bucketName, String fileId, int cornerRadius) {
        return this.dealImageLarge(bucketName, fileId, cornerRadius, null);
    }

    @Override
    public byte[] dealImageLarge(String fileId, int cornerRadius) {
        return this.dealImageLarge(null, fileId, cornerRadius, null);
    }

    @Override
    public byte[] dealImageMiddle(String bucketName, String fileId, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/middle/" + cornerRadius;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageMiddle(String bucketName, String fileId, int cornerRadius) {
        return this.dealImageMiddle(bucketName, fileId, cornerRadius, null);
    }

    @Override
    public byte[] dealImageMiddle(String fileId, int cornerRadius) {
        return this.dealImageMiddle(null, fileId, cornerRadius, null);
    }

    @Override
    public byte[] dealImageSmall(String bucketName, String fileId, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/small/" + cornerRadius;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageSmall(String bucketName, String fileId, int cornerRadius) {
        return this.dealImageSmall(bucketName, fileId, cornerRadius, null);
    }

    @Override
    public byte[] dealImageSmall(String fileId, int cornerRadius) {
        return this.dealImageMiddle(null, fileId, cornerRadius, null);
    }

    @Override
    public byte[] dealImageSmaller(String bucketName, String fileId, int cornerRadius, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/smaller/" + cornerRadius;
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageSmaller(String bucketName, String fileId, int cornerRadius) {
        return this.dealImageSmaller(bucketName, fileId, cornerRadius, null);
    }

    @Override
    public byte[] dealImageSmaller(String fileId, int cornerRadius) {
        return this.dealImageSmaller(null, fileId, cornerRadius, null);
    }

    @Override
    public byte[] dealImageForAndroid(String bucketName, String fileId, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/forAndroid";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageForAndroid(String bucketName, String fileId) {
        return this.dealImageForAndroid(bucketName, fileId, null);
    }

    @Override
    public byte[] dealImageForAndroid(String fileId) {
        return this.dealImageForAndroid(null, fileId, null);
    }

    @Override
    public byte[] dealImageForPad(String bucketName, String fileId, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/forPad";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageForPad(String bucketName, String fileId) {
        return this.dealImageForPad(bucketName, fileId, null);
    }

    @Override
    public byte[] dealImageForPad(String fileId) {
        return this.dealImageForPad(null, fileId, null);
    }

    @Override
    public byte[] dealImageForIos(String bucketName, String fileId, String driveToken) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        if (fileId == null || "".equals(fileId)) {
            throw new IllegalArgumentException("\u53c2\u6570fileId is null");
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/images/" + fileId + "/view/forIos";
        HashMap<String, String> headers = new HashMap<String, String>();
        if (driveToken == null || "".equals(driveToken)) {
            String userToken = userManagerService.getUserToken(ServerSetting.getUser());
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        } else {
            headers.put(SDKConstants.HttpHeaderDriveTokenKey, driveToken);
        }
        return HttpRequestUtil.getByte(handleImageUrl, headers);
    }

    @Override
    public byte[] dealImageForIos(String bucketName, String fileId) {
        return this.dealImageForIos(bucketName, fileId, null);
    }

    @Override
    public byte[] dealImageForIos(String fileId) {
        return this.dealImageForIos(null, fileId, null);
    }

    @Override
    public List<ImageCacheFile> findImageCacheFiles(String bucketName) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/imageCacheFiles";
        HashMap<String, String> headers = new HashMap<String, String>();
        String userToken = userManagerService.getUserToken(ServerSetting.getUser());
        headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        ArrayList imageCacheFiles = HttpRequestUtil.get(handleImageUrl, headers, ArrayList.class);
        ArrayList<ImageCacheFile> imageCacheFileList = new ArrayList<ImageCacheFile>();
        if (null == imageCacheFiles) {
            return null;
        }
        for (Object imageCacheFile : imageCacheFiles) {
            try {
                String json = ObjectMapperUtil.writeValueAsString(imageCacheFile);
                ImageCacheFile cacheFile = ObjectMapperUtil.readValue(json, ImageCacheFile.class);
                imageCacheFileList.add(cacheFile);
            }
            catch (IOException e) {
                throw new OperateException(e);
            }
        }
        return imageCacheFileList;
    }

    @Override
    public List<ImageCacheFile> findImageCacheFiles() {
        return this.findImageCacheFiles(null);
    }

    @Override
    public void clean(String bucketName) {
        if (StringUtil.isEmpty(bucketName)) {
            bucketName = ServerSetting.getBucketName();
        }
        String handleImageUrl = DmcUrl.getFilesResourceUrl() + bucketName + "/imageCacheFilesClean";
        HashMap<String, String> headers = new HashMap<String, String>();
        String userToken = userManagerService.getUserToken(ServerSetting.getUser());
        headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        HttpRequestUtil.delete(handleImageUrl, headers, null);
    }

    @Override
    public void clean() {
        this.clean(null);
    }

    static {
        userManagerService = UserManagerService.userInstance();
    }
}

