/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.impl;

import com.digiwin.dmc.sdk.config.DmcUrl;
import com.digiwin.dmc.sdk.config.SDKConstants;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.UserInfo;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.identity.UserIdentity;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.JwtUtil;
import com.digiwin.dmc.sdk.util.ObjectMapperUtil;
import com.digiwin.dmc.sdk.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UserManagerService
implements IUserManagerService {
    private static UserManagerService userManagerService;
    HashMap<Integer, String> cache = new HashMap();

    public static IUserManagerService userInstance() {
        if (userManagerService == null) {
            userManagerService = new UserManagerService();
        }
        return userManagerService;
    }

    @Override
    public String createUser(UserInfo userInfo) {
        String identityUrl = DmcUrl.getUserResourceUrl();
        String userToken = this.getUserToken(ServerSetting.getAdmin());
        if (StringUtil.checkSpecialId(userInfo.getName())) {
            throw new IllegalArgumentException("userName\u4e3a\u7a7a\u6216\u5305\u542b\u7279\u6b8a\u5b57\u7b26.\u53f7\uff01");
        }
        HashMap<String, String> userObj = new HashMap<String, String>();
        userObj.put("name", userInfo.getName());
        userObj.put("pwdHash", userInfo.getPassword());
        userObj.put("displayName", userInfo.getDisplayName());
        userObj.put("builtinRole", userInfo.getRole().toString());
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            HashMap responseEntity = HttpRequestUtil.postJson(identityUrl, ObjectMapperUtil.writeValueAsString(userObj), headers, HashMap.class);
            if (responseEntity == null || !responseEntity.containsKey("user-id")) {
                return "";
            }
            return responseEntity.get("user-id").toString();
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public UserInfo getUser(String userName) {
        if (userName == null || userName.length() == 0) {
            throw new IllegalArgumentException("\u53c2\u6570userName is null");
        }
        String userToken = this.getUserToken(ServerSetting.getAdmin());
        String url = DmcUrl.getUserResourceUrl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        UserInfo userInfo = HttpRequestUtil.get(url + "/" + userName, headers, UserInfo.class);
        return userInfo;
    }

    @Override
    public List<UserInfo> getUsers() {
        String url = DmcUrl.getUserResourceUrl();
        String userToken = this.getUserToken(ServerSetting.getAdmin());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        ArrayList users = HttpRequestUtil.get(url, headers, ArrayList.class);
        ArrayList<UserInfo> userInfos = new ArrayList<UserInfo>();
        if (users != null) {
            for (Object user : users) {
                try {
                    String json = ObjectMapperUtil.writeValueAsString(user);
                    UserInfo userInfo = ObjectMapperUtil.readValue(json, UserInfo.class);
                    userInfos.add(userInfo);
                }
                catch (IOException e) {
                    throw new OperateException(e);
                }
            }
        }
        return userInfos;
    }

    @Override
    public String isExistUser(String userName) {
        if (userName == null) {
            throw new IllegalArgumentException("\u53c2\u6570userIdentity is null");
        }
        String url = DmcUrl.getUserResourceUrl() + "/" + userName + "/isExist";
        String userToken = this.getUserToken(ServerSetting.getAdmin());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
        HashMap isExist = HttpRequestUtil.get(url, headers, HashMap.class);
        if (isExist == null || !isExist.containsKey("isExist")) {
            return null;
        }
        return isExist.get("isExist").toString();
    }

    @Override
    public String getUserToken(UserIdentity userIdentity) {
        String userToken;
        if (userIdentity == null) {
            throw new IllegalArgumentException("\u53c2\u6570userIdentity is null");
        }
        int hashcode = userIdentity.hashCode();
        if (this.cache.containsKey(hashcode) && !JwtUtil.isExpires(userToken = this.cache.get(hashcode))) {
            return userToken;
        }
        String identityUrl = DmcUrl.getIdentityResourceUrl() + "/login";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("username", userIdentity.getUserName());
        parameters.put("pwdhash", userIdentity.getPasswordHash());
        try {
            String json = ObjectMapperUtil.writeValueAsString(parameters);
            HashMap responseEntity = HttpRequestUtil.postJson(identityUrl, json, HashMap.class);
            if (responseEntity == null || !responseEntity.containsKey("userToken")) {
                this.cache.remove(hashcode);
                return null;
            }
            userToken = responseEntity.get("userToken").toString();
            this.cache.put(hashcode, userToken);
            return userToken;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }
}

