/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.upload;

import com.digiwin.dmc.sdk.config.DmcUrl;
import com.digiwin.dmc.sdk.config.SDKConstants;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.service.impl.UserManagerService;
import com.digiwin.dmc.sdk.service.upload.IGeneralDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.IUpLoadCallbackable;
import com.digiwin.dmc.sdk.service.upload.UploadProgressEventArgs;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.ObjectMapperUtil;
import com.digiwin.dmc.sdk.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class GeneralDocumentUploader
implements IGeneralDocumentUploader {
    private String tenantId;
    private String bucketName;
    private String driveToken;
    private FileInfo fileInfo;
    private FileInputStream fileInputStream;
    private InputStream inputStream;
    private IUpLoadCallbackable completeCallback;
    private UploadProgressEventArgs eventArgs = new UploadProgressEventArgs();
    private static ExecutorService es = Executors.newCachedThreadPool();
    private static IUserManagerService userManagerService = UserManagerService.userInstance();

    public GeneralDocumentUploader(String tenantId, String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        try {
            File file = new File(localPath);
            this.fileInputStream = new FileInputStream(file);
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
        this.tenantId = tenantId;
        this.fileInfo = fileInfo;
        this.bucketName = bucketName;
        this.driveToken = driveToken;
    }

    public GeneralDocumentUploader(String tenantId, String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        try {
            this.inputStream = new ByteArrayInputStream(bytes);
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
        this.tenantId = tenantId;
        this.fileInfo = fileInfo;
        this.bucketName = bucketName;
        this.driveToken = driveToken;
    }

    @Override
    public IGeneralDocumentUploader upload() {
        if (StringUtil.isEmpty(this.bucketName)) {
            this.bucketName = ServerSetting.getBucketName();
        }
        String uploadResourceUrl = DmcUrl.getUploadResourceUrl() + this.bucketName + "/files";
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            if (StringUtil.isEmpty(this.driveToken)) {
                String userToken = userManagerService.getUserToken(ServerSetting.getUser());
                headers.put(SDKConstants.HttpHeaderUserTokenKey, userToken);
            } else {
                headers.put(SDKConstants.HttpHeaderDriveTokenKey, this.driveToken);
            }
            if (this.tenantId != null) {
                headers.put("tenantId", this.tenantId);
            }
            headers.put(SDKConstants.HttpHeaderApiArgKey, URLEncoder.encode(ObjectMapperUtil.writeValueAsString(this.fileInfo), "UTF-8"));
            Runnable runnable = () -> {
                Map result = this.fileInputStream == null ? (Map)HttpRequestUtil.uploadFile(uploadResourceUrl, headers, this.inputStream, HashMap.class) : (Map)HttpRequestUtil.uploadFile(uploadResourceUrl, headers, this.fileInputStream, HashMap.class);
                String fileId = (String)result.get("id");
                if (this.completeCallback != null) {
                    this.eventArgs.setFileId(fileId);
                    this.eventArgs.setPercentage(1.0);
                    this.completeCallback.callback(this.eventArgs);
                }
            };
            es.execute(runnable);
            return this;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public IGeneralDocumentUploader onCompleted(IUpLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }
}

