/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.util;

import com.digiwin.dmc.sdk.serializer.LocalDateDeserializer;
import com.digiwin.dmc.sdk.serializer.LocalDateSerializer;
import com.digiwin.dmc.sdk.serializer.LocalDateTimeDeserializer;
import com.digiwin.dmc.sdk.serializer.LocalDateTimeSerializer;
import com.digiwin.dmc.sdk.serializer.LocalTimeDeserializer;
import com.digiwin.dmc.sdk.serializer.LocalTimeSerializer;
import com.digiwin.dmc.sdk.serializer.TimestampDeserializer;
import com.digiwin.dmc.sdk.serializer.TimestampSerializer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public class ObjectMapperUtil {
    static ObjectMapper objectMapper = null;

    public static String writeValueAsString(Object data) throws JsonProcessingException {
        return ObjectMapperUtil.createObjectMapper().writeValueAsString(data);
    }

    public static <T> T readValue(String json, Class<T> valueType) throws IOException {
        return (T)ObjectMapperUtil.createObjectMapper().readValue(json, valueType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectMapper createObjectMapper() {
        if (objectMapper != null) return objectMapper;
        Class<ObjectMapperUtil> clazz = ObjectMapperUtil.class;
        synchronized (ObjectMapperUtil.class) {
            if (objectMapper != null) return objectMapper;
            objectMapper = new ObjectMapper();
            JavaTimeModule javaTimeModule = new JavaTimeModule();
            javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer());
            javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer());
            javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer());
            javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer());
            javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer());
            javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer());
            javaTimeModule.addSerializer(Timestamp.class, (JsonSerializer)new TimestampSerializer());
            javaTimeModule.addDeserializer(Timestamp.class, (JsonDeserializer)new TimestampDeserializer());
            objectMapper.registerModule((Module)javaTimeModule);
            objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, Boolean.FALSE.booleanValue());
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, Boolean.FALSE.booleanValue());
            // ** MonitorExit[var0] (shouldn't be in output)
            return objectMapper;
        }
    }
}

