/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dwapi.dwsys.service.impl;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.exceptions.DWBusinessException;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.resource.DWModuleMessageResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.dwapi.dwsys.service.IFunctionPermissionService;
import com.digiwin.dwapi.dwsys.util.IAMInvokeService;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMFuncPermissionService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class FunctionPermissionService
implements IFunctionPermissionService {
    static final String DEFAULT_EFFECT = "onlyAllow";
    @Autowired
    @Qualifier(value="dwIAMFuncPermissionService")
    IAMFuncPermissionService iamFuncPermissionService;
    private static Log log = LogFactory.getLog(FunctionPermissionService.class);

    private String getCurrentAppId() {
        String appId = DWApplicationConfigUtils.getProperty((String)"appId", (String)"");
        if (appId.isEmpty()) {
            appId = DWServiceContext.getContext().getRequestHeader().getOrDefault("digi-middleware-appid", "");
        }
        return appId;
    }

    public Object postIAM(List<Map<String, Object>> program, String language) throws Exception {
        String product = this.getCurrentAppId();
        return this.postIAM(program, product, language, product);
    }

    public Object postIAM(List<Map<String, Object>> program, String product, String language, String reportProduct) throws Exception {
        DWServiceResult re = null;
        List report = null;
        Map<String, Object> app = null;
        try {
            String msg;
            boolean existed;
            String actionName;
            String moduleId;
            String actionId;
            Map profile = DWServiceContext.getContext().getProfile();
            DWDefaultParameters para = new DWDefaultParameters();
            para.put("language", (Object)language);
            if (reportProduct == null || reportProduct.isEmpty()) {
                para.put("product", (Object)product);
            } else {
                para.put("product", (Object)reportProduct);
            }
            DWServiceResult reportObject = (DWServiceResult)DWContainerContext.getInstance().invoke("DWSys", "IReportService", "getListLanguage", (DWParameters)para, profile);
            if (reportObject.getSuccess().booleanValue()) {
                report = (List)reportObject.getData();
            }
            HashMap<String, String> iamParam = new HashMap<String, String>();
            iamParam.put("id", product);
            String iamGetAppURL = DWApplicationConfigUtils.getProperty((String)"iamUrlGetApp");
            HttpResponseModel iamAppResponse = (HttpResponseModel)IAMInvokeService.invokeIAM((String)iamGetAppURL, iamParam);
            String responseBody = iamAppResponse.getResponseBody();
            JSONObject responseJson = new JSONObject(responseBody);
            app = this.jsonToMap(responseJson);
            ArrayList modules = (ArrayList)app.get("modules");
            ArrayList<List<Map<String, Object>>> programs = new ArrayList<List<Map<String, Object>>>();
            programs.add(program);
            programs.add(report);
            CheckResult checkResult = this.checkModule(programs, modules);
            ArrayList actions = (ArrayList)app.get("actions");
            for (Map<String, Object> p : program) {
                actionId = (String)p.get("code");
                if (checkResult.errorProgramCode.contains(actionId) || (moduleId = (String)p.get("module")).equals("root")) continue;
                actionName = (String)p.get("name");
                if (actionName == null) {
                    actionName = actionId;
                }
                existed = false;
                if (actions != null) {
                    for (Map action : actions) {
                        if (!actionId.equals(action.get("id")) || !moduleId.equals(action.get("moduleId"))) continue;
                        HttpResponseModel iamActionResponse = (HttpResponseModel)this.postAction(actionId, actionName, product, moduleId, (String)action.get("hash"));
                        List conditions = (List)action.get("condition");
                        this.processCondition(p, "page", product, actionId, moduleId, conditions);
                        this.processCondition(p, "action", product, actionId, moduleId, conditions);
                        this.processRemoveCondition(conditions, p, (String)action.get("appId"), (String)action.get("moduleId"));
                        existed = true;
                        break;
                    }
                }
                if (existed) continue;
                this.postAction(actionId, actionName, product, moduleId);
                this.processCondition(p, "page", product, actionId, moduleId);
                this.processCondition(p, "action", product, actionId, moduleId);
            }
            if (report != null && report.size() > 0) {
                for (Map<String, Object> r : report) {
                    actionId = (String)r.get("code");
                    if (checkResult.errorProgramCode.contains(actionId) || (moduleId = (String)r.get("module")).equals("root")) continue;
                    actionName = (String)r.get("name");
                    if (actionName == null) {
                        actionName = actionId;
                    }
                    existed = false;
                    if (actions != null) {
                        for (Map action : actions) {
                            if (!actionId.equals(action.get("id")) || !moduleId.equals(action.get("moduleId"))) continue;
                            this.postAction(actionId, actionName, product, moduleId, (String)action.get("hash"));
                            existed = true;
                            break;
                        }
                    }
                    if (existed) continue;
                    this.postAction(actionId, actionName, product, moduleId);
                }
            }
            if ((msg = checkResult.message) != null && !msg.isEmpty()) {
                throw new DWBusinessException(msg);
            }
            re = DWServiceResultBuilder.build((boolean)true, null);
        }
        catch (Exception e) {
            String message = e.getMessage();
            re = DWServiceResultBuilder.build((boolean)false, (String)message, (Object)e.getStackTrace());
        }
        return re;
    }

    private CheckResult checkModule(List<List<Map<String, Object>>> programs, List<Map<String, Object>> modules) throws Exception {
        String msg = "";
        ArrayList<String> errorProgramCode = new ArrayList<String>();
        ArrayList<String> emptyModule = new ArrayList<String>();
        ArrayList<String> invalidModule = new ArrayList<String>();
        for (List<Map<String, Object>> program : programs) {
            for (Map<String, Object> p : program) {
                String code = (String)p.get("code");
                String name = (String)p.get("name") + "(" + code + ")";
                String moduleId = (String)p.get("module");
                if (moduleId == null || moduleId.isEmpty()) {
                    emptyModule.add(name);
                    errorProgramCode.add(code);
                    continue;
                }
                if (moduleId.equals("root")) continue;
                boolean invalidExisted = false;
                for (String m : invalidModule) {
                    if (!moduleId.equals(m)) continue;
                    invalidExisted = true;
                    break;
                }
                if (invalidExisted) {
                    errorProgramCode.add(code);
                    continue;
                }
                boolean moduleExisted = false;
                if (modules != null) {
                    for (Map<String, Object> m : modules) {
                        if (!moduleId.equals(m.get("id"))) continue;
                        moduleExisted = true;
                        break;
                    }
                }
                if (moduleExisted) continue;
                invalidModule.add(moduleId);
                errorProgramCode.add(code);
            }
        }
        if (emptyModule.size() > 0 || invalidModule.size() > 0) {
            for (String m : emptyModule) {
                msg = msg + DWModuleMessageResourceBundleUtils.getString((String)"msg006", (Object[])new Object[0]) + ":" + m + " " + DWModuleMessageResourceBundleUtils.getString((String)"msg008", (Object[])new Object[0]) + "\r\n";
            }
            for (String m : invalidModule) {
                msg = msg + DWModuleMessageResourceBundleUtils.getString((String)"msg009", (Object[])new Object[0]) + ":" + m + " " + DWModuleMessageResourceBundleUtils.getString((String)"msg010", (Object[])new Object[0]) + "\r\n";
            }
        }
        CheckResult re = new CheckResult();
        re.message = msg;
        re.errorProgramCode = errorProgramCode;
        return re;
    }

    public Object removeCondition(List<Map<String, String>> items, String id, Map<String, Object> condition, String appId, String moduleId) throws Exception {
        boolean existed = false;
        for (Map<String, String> item : items) {
            if (!id.equals(item.get("id"))) continue;
            existed = true;
            break;
        }
        if (!existed) {
            String url = DWApplicationConfigUtils.getProperty((String)"iamUrlRemoveCondition");
            condition.put("appId", appId);
            condition.put("moduleId", moduleId);
            IAMInvokeService.invokeIAM((String)url, condition);
        }
        return null;
    }

    private Object processRemoveCondition(List<Map<String, Object>> conditions, Map<String, Object> program, String appId, String moduleId) throws Exception {
        List page = (List)program.get("page");
        List action = (List)program.get("action");
        for (Map<String, Object> c : conditions) {
            String[] id;
            String cid = (String)c.get("key");
            if (cid.startsWith("page_id_")) {
                id = cid.split("page_id_");
                this.removeCondition(page, id[1], c, appId, moduleId);
                continue;
            }
            if (!cid.startsWith("action_")) continue;
            id = cid.split("action_");
            this.removeCondition(action, id[1], c, appId, moduleId);
        }
        return null;
    }

    private Object postAction(String actionId, String actionName, String appId, String moduleId) throws Exception {
        return this.postAction(actionId, actionName, appId, moduleId, null);
    }

    private Object postAction(String actionId, String actionName, String appId, String moduleId, String hash) throws Exception {
        String iamUpdateActionURL = DWApplicationConfigUtils.getProperty((String)"iamUrlUpdateAction");
        HashMap<String, String> action = new HashMap<String, String>();
        action.put("moduleId", moduleId);
        action.put("id", actionId);
        action.put("name", actionName);
        action.put("appId", appId);
        action.put("parentId", "[empty]");
        if (hash != null && hash.length() > 0) {
            action.put("hash", hash);
        }
        log.info((Object)("action=" + action));
        HttpResponseModel iamActionResponse = (HttpResponseModel)IAMInvokeService.invokeIAM((String)iamUpdateActionURL, action);
        return iamActionResponse;
    }

    private Object processCondition(Map<String, Object> program, String nodeName, String appId, String actionId, String moduleId) throws Exception {
        return this.processCondition(program, nodeName, appId, actionId, moduleId, null);
    }

    public Object processCondition(Map<String, Object> program, String nodeName, String appId, String actionId, String moduleId, List<Map<String, Object>> conditions) throws Exception {
        boolean hasConditions;
        List items = (List)program.get(nodeName);
        boolean bl = hasConditions = conditions != null && conditions.size() > 0;
        if (items != null) {
            for (Map item : items) {
                HashMap<String, Object> condition = new HashMap<String, Object>();
                if (nodeName.equals("page")) {
                    condition.put("key", "page_id_" + (String)item.get("id"));
                } else if (nodeName.equals("action")) {
                    condition.put("key", "action_" + (String)item.get("id"));
                }
                condition.put("appId", appId);
                condition.put("moduleId", moduleId);
                condition.put("actionId", actionId);
                String name = (String)item.get("name");
                if (name == null) {
                    name = (String)item.get("id");
                }
                condition.put("name", name);
                condition.put("type", "single");
                String restriction = (String)item.get("restriction");
                if (restriction != null && !restriction.isEmpty()) {
                    String[] paras = restriction.split(",");
                    condition.put("typeParameter", Arrays.asList(paras));
                    if (paras.length > 0) {
                        condition.put("defaultValue", paras[0]);
                    }
                }
                if (hasConditions) {
                    for (Map<String, Object> c : conditions) {
                        if (!c.get("key").equals(condition.get("key"))) continue;
                        condition.put("hash", c.get("hash"));
                        break;
                    }
                }
                this.postCondition(condition);
            }
        }
        return null;
    }

    public Object postCondition(Map<String, Object> condition) throws Exception {
        String url = DWApplicationConfigUtils.getProperty((String)"iamUrlUpdateCondition");
        HttpResponseModel iamConditionResponse = (HttpResponseModel)IAMInvokeService.invokeIAM((String)url, condition);
        return iamConditionResponse;
    }

    public Object get(List<String> code) throws Exception {
        String product = this.getCurrentAppId();
        return this.get(code, product);
    }

    public Object get(List<String> code, String product) throws Exception {
        DWServiceResult re = null;
        ArrayList dataList = new ArrayList();
        Map profile = DWServiceContext.getContext().getProfile();
        String userId = (String)profile.get("userId");
        Map<String, Boolean> cacAuthorizationMap = this.getCACAuthorizationMap();
        HashMap<String, Object> iamParam = new HashMap<String, Object>();
        iamParam.put("userId", userId);
        iamParam.put("target", "drn:iam:app:" + product);
        log.info((Object)("iamParam=" + iamParam));
        log.info((Object)("iamParam:target=drn:iam:app:" + product));
        HashMap<String, String> queryParameter = new HashMap<String, String>();
        queryParameter.put("effect", DEFAULT_EFFECT);
        iamParam.put("queryParameter", queryParameter);
        String iamPermissionURL = DWApplicationConfigUtils.getProperty((String)"iamUrlUserPermission");
        HttpResponseModel iamResponse = (HttpResponseModel)this.iamFuncPermissionService.invokeIAM(iamPermissionURL, iamParam);
        String responseBody = iamResponse.getResponseBody();
        JSONObject responseJson = new JSONObject(responseBody);
        JSONArray permissionsArray = responseJson.getJSONObject("result").getJSONArray("permissions");
        for (int j = 0; j < permissionsArray.length(); ++j) {
            JSONObject permissionObject = permissionsArray.getJSONObject(j);
            String target = this.getJSONObjectStringValue(permissionObject, "target");
            if (!this.isAuthorized(cacAuthorizationMap, target)) continue;
            String mappingTarget = "drn:iam:app:" + product;
            if (!target.toLowerCase().startsWith(mappingTarget.toLowerCase())) continue;
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            tmp.put("code", StringUtils.substringAfterLast((String)target, (String)":"));
            JSONObject obj = permissionObject.getJSONObject("conditions");
            if (obj.keys().hasNext()) {
                JSONObject conditionObject = obj.getJSONObject(target);
                ArrayList pages = new ArrayList();
                ArrayList actions = new ArrayList();
                for (Map.Entry<String, Object> entry : this.jsonToMap(conditionObject).entrySet()) {
                    String id = entry.getKey();
                    Object val = entry.getValue();
                    if (val == null || "null".equals(val)) {
                        val = "";
                    }
                    if (id.startsWith("page_id_")) {
                        HashMap<String, Object> page = new HashMap<String, Object>();
                        String[] pageNameKey = id.split("page_id_");
                        page.put("id", pageNameKey[1]);
                        page.put("restriction", val);
                        pages.add(page);
                        continue;
                    }
                    if (!id.startsWith("action_")) continue;
                    HashMap<String, Object> action = new HashMap<String, Object>();
                    String[] actionNameKey = id.split("action_");
                    action.put("id", actionNameKey[1]);
                    action.put("restriction", val);
                    actions.add(action);
                }
                tmp.put("page", pages);
                tmp.put("action", actions);
            }
            dataList.add(tmp);
        }
        if (code.size() > 0) {
            ArrayList<Map> dataListInCodes = new ArrayList<Map>();
            block2: for (int i = 0; i < dataList.size(); ++i) {
                Map program = (Map)dataList.get(i);
                for (int j = 0; j < code.size(); ++j) {
                    if (!code.get(j).equalsIgnoreCase(program.get("code").toString())) continue;
                    dataListInCodes.add(program);
                    continue block2;
                }
            }
            dataList = dataListInCodes;
        }
        re = DWServiceResultBuilder.build(dataList);
        return re;
    }

    public Object getMenu(Map<String, Object> param) throws Exception {
        HashMap<String, Object> reponse = new HashMap<String, Object>();
        reponse.put("success", false);
        reponse.put("description", "\u5df2\u5ee2\u68c4");
        reponse.put("datas", null);
        return reponse;
    }

    private Map<String, Object> jsonToMap(JSONObject json) {
        Map<String, Object> retMap = new HashMap<String, Object>();
        if (json != JSONObject.NULL) {
            retMap = this.toMap(json);
        }
        return retMap;
    }

    public Map<String, Object> toMap(JSONObject object) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keysItr = object.keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            List<Object> value = object.get(key);
            if (value instanceof JSONArray) {
                value = this.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = this.toMap((JSONObject)value);
            }
            map.put(key, value);
        }
        return map;
    }

    private List<Object> toList(JSONArray array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            List<Object> value = array.get(i);
            if (value instanceof JSONArray) {
                value = this.toList((JSONArray)value);
            } else if (value instanceof JSONObject) {
                value = this.toMap((JSONObject)value);
            }
            list.add(value);
        }
        return list;
    }

    public String getJSONObjectStringValue(JSONObject jsonObject, String key) {
        if (jsonObject.has(key)) {
            return jsonObject.getString(key);
        }
        return "";
    }

    private Map<String, Boolean> getCACAuthorizationMap() throws IOException, DWBusinessException {
        return null;
    }

    private boolean isAuthorized(Map<String, Boolean> cacAuthorizationMap, String target) {
        return true;
    }

    private class CheckResult {
        public String message;
        public List<String> errorProgramCode;

        private CheckResult() {
        }
    }
}

