/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dwapi.dwsys.service.impl;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryOrderby;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataRowCollection;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.identity.UserIdentity;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.service.impl.UserManagerService;
import com.digiwin.dwapi.dwsys.service.IReleaseService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ReleaseService
implements IReleaseService {
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    private static final String TABLE_DW_APP_PROD = "dw_app_prod";
    private static final String TABLE_DW_APP_RELEASE = "dw_app_release";
    private static final String TABLE_DW_APP_UPDATE = "dw_app_update";
    private static final String COLUMN_STATE = "$state";
    private static final String COLUMN_APP_CODE = "app_code";
    private static final String COLUMN_DESCRIPTION = "description";
    private static final String COLUMN_FILE_ID = "file_id";
    private static final String COLUMN_FILE_SEQ = "file_seq";
    private static final String COLUMN_VERSION = "version";
    private static final String COLUMN_PUBLISHED = "published";

    public Object getAppCodeList() throws Exception {
        try {
            DWQueryInfo queryInfo = new DWQueryInfo();
            List<String> selectFields = Arrays.asList(COLUMN_APP_CODE, COLUMN_DESCRIPTION);
            queryInfo.setTableName(TABLE_DW_APP_PROD);
            queryInfo.setSelectFields(selectFields);
            DWDataSetOperationOption selectOption = new DWDataSetOperationOption();
            selectOption.setTenantEnabled(false);
            DWDataSet dataset = this.dao.select(queryInfo, selectOption);
            return DWServiceResultBuilder.build((boolean)true, null, (Object)dataset);
        }
        catch (Exception ex) {
            return DWServiceResultBuilder.build((boolean)false, (String)ex.getMessage(), (Object)ex.getStackTrace());
        }
    }

    public Object addApp(String appCode, String appDesc) throws Exception {
        if (StringUtils.isBlank((CharSequence)appCode)) {
            throw new DWArgumentException("appCode", "appCode is blank!");
        }
        try {
            DWDataSet dataset = new DWDataSet();
            DWDataTable appProdTable = dataset.newTable(TABLE_DW_APP_PROD);
            DWDataRow row = appProdTable.newRow();
            row.set(COLUMN_APP_CODE, (Object)appCode);
            row.set(COLUMN_DESCRIPTION, (Object)appDesc);
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.setTenantEnabled(false);
            DWSQLExecutionResult result = this.dao.execute(dataset, option);
            return DWServiceResultBuilder.build((boolean)true, null, (Object)result);
        }
        catch (Exception ex) {
            return DWServiceResultBuilder.build((boolean)false, (String)ex.getMessage(), (Object)ex.getStackTrace());
        }
    }

    public Object modifyAppDesc(String appCode, String appDesc) throws Exception {
        if (StringUtils.isBlank((CharSequence)appCode)) {
            throw new DWArgumentException("appCode", "appCode is blank!");
        }
        try {
            this.dao.update("update dw_app_prod set description = ? where app_code = ?", new Object[]{appDesc, appCode});
            return DWServiceResultBuilder.build((boolean)true, null, null);
        }
        catch (Exception ex) {
            return DWServiceResultBuilder.build((boolean)false, (String)ex.getMessage(), (Object)ex.getStackTrace());
        }
    }

    public Object disableApp(String appCode) throws Exception {
        if (StringUtils.isBlank((CharSequence)appCode)) {
            throw new DWArgumentException("appCode", "appCode is blank!");
        }
        try {
            this.dao.update("delete from dw_app_release where app_code = ?", new Object[]{appCode});
            this.dao.update("delete from dw_app_update where app_code = ?", new Object[]{appCode});
            this.dao.update("delete from dw_app_prod where app_code = ?", new Object[]{appCode});
            return DWServiceResultBuilder.build((boolean)true, null, null);
        }
        catch (Exception ex) {
            return DWServiceResultBuilder.build((boolean)false, (String)ex.getMessage(), (Object)ex.getStackTrace());
        }
    }

    public Object releaseInstall(String appCode, String file, String ver) throws Exception {
        return null;
    }

    public Object releaseInstallwithFileId(String appCode, String fileId, String ver) throws Exception {
        if (StringUtils.isBlank((CharSequence)appCode)) {
            throw new DWArgumentException("appCode", "appCode is blank!");
        }
        if (StringUtils.isBlank((CharSequence)fileId)) {
            throw new DWArgumentException("fileId", "fileId is blank!");
        }
        if (StringUtils.isBlank((CharSequence)ver)) {
            throw new DWArgumentException("ver", "ver is blank!");
        }
        try {
            DWQueryInfo queryInfo = new DWQueryInfo();
            List<String> selectFields = Arrays.asList(COLUMN_FILE_SEQ);
            queryInfo.addEqualInfo(COLUMN_APP_CODE, (Object)appCode);
            queryInfo.addEqualInfo(COLUMN_VERSION, (Object)ver);
            queryInfo.setTableName(TABLE_DW_APP_RELEASE);
            queryInfo.setSelectFields(selectFields);
            queryInfo.getOrderfields().add(new DWQueryOrderby(COLUMN_FILE_SEQ, "desc"));
            DWDataSetOperationOption selectOption = new DWDataSetOperationOption();
            selectOption.setTenantEnabled(false);
            DWDataSet dataset = this.dao.select(queryInfo, selectOption);
            DWDataRowCollection rows = dataset.getTable(TABLE_DW_APP_RELEASE).getRows();
            int maxSeq = 0;
            if (rows.size() > 0) {
                maxSeq = (Integer)rows.get(0).get(COLUMN_FILE_SEQ);
            }
            DWDataSet newDataset = new DWDataSet();
            DWDataTable appReleaseTable = newDataset.newTable(TABLE_DW_APP_RELEASE);
            DWDataRow row = appReleaseTable.newRow();
            row.set(COLUMN_APP_CODE, (Object)appCode);
            row.set(COLUMN_VERSION, (Object)ver);
            row.set(COLUMN_FILE_SEQ, (Object)(maxSeq + 1));
            row.set(COLUMN_FILE_ID, (Object)fileId);
            row.set(COLUMN_PUBLISHED, (Object)"N");
            DWDataSetOperationOption insertOption = new DWDataSetOperationOption();
            insertOption.setTenantEnabled(false);
            DWSQLExecutionResult result = this.dao.execute(newDataset, insertOption);
            return DWServiceResultBuilder.build((boolean)true, null, (Object)result);
        }
        catch (Exception ex) {
            return DWServiceResultBuilder.build((boolean)false, (String)ex.getMessage(), (Object)ex.getStackTrace());
        }
    }

    public Object publishReleased(String appCode, String ver) throws Exception {
        if (StringUtils.isBlank((CharSequence)appCode)) {
            throw new DWArgumentException("appCode", "appCode is blank!");
        }
        if (StringUtils.isBlank((CharSequence)ver)) {
            throw new DWArgumentException("ver", "ver is blank!");
        }
        try {
            this.dao.update("update dw_app_released set published = ? where app_code = ? and version = ?", new Object[]{"Y", appCode, ver});
            return DWServiceResultBuilder.build((boolean)true, null, null);
        }
        catch (Exception ex) {
            return DWServiceResultBuilder.build((boolean)false, (String)ex.getMessage(), (Object)ex.getStackTrace());
        }
    }

    public Object getReleased(String appCode) throws Exception {
        try {
            DWQueryInfo queryInfo = new DWQueryInfo();
            List<String> selectFields = Arrays.asList(COLUMN_APP_CODE, COLUMN_VERSION, COLUMN_FILE_SEQ, COLUMN_FILE_ID, COLUMN_PUBLISHED);
            queryInfo.setTableName(TABLE_DW_APP_RELEASE);
            queryInfo.setSelectFields(selectFields);
            queryInfo.addEqualInfo(COLUMN_APP_CODE, (Object)appCode);
            queryInfo.getOrderfields().add(new DWQueryOrderby(COLUMN_APP_CODE, "asc"));
            queryInfo.getOrderfields().add(new DWQueryOrderby(COLUMN_VERSION, "asc"));
            queryInfo.getOrderfields().add(new DWQueryOrderby(COLUMN_FILE_SEQ, "asc"));
            DWDataSetOperationOption selectOption = new DWDataSetOperationOption();
            selectOption.setTenantEnabled(false);
            DWDataSet dataset = this.dao.select(queryInfo, selectOption);
            return DWServiceResultBuilder.build((boolean)true, null, (Object)dataset);
        }
        catch (Exception ex) {
            return DWServiceResultBuilder.build((boolean)false, (String)ex.getMessage(), (Object)ex.getStackTrace());
        }
    }

    public Object phaseoutReleased(String appCode, String ver) throws Exception {
        if (StringUtils.isBlank((CharSequence)appCode)) {
            throw new DWArgumentException("appCode", "appCode is blank!");
        }
        if (StringUtils.isBlank((CharSequence)ver)) {
            throw new DWArgumentException("ver", "ver is blank!");
        }
        try {
            this.dao.update("update dw_app_released set published = ? where app_code = ? and version = ?", new Object[]{"N", appCode, ver});
            return DWServiceResultBuilder.build((boolean)true, null, null);
        }
        catch (Exception ex) {
            return DWServiceResultBuilder.build((boolean)false, (String)ex.getMessage(), (Object)ex.getStackTrace());
        }
    }

    public Object getPublishReleased(String appCode, String userName, String password) throws Exception {
        if (StringUtils.isBlank((CharSequence)appCode)) {
            throw new DWArgumentException("appCode", "appCode is blank!");
        }
        if (StringUtils.isBlank((CharSequence)userName)) {
            throw new DWArgumentException("userName", "userName is blank!");
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new DWArgumentException("password", "password is blank!");
        }
        DWQueryInfo queryInfo = new DWQueryInfo();
        List<String> selectFields = Arrays.asList(COLUMN_VERSION);
        queryInfo.addEqualInfo(COLUMN_APP_CODE, (Object)appCode);
        queryInfo.addEqualInfo(COLUMN_PUBLISHED, (Object)"Y");
        queryInfo.setTableName(TABLE_DW_APP_RELEASE);
        queryInfo.setSelectFields(selectFields);
        queryInfo.getOrderfields().add(new DWQueryOrderby(COLUMN_VERSION, "desc"));
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        DWDataSet dataset = this.dao.select(queryInfo, option);
        DWDataRowCollection rows = dataset.getTable(TABLE_DW_APP_RELEASE).getRows();
        if (rows.size() > 0) {
            String ver = (String)rows.get(0).get(COLUMN_VERSION);
            return this.getSpecificReleased(appCode, ver, userName, password);
        }
        return DWServiceResultBuilder.build((boolean)false, (String)"0 release version found!", null);
    }

    public Object getSpecificReleased(String appCode, String ver, String userName, String password) throws Exception {
        if (StringUtils.isBlank((CharSequence)appCode)) {
            throw new DWArgumentException("appCode", "appCode is blank!");
        }
        if (StringUtils.isBlank((CharSequence)ver)) {
            throw new DWArgumentException("ver", "ver is blank!");
        }
        if (StringUtils.isBlank((CharSequence)userName)) {
            throw new DWArgumentException("userName", "userName is blank!");
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            throw new DWArgumentException("password", "password is blank!");
        }
        DWQueryInfo queryInfo = new DWQueryInfo();
        List<String> selectFields = Arrays.asList(COLUMN_FILE_ID);
        queryInfo.addEqualInfo(COLUMN_APP_CODE, (Object)appCode);
        queryInfo.addEqualInfo(COLUMN_VERSION, (Object)ver);
        queryInfo.setTableName(TABLE_DW_APP_RELEASE);
        queryInfo.setSelectFields(selectFields);
        queryInfo.getOrderfields().add(new DWQueryOrderby(COLUMN_FILE_SEQ, "asc"));
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        DWDataSet dataset = this.dao.select(queryInfo, option);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<Object> fileIds = new ArrayList<Object>();
        for (DWDataRow row : dataset.getTable(TABLE_DW_APP_RELEASE).getRows()) {
            fileIds.add(row.get(COLUMN_FILE_ID));
        }
        String serviceUrl = DWApplicationConfigUtils.getProperty((String)"dmcUrl");
        if (StringUtils.isBlank((CharSequence)serviceUrl)) {
            return null;
        }
        ServerSetting.setServiceUrl((String)serviceUrl);
        IUserManagerService userManagerService = UserManagerService.userInstance();
        String userToken = userManagerService.getUserToken(new UserIdentity(userName, password, false));
        resultMap.putIfAbsent(COLUMN_FILE_ID, fileIds);
        resultMap.putIfAbsent("dmc_token", userToken);
        return DWServiceResultBuilder.build((boolean)true, null, resultMap);
    }

    public Object getAvailableUpdate(String appCode, String ver, String userName, String password) throws Exception {
        return null;
    }
}

