/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dwapi.dwsys.service.impl;

import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.exceptions.DWArgumentException;
import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWQueryInfoBuilder;
import com.digiwin.app.dao.DWQueryOrderby;
import com.digiwin.app.dao.DWQueryValueOperator;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.data.DWDataRow;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.data.DWDataSetOperationOption;
import com.digiwin.app.data.DWDataTable;
import com.digiwin.app.data.DWReferenceDataRowCollection;
import com.digiwin.app.data.IDWSQLOptions;
import com.digiwin.app.data.exceptions.DWDataOptimisticLockingException;
import com.digiwin.app.resource.DWModuleMessageResourceBundleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.app.service.DWServiceResult;
import com.digiwin.dwapi.dwsys.service.IMenuService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class MenuService
implements IMenuService {
    @Autowired
    @Qualifier(value="dw-dao")
    private DWDao dao;
    private static final String TABLE_MENU = "dw_menu";
    private static final String TABLE_ACTION = "action";
    private static final String TABLE_PAGE = "page";
    private static final String TABLE_LANGUAGE = "dw_menu_language";
    private static final String TABLE_PARAMETER = "dw_menu_parameter";
    private static final String COLUMN_ID = "id";
    private static final String COLUMN_PARENT_ID = "parent_id";
    private static final String COLUMN_SEQUENCE = "sequence";
    private static final String COLUMN_MENU_ID = "menu_id";
    private static final String COLUMN_STATE = "$state";
    private static final String COLUMN_VERSION = "version";
    private static final String COLUMN_ICON_CLASS = "icon_class";
    private static final String COLUMN_DEFAULT_EXPAND = "default_expand";
    private static final String COLUMN_URL = "url";
    private static final String COLUMN_OPEN_MODE = "open_mode";
    private static final String COLUMN_TYPE = "type";
    private static final String COLUMN_CODE = "code";
    private static final String COLUMN_VALUE_FINEREPORT = "fineReport";
    private static final String COLUMN_REPORT_PARAMETER = "parameter";
    private static final String COLUMN_MENU_PARAMETER_MENUID = "menu_id";

    public Object post(DWDataSet dataset) throws Exception {
        if (dataset == null || dataset.getTables().size() == 0) {
            throw new DWArgumentException("dataset", "dataset is null or empty!");
        }
        DWDataTable dwMenuTable = dataset.getTable(TABLE_MENU);
        dataset.getTables().remove(TABLE_ACTION);
        dataset.getTables().remove(TABLE_PAGE);
        DWSQLExecutionResult result = null;
        String parentId = null;
        double sequence = 0.0;
        for (DWDataRow menuRow : dwMenuTable.getRows()) {
            UUID uuid = UUID.randomUUID();
            String newId = uuid.toString();
            menuRow.set(COLUMN_ID, (Object)newId);
            parentId = (String)menuRow.get(COLUMN_PARENT_ID);
            sequence = (Double)menuRow.get(COLUMN_SEQUENCE);
            DWReferenceDataRowCollection dwLanguagRows = (DWReferenceDataRowCollection)menuRow.get(TABLE_LANGUAGE);
            for (DWDataRow langRow : dwLanguagRows) {
                langRow.set("menu_id", (Object)newId);
            }
        }
        if (this.existFinereport(dwMenuTable)) {
            this.addReportParameters(dataset);
        }
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        option.setManagementFieldEnabled(false);
        String sql = "update dw_menu set sequence = sequence + ? where parent_id = ? and sequence >= ? ";
        this.dao.update((IDWSQLOptions)option, sql, new Object[]{dwMenuTable.getRows().size(), parentId, sequence});
        result = this.dao.execute(dataset, option);
        return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[0]), (Object)result);
    }

    private boolean existFinereport(DWDataTable dwMenuTable) {
        for (DWDataRow menuRow : dwMenuTable.getRows()) {
            if (!StringUtils.equals((CharSequence)((CharSequence)menuRow.get(COLUMN_TYPE)), (CharSequence)COLUMN_VALUE_FINEREPORT)) continue;
            return true;
        }
        return false;
    }

    private void addReportParameters(DWDataSet dataset) throws Exception {
        DWDataTable dwMenuParameterTable = dataset.newTable(TABLE_PARAMETER);
        DWDataTable dwMenuTable = dataset.getTable(TABLE_MENU);
        for (DWDataRow menuRow : dwMenuTable.getRows()) {
            String code = (String)menuRow.get(COLUMN_CODE);
            String menuId = (String)menuRow.get(COLUMN_ID);
            Map<String, Object> report = this.getReport(code);
            List<Map<String, Object>> reportParameters = this.getReportParameterList(report, menuId);
            if (reportParameters.isEmpty()) continue;
            dwMenuParameterTable.newRows(reportParameters);
        }
    }

    private Map<String, Object> getReport(String code) throws Exception {
        DWDefaultParameters params = new DWDefaultParameters();
        params.put(COLUMN_CODE, (Object)code);
        DWServiceResult reportObject = (DWServiceResult)DWContainerContext.getInstance().invoke("DWSys", "IReportService", "get", (DWParameters)params, DWServiceContext.getContext().getProfile());
        if (reportObject.getSuccess().booleanValue()) {
            return (Map)reportObject.getData();
        }
        return new HashMap<String, Object>();
    }

    private List<Map<String, Object>> getReportParameterList(Map<String, Object> report, String menuId) {
        List result = report.getOrDefault(COLUMN_REPORT_PARAMETER, new ArrayList());
        for (Map map : result) {
            map.put(COLUMN_STATE, "C");
            map.put("menu_id", menuId);
        }
        return result;
    }

    public Object put(DWDataSet dataset) throws Exception {
        if (dataset == null || dataset.getTables().size() == 0) {
            throw new DWArgumentException("dataset", "dataset is null or empty!");
        }
        dataset.getTables().remove(TABLE_ACTION);
        dataset.getTables().remove(TABLE_PAGE);
        DWSQLExecutionResult result = null;
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        option.setManagementFieldEnabled(false);
        try {
            result = this.dao.execute(dataset, option);
            return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[0]), (Object)result);
        }
        catch (DWDataOptimisticLockingException exception) {
            return DWServiceResultBuilder.build((boolean)false, (String)"id not exist", (Object)result);
        }
    }

    public Object delete(DWDataSet dataset) throws Exception {
        if (dataset == null || dataset.getTables().size() == 0) {
            throw new DWArgumentException("dataset", "dataset is null or empty!");
        }
        DWSQLExecutionResult result = null;
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        option.addCascadeDeleting(TABLE_MENU, TABLE_LANGUAGE);
        option.addCascadeDeleting(TABLE_MENU, TABLE_PARAMETER);
        DWDataTable dwMenuTable = dataset.getTable(TABLE_MENU);
        DWDataSetOperationOption op = new DWDataSetOperationOption();
        op.setTenantEnabled(false);
        for (DWDataRow menuRow : dwMenuTable.getRows()) {
            String id = (String)menuRow.get(COLUMN_ID);
            long version = Math.round((Double)menuRow.get(COLUMN_VERSION));
            DWQueryInfo queryInfo = new DWQueryInfo();
            queryInfo.addEqualInfo(COLUMN_PARENT_ID, (Object)id);
            queryInfo.setTableName(TABLE_MENU);
            queryInfo.setSelectFields(Arrays.asList(COLUMN_ID));
            DWDataSet querySet = this.dao.select(queryInfo, op);
            for (DWDataRow subRow : querySet.getTable(TABLE_MENU).getRows()) {
                String subId = (String)subRow.get(COLUMN_ID);
                DWDataSet subSet = new DWDataSet();
                HashMap<String, Object> subMap = new HashMap<String, Object>();
                subMap.put(COLUMN_STATE, "d");
                subMap.put(COLUMN_ID, subId);
                subMap.put(COLUMN_VERSION, version);
                subSet.newTable(TABLE_MENU).newRow(subMap);
                this.delete(subSet);
            }
        }
        try {
            result = this.dao.execute(dataset, option);
            return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[0]), (Object)result);
        }
        catch (DWDataOptimisticLockingException exception) {
            return DWServiceResultBuilder.build((boolean)false, (String)"id not exist", (Object)result);
        }
    }

    public Object getTree(List<Object> ids) throws Exception {
        DWQueryInfo queryInfo = null;
        List<String> selectFields = Arrays.asList(COLUMN_ID, COLUMN_TYPE, COLUMN_CODE, COLUMN_ICON_CLASS, COLUMN_SEQUENCE, COLUMN_VERSION);
        if (ids == null || ids.size() == 0) {
            queryInfo = new DWQueryInfo();
            queryInfo.addEqualInfo(COLUMN_PARENT_ID, (Object)"");
        } else {
            DWQueryInfoBuilder queryInfoBuilder = new DWQueryInfoBuilder();
            queryInfo = queryInfoBuilder.setOids(ids).setPrimaryKeyName(COLUMN_ID).create();
        }
        queryInfo.setTableName(TABLE_MENU);
        queryInfo.setSelectFields(selectFields);
        queryInfo.getOrderfields().add(new DWQueryOrderby(COLUMN_SEQUENCE, "asc"));
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        DWDataSet dataset = this.dao.select(queryInfo, option);
        int maxLevel = 10;
        this.attachMenuChildRows(dataset, 1, maxLevel, selectFields, null, null, option);
        return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[0]), (Object)dataset);
    }

    public Object putDrag(DWDataSet dataset) throws Exception {
        if (dataset == null || dataset.getTables().size() == 0) {
            throw new DWArgumentException("dataset", "dataset is null or empty!");
        }
        DWSQLExecutionResult result = null;
        DWDataTable dwMenuTable = dataset.getTables().getPrimaryTable();
        if (dwMenuTable.getRows().size() > 0) {
            DWDataRow menuRow = dwMenuTable.getRows().get(0);
            String parentId = (String)menuRow.get(COLUMN_PARENT_ID);
            double sequence = (Double)menuRow.get(COLUMN_SEQUENCE);
            DWDataSetOperationOption option = new DWDataSetOperationOption();
            option.setTenantEnabled(false);
            option.setManagementFieldEnabled(false);
            String sql = "update dw_menu set sequence = (sequence + 1) where parent_id = ? and sequence >= ? ";
            this.dao.update((IDWSQLOptions)option, sql, new Object[]{parentId, sequence});
            result = this.dao.execute(dataset, option);
        }
        return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[0]), result);
    }

    public Object get(List<String> ids) throws Exception {
        if (ids == null || ids.size() == 0) {
            throw new DWArgumentException("ids", "ids is null or empty!");
        }
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        option.addCascadeQuery(TABLE_MENU, TABLE_LANGUAGE);
        option.addCascadeQuery(TABLE_MENU, TABLE_PARAMETER);
        DWQueryInfo queryInfo = new DWQueryInfo();
        for (String id : ids) {
            queryInfo.addEqualInfo(COLUMN_ID, (Object)id);
        }
        DWDataSet dataset = this.dao.select(queryInfo, "select * from dw_menu", option);
        dataset.getTables().remove(TABLE_LANGUAGE);
        dataset.getTables().remove(TABLE_PARAMETER);
        return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[0]), (Object)dataset);
    }

    public Object getAuthority() throws Exception {
        ArrayList<String> nullList = new ArrayList<String>();
        List<String> codes = this.getPermissionCodes(nullList, null);
        DWDataSet dataset = null;
        if (codes.size() > 0) {
            dataset = this.getMenuDataSet(codes);
        }
        return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[0]), (Object)dataset);
    }

    public Object getAuthority(String product) throws Exception {
        ArrayList<String> nullList = new ArrayList<String>();
        List<String> codes = this.getPermissionCodes(nullList, product);
        DWDataSet dataset = null;
        if (codes.size() > 0) {
            dataset = this.getMenuDataSet(codes);
        }
        return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[0]), (Object)dataset);
    }

    private DWDataSet getMenuDataSet(List<String> codes) throws Exception {
        DWQueryInfo queryInfo = new DWQueryInfo();
        Object[] codeFieldInfo = codes.toArray();
        Object[] typeFieldInfo = Arrays.asList("category", "externalUrl").toArray();
        List<String> selectFields = Arrays.asList(COLUMN_ID, COLUMN_TYPE, COLUMN_CODE, COLUMN_ICON_CLASS, COLUMN_SEQUENCE, COLUMN_DEFAULT_EXPAND, COLUMN_URL, COLUMN_OPEN_MODE);
        queryInfo.addEqualInfo(COLUMN_PARENT_ID, (Object)"");
        DWQueryCondition secondConditionGroup = new DWQueryCondition();
        secondConditionGroup.addFieldInfo(COLUMN_TYPE, DWQueryValueOperator.IN, typeFieldInfo);
        secondConditionGroup.addFieldInfo(COLUMN_CODE, DWQueryValueOperator.IN, codeFieldInfo);
        secondConditionGroup.ORJoin();
        queryInfo.getCondition().addCondition(secondConditionGroup);
        queryInfo.setTableName(TABLE_MENU);
        queryInfo.setSelectFields(selectFields);
        queryInfo.getOrderfields().add(new DWQueryOrderby(COLUMN_SEQUENCE, "asc"));
        DWDataSetOperationOption option = new DWDataSetOperationOption();
        option.setTenantEnabled(false);
        option.addCascadeQuery(TABLE_MENU, TABLE_PARAMETER);
        DWDataSet dataset = this.dao.select(queryInfo, option);
        dataset.getTables().remove(TABLE_PARAMETER);
        int maxLevel = 10;
        this.attachMenuChildRows(dataset, 1, maxLevel, selectFields, codeFieldInfo, typeFieldInfo, option);
        return dataset;
    }

    private List<String> getPermissionCodes(List<String> codes, String product) throws Exception {
        DWServiceResult response;
        ArrayList<String> result = new ArrayList<String>();
        DWDefaultParameters para = new DWDefaultParameters();
        para.put(COLUMN_CODE, codes);
        if (product != null && !product.isEmpty()) {
            para.put("product", (Object)product);
        }
        if ((response = (DWServiceResult)DWContainerContext.getInstance().invoke("DWSys", "IFunctionPermissionService", "get", (DWParameters)para, DWServiceContext.getContext().getProfile())).getSuccess().booleanValue()) {
            List datas = (List)response.getData();
            for (Map data : datas) {
                result.add((String)data.get(COLUMN_CODE));
            }
        }
        return result;
    }

    public Object getLanguage(String language) throws Exception {
        if (language == null || language.isEmpty()) {
            throw new DWArgumentException("language", "language is null or empty!");
        }
        List result = this.dao.select("select menu_id,name from dw_menu_language where language = ? -${tenantsid}", new Object[]{language});
        HashMap<String, List> dwMenu = new HashMap<String, List>();
        dwMenu.put(TABLE_LANGUAGE, result);
        return DWServiceResultBuilder.build((boolean)true, (String)DWModuleMessageResourceBundleUtils.getString((String)"msg001", (Object[])new Object[0]), dwMenu);
    }

    private void attachMenuChildRows(DWDataSet dataset, int currentLevel, int maxLevel, List<String> selectFields, Object[] codeFieldInfo, Object[] typeFieldInfo, DWDataSetOperationOption option) throws Exception {
        if (++currentLevel > maxLevel) {
            return;
        }
        ArrayList masterRows = new ArrayList();
        masterRows.addAll(dataset.getTables().getPrimaryTable().getRows().stream().collect(Collectors.toList()));
        for (DWDataRow row : masterRows) {
            DWQueryInfo queryInfo = new DWQueryInfo(TABLE_MENU);
            queryInfo.addEqualInfo(COLUMN_PARENT_ID, row.get(COLUMN_ID));
            queryInfo.setSelectFields(selectFields);
            queryInfo.getOrderfields().add(new DWQueryOrderby(COLUMN_SEQUENCE, "asc"));
            if (typeFieldInfo != null && codeFieldInfo != null) {
                DWQueryCondition secondConditionGroup = new DWQueryCondition();
                secondConditionGroup.addFieldInfo(COLUMN_TYPE, DWQueryValueOperator.IN, typeFieldInfo);
                secondConditionGroup.addFieldInfo(COLUMN_CODE, DWQueryValueOperator.IN, codeFieldInfo);
                secondConditionGroup.ORJoin();
                queryInfo.getCondition().addCondition(secondConditionGroup);
            }
            DWDataSet childMenuDataset = option == null ? this.dao.select(queryInfo) : this.dao.select(queryInfo, option);
            this.attachMenuChildRows(childMenuDataset, currentLevel, maxLevel, selectFields, codeFieldInfo, typeFieldInfo, option);
            row.set(TABLE_MENU, (Object)childMenuDataset);
        }
    }
}

