/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dwapi.dwsys.service.impl;

import com.digiwin.app.dao.DWDao;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWPaginationQueryResult;
import com.digiwin.app.dao.DWQueryInfo;
import com.digiwin.app.dao.DWSQLExecutionResult;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.dwapi.dwsys.dao.DWSelectWindowQueryInfo;
import com.digiwin.dwapi.dwsys.service.IQueryService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

public class QueryService
implements IQueryService {
    @Autowired(required=false)
    @Qualifier(value="dw-dao")
    private DWDao dao;
    @Autowired
    private MessageSource messageSource;

    public Object getQueryList(DWQueryInfo queryInfo) throws Exception {
        DWDataSet dataset = this.dao.select(queryInfo, "SELECT query_id,query_type,sql_statement,publish,owner FROM dw_query_info");
        String message = this.messageSource.getMessage("inf001", null, null);
        return DWServiceResultBuilder.build((boolean)true, (String)message, (Object)dataset);
    }

    public Object getQuery(DWQueryInfo queryInfo) throws Exception {
        return null;
    }

    public Object addQuery(DWDataSet dataSet) throws Exception {
        DWSQLExecutionResult result = this.dao.execute(dataSet);
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), (Object)result);
    }

    public Object updateQuery(DWDataSet dataSet) throws Exception {
        DWSQLExecutionResult result = this.dao.execute(dataSet);
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), (Object)result);
    }

    public Object deleteQuery(DWDataSet dataSet) throws Exception {
        DWSQLExecutionResult result = this.dao.execute(dataSet);
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), (Object)result);
    }

    public Object queryData(DWSelectWindowQueryInfo openWindowQueryInfo) throws Exception {
        String sql = "";
        String querySql = "SELECT query_id,query_type,sql_statement,publish,owner FROM dw_query_info WHERE 1=1 AND query_id=? ";
        List result = this.dao.select(querySql, new Object[]{openWindowQueryInfo.getSelectWindowId()});
        if (null != result && result.size() > 0) {
            Map resultMap = (Map)result.get(0);
            sql = resultMap.get("sql_statement").toString();
        }
        StringBuilder fieldBuilder = new StringBuilder();
        for (String field : openWindowQueryInfo.getSelectFields()) {
            fieldBuilder.append(field).append(",");
        }
        String querySQL = sql.replace("[Fields]", fieldBuilder.deleteCharAt(fieldBuilder.lastIndexOf(",")).toString()) + " ";
        DWPaginationQueryResult queryResult = this.dao.selectWithPage((DWPagableQueryInfo)openWindowQueryInfo, querySQL);
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), (Object)queryResult);
    }
}

