/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dwapi.dwsys.service.impl;

import com.alibaba.fastjson.JSON;
import com.digiwin.app.dao.DWPagableQueryInfo;
import com.digiwin.app.dao.DWQueryCondition;
import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.data.DWDataSet;
import com.digiwin.app.schedule.context.DWScheduleContext;
import com.digiwin.app.schedule.entity.DWScheduleQuartzInfo;
import com.digiwin.app.schedule.util.DWScheduleCastUtils;
import com.digiwin.app.schedule.util.DistributedScheduleUtils;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.dwapi.dwsys.service.IScheduleService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScheduleService
implements IScheduleService {
    Log _log = LogFactory.getLog(ScheduleService.class);

    public Object getAvailableJobList() throws Exception {
        return DWScheduleContext.getInstance().getAvailableJobList();
    }

    public Object executeJob(Map<String, Object> paramMap) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
            params.put("paramMap", paramMap);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        DWScheduleQuartzInfo quartzInfo = DWScheduleCastUtils.convertMapToDWScheduleQuartzInfo(paramMap);
        return DWScheduleContext.getInstance().executeJob(quartzInfo);
    }

    public Object addSchedule(Map<String, Object> paramMap) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
            params.put("paramMap", paramMap);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        DWScheduleQuartzInfo quartzInfo = DWScheduleCastUtils.convertMapToDWScheduleQuartzInfo(paramMap);
        return DWScheduleContext.getInstance().addSchedule(quartzInfo);
    }

    public Object addSchedules(List<Map<String, Object>> paramMap) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, List<Map<String, Object>>> params = new HashMap<String, List<Map<String, Object>>>();
            params.put("paramMap", paramMap);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        return DWScheduleContext.getInstance().addSchedules(paramMap);
    }

    public Object updateSchedule(Map<String, Object> paramMap) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
            params.put("paramMap", paramMap);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        DWScheduleQuartzInfo quartzInfo = DWScheduleCastUtils.convertMapToDWScheduleQuartzInfo(paramMap);
        return DWScheduleContext.getInstance().updateSchedule(quartzInfo);
    }

    public Object updateSchedules(List<Map<String, Object>> paramMap) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, List<Map<String, Object>>> params = new HashMap<String, List<Map<String, Object>>>();
            params.put("paramMap", paramMap);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        return DWScheduleContext.getInstance().updateSchedules(paramMap);
    }

    public Object updateScheduleExcludeEnableStatus(Map<String, Object> paramMap) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
            params.put("paramMap", paramMap);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        DWScheduleQuartzInfo quartzInfo = DWScheduleCastUtils.convertMapToDWScheduleQuartzInfo(paramMap);
        return DWScheduleContext.getInstance().updateScheduleExcludeEnableStatus(quartzInfo);
    }

    public Object updateSchedulesExcludeEnableStatus(List<Map<String, Object>> paramMap) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, List<Map<String, Object>>> params = new HashMap<String, List<Map<String, Object>>>();
            params.put("paramMap", paramMap);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        return DWScheduleContext.getInstance().updateSchedulesExcludeEnableStatus(paramMap);
    }

    public Object removeSchedule(List<String> scheduleIdList) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("scheduleIdList", scheduleIdList);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        return DWScheduleContext.getInstance().deleteSchedule(scheduleIdList);
    }

    public Object getScheduleListByJob(DWPagableQueryInfo param) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, DWPagableQueryInfo> params = new HashMap<String, DWPagableQueryInfo>();
            params.put("param", param);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        return DWScheduleContext.getInstance().getScheduleList(param);
    }

    public Object getScheduleList(DWPagableQueryInfo param) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, DWPagableQueryInfo> params = new HashMap<String, DWPagableQueryInfo>();
            params.put("param", param);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        return DWScheduleContext.getInstance().getScheduleList(param);
    }

    public Object getScheduleInfo(String scheduleId) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("scheduleId", scheduleId);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        return DWScheduleContext.getInstance().getScheduleInfo(scheduleId);
    }

    public Object getScheduleInfos(List<String> scheduleIds) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("scheduleIds", scheduleIds);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        return DWScheduleContext.getInstance().getScheduleInfos(scheduleIds);
    }

    public Object getScheduleTimeInfo(String scheduleId) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("scheduleId", scheduleId);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        return DWScheduleContext.getInstance().getScheduleTimeInfo(scheduleId);
    }

    public Object enableSchedule(List<String> scheduleIdList) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("scheduleIdList", scheduleIdList);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        return DWScheduleContext.getInstance().setScheduleStatus("Y", scheduleIdList);
    }

    public Object disableSchedule(List<String> scheduleIdList) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("scheduleIdList", scheduleIdList);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        return DWScheduleContext.getInstance().setScheduleStatus("N", scheduleIdList);
    }

    public Object getResultList(DWPagableQueryInfo queryInfo) throws Exception {
        Object result;
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, DWPagableQueryInfo> params = new HashMap<String, DWPagableQueryInfo>();
            params.put("param", queryInfo);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        if ((result = DWScheduleContext.getInstance().getScheduleRecordList(queryInfo)) == null) {
            return DWServiceResultBuilder.build((boolean)true, (String)"DWDao\u67e5\u8a62\u4e0d\u5230\u6578\u64da", (Object)result);
        }
        return DWServiceResultBuilder.build((Object)result);
    }

    public Object getResult(DWPagableQueryInfo queryInfo) throws Exception {
        Object result;
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, DWPagableQueryInfo> params = new HashMap<String, DWPagableQueryInfo>();
            params.put("param", queryInfo);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        if ((result = DWScheduleContext.getInstance().getScheduleRecordInfo(queryInfo)) == null) {
            return DWServiceResultBuilder.build((boolean)true, (String)"DWDao\u67e5\u8a62\u4e0d\u5230\u6578\u64da", (Object)result);
        }
        return DWServiceResultBuilder.build((Object)result);
    }

    public List<String> getProgramCodeList() throws Exception {
        DWPagableQueryInfo pagableQueryInfo = new DWPagableQueryInfo();
        pagableQueryInfo.setPageNumber(1);
        pagableQueryInfo.setPageSize(Integer.MAX_VALUE);
        pagableQueryInfo.setDistinct(true).setSelectFields(new String[]{"program_code"});
        Object o = this.getScheduleList(pagableQueryInfo);
        List<String> programCodeList = ((DWDataSet)o).getTable("dw_schedule").getRows().stream().filter(row -> row.get("program_code") != null).map(row -> row.get("program_code").toString()).collect(Collectors.toList());
        return programCodeList;
    }

    public Object recover(String workerId, String scheduleId) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("scheduleId", scheduleId);
            params.put("workerId", workerId);
            DWServiceContext.getContext().setRequestBody(JSON.toJSON(params).toString());
        }
        Object result = DWScheduleContext.getInstance().recover(workerId, scheduleId);
        return result;
    }

    public Object recoverWorkerData(Map<String, Object> paramMap) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, Map<String, Object>> params = new HashMap<String, Map<String, Object>>();
            params.put("paramMap", paramMap);
            DWServiceContext.getContext().setRequestBody(JSON.toJSON(params).toString());
        }
        DWScheduleQuartzInfo quartzInfo = DWScheduleCastUtils.convertMapToDWScheduleQuartzInfo(paramMap);
        Object result = DWScheduleContext.getInstance().recoverWorkerData(quartzInfo);
        return result;
    }

    public Object getWorkerConfig() throws Exception {
        return DWScheduleContext.getInstance().getWorkerConfig();
    }

    public Object removeScheduleCrossTenant(List<Map<String, Object>> paramMap) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, List<Map<String, Object>>> params = new HashMap<String, List<Map<String, Object>>>();
            params.put("paramMap", paramMap);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        return DWScheduleContext.getInstance().deleteScheduleCrossTenant(paramMap);
    }

    public Object removeScheduleByCondition(DWQueryCondition condition) throws Exception {
        if (DistributedScheduleUtils.isHigherMaster() || DistributedScheduleUtils.isAp()) {
            if (DistributedScheduleUtils.isHigherMaster()) {
                DistributedScheduleUtils.assertHaveNoOfflineWorkers();
            }
            HashMap<String, DWQueryCondition> params = new HashMap<String, DWQueryCondition>();
            params.put("condition", condition);
            DWServiceContext.getContext().setRequestBody(JSON.toJSONString(params));
        }
        return DWScheduleContext.getInstance().deleteScheduleByCondition(condition);
    }
}

