/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dwapi.dwsys.service.impl;

import com.digiwin.app.dao.DWServiceResultBuilder;
import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.dwapi.dwsys.service.ISystemInfoService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.software.os.FileSystem;
import oshi.software.os.OSFileStore;
import oshi.util.Util;

public class SystemInfoService
implements ISystemInfoService {
    Log log = LogFactory.getLog(SystemInfoService.class);
    private static File runningPath = new File(".").getAbsoluteFile();
    private static String runningPathStr = runningPath.toString();
    @Autowired
    private MessageSource messageSource;

    public Object getPerformance() throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hal = si.getHardware();
        String cpuLoadAvg = (String)this.getCpu(hal.getProcessor());
        result.put("cpuLoadAvg", cpuLoadAvg);
        String memUsage = (String)this.getMem(hal.getMemory());
        result.put("memUsage", memUsage);
        String diskUsage = (String)this.getDisk(si.getOperatingSystem().getFileSystem());
        if (StringUtils.isBlank((CharSequence)diskUsage)) {
            diskUsage = "invalid";
        }
        result.put("diskUsage", diskUsage);
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), result);
    }

    private Object getCpu(CentralProcessor processor) throws InterruptedException {
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        Util.sleep((long)1000L);
        int sysCpuLoad = (int)(processor.getSystemCpuLoadBetweenTicks(prevTicks) * 100.0);
        String result = String.valueOf(sysCpuLoad);
        this.log.debug((Object)("CPU load:" + result));
        return result;
    }

    private Object getMem(GlobalMemory memory) throws InterruptedException {
        double orgMemTotal = (double)memory.getTotal() * 1.0 / 1024.0 / 1024.0 / 1024.0;
        double orgMemAvailable = (double)memory.getAvailable() * 1.0 / 1024.0 / 1024.0 / 1024.0;
        double memTotal = new Double(new DecimalFormat("#.##").format(orgMemTotal));
        double memAvailable = new Double(new DecimalFormat("#.##").format(orgMemAvailable));
        int sysMemFree = (int)(memAvailable / memTotal * 100.0);
        String result = String.valueOf(100 - sysMemFree);
        return result;
    }

    private Object getDisk(FileSystem fileSystem) {
        String result = "";
        OSFileStore[] fsArray = fileSystem.getFileStores();
        String fsDescription = "";
        String fsMountName = "";
        for (OSFileStore fs : fsArray) {
            fsMountName = fs.getMount();
            fsDescription = fs.getDescription().isEmpty() ? "file system" : fs.getDescription();
            fsDescription = fsDescription.toLowerCase();
            this.log.debug((Object)("  fs.getDescription=" + fsDescription + ", mount on (" + fsMountName + ")"));
            if (!fsDescription.contains("fixed") && !fsDescription.contains("local") || !SystemInfoService.getInstallPath().startsWith(fsMountName)) continue;
            this.log.debug((Object)(" result: xx fs.getDescription=" + fsDescription + ", mount on (" + fsMountName + ")"));
            double usable = (double)fs.getUsableSpace() * 1.0 / 1024.0 / 1024.0 / 1024.0;
            double total = (double)fs.getTotalSpace() * 1.0 / 1024.0 / 1024.0 / 1024.0;
            int sysDiskFree = (int)(usable / total * 100.0);
            result = String.valueOf(100 - sysDiskFree);
        }
        return result;
    }

    public Object getVersion() throws Exception {
        String result = SystemInfoService.getDeployVersion();
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), (Object)result);
    }

    public Object getUpdateLog() throws Exception {
        String result = SystemInfoService.getDeployUpdateLog();
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), (Object)result);
    }

    public Object getInstallHistory() throws Exception {
        String result = SystemInfoService.getDeployHistory();
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), (Object)result);
    }

    public Object getInstallLog(String version) throws Exception {
        String result = SystemInfoService.getDeployHistory();
        Map installHistory = (Map)DWGsonProvider.getGson().fromJson(result, Map.class);
        List installLogs = (List)installHistory.get("installHistory");
        Map installLog = new HashMap();
        for (int i = 0; i < installLogs.size(); ++i) {
            if (!((Map)installLogs.get(i)).get("deploy_version").equals(version)) continue;
            installLog = (Map)installLogs.get(i);
        }
        if (installLog.isEmpty()) {
            return DWServiceResultBuilder.build((boolean)false, (Object)"\u627e\u4e0d\u5230\u6b64\u7248\u672c\u7684\u5b89\u88dd\u7d00\u9304");
        }
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), installLog);
    }

    public Object getDeployInformation() throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        String version = SystemInfoService.getDeployVersion();
        String installHistory = SystemInfoService.getDeployHistory();
        result.put("version", version);
        result.put("installHistory", installHistory);
        return result;
    }

    public Object getUpdateStatus() throws Exception {
        String result = SystemInfoService.getStatus();
        return DWServiceResultBuilder.build((boolean)true, (String)this.messageSource.getMessage("msg001", null, null), (Object)result);
    }

    private static String getDeployVersion() throws Exception {
        String result = "";
        Object versionFileStr = "";
        if (runningPath.exists()) {
            versionFileStr = SystemInfoService.getUpdatePath() + File.separator + "deploy_version.txt";
        }
        try (BufferedReader br = new BufferedReader(new FileReader((String)versionFileStr));){
            result = br.readLine();
        }
        return result;
    }

    private static String getStatus() throws Exception {
        String result = "";
        Object updateStatus = "";
        if (runningPath.exists()) {
            updateStatus = SystemInfoService.getUpdatePath() + File.separator + "updateStatus.txt";
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((String)updateStatus), "UTF8"));){
            result = br.readLine();
        }
        return result;
    }

    private static String getDeployUpdateLog() throws Exception {
        StringBuilder content = new StringBuilder();
        Object installHistoryFileStr = "";
        if (runningPath.exists()) {
            installHistoryFileStr = SystemInfoService.getUpdatePath() + File.separator + "update.log";
        }
        try (Stream<String> stream = Files.lines(Paths.get((String)installHistoryFileStr, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> content.append((String)s).append("\n"));
        }
        String result = content.toString();
        return result;
    }

    private static String getDeployHistory() throws Exception {
        StringBuilder content = new StringBuilder();
        Object installHistoryFileStr = "";
        if (runningPath.exists()) {
            installHistoryFileStr = SystemInfoService.getUpdatePath() + File.separator + "Install.log";
        }
        try (Stream<String> stream = Files.lines(Paths.get((String)installHistoryFileStr, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> content.append((String)s).append("\n"));
        }
        String result = content.toString();
        return result;
    }

    private static String getInstallPath() {
        return runningPathStr;
    }

    private static String getUpdatePath() {
        return SystemInfoService.getInstallPath() + File.separator + ".." + File.separator + "Digiwin" + File.separator + "Update";
    }
}

