/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.requesthelper.service.pojo;

import com.digiwin.app.container.DWMethod;
import com.digiwin.app.container.local.mock.DWMockMethod;
import com.digiwin.app.service.DWFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MethodInfo
implements Serializable {
    private String name;
    private String method;
    private boolean isMock;
    private boolean allowAnonymous;
    private String description = null;
    private transient List<String> allParameters = new ArrayList<String>();
    private List<String> parameters = new ArrayList<String>();
    private List<String> files = new ArrayList<String>();
    private String signature;
    private String displayName;

    public MethodInfo() {
    }

    public MethodInfo(DWMethod dwMethod) {
        this(dwMethod.getMethodName(), dwMethod.allowAnonymous());
        Map parameters = dwMethod.getParameterInfo();
        for (Map.Entry item : parameters.entrySet()) {
            boolean isFile;
            String parameterName = (String)item.getKey();
            boolean bl = isFile = item.getValue() == DWFile.class;
            if (isFile) {
                this.addFile(parameterName);
                continue;
            }
            this.addParameter(parameterName);
        }
        this.isMock = DWMockMethod.class.isInstance(dwMethod);
        if (this.isMock) {
            this.description = ((DWMockMethod)dwMethod).getMockInfo();
        }
    }

    public MethodInfo(String name, boolean allowAnonymous) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is null or empty!");
        }
        this.name = name;
        this.method = name;
        this.allowAnonymous = allowAnonymous;
    }

    public String getName() {
        return this.name;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isMock() {
        return this.isMock;
    }

    public boolean isIsMock() {
        return this.isMock;
    }

    public boolean getIsMock() {
        return this.isMock;
    }

    public boolean getAllowAnonymous() {
        return this.allowAnonymous;
    }

    public boolean isAllowAnonymous() {
        return this.allowAnonymous;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public List<String> getFiles() {
        return this.files;
    }

    public String getSignature() {
        return this.signature;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void addParameter(String name) {
        this.parameters.add(name);
        this.allParameters.add(name);
    }

    public void addFile(String name) {
        this.files.add(name);
        this.allParameters.add(name);
    }

    protected void refreshInfo() {
        StringBuilder info = new StringBuilder();
        info.append("(").append(StringUtils.join(this.allParameters, (String)", ")).append(")");
        String token = this.allowAnonymous ? "" : "$";
        this.signature = info.toString() + token;
        this.displayName = this.name + this.signature;
        if (this.isMock) {
            this.displayName = this.displayName + "[M]";
        }
    }
}

