/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.platform;

import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.digiwin.apollo.platform.PlatformConfig;
import com.digiwin.apollo.platform.PlatformConfigFile;
import com.digiwin.apollo.platform.build.ApolloInjector;
import com.digiwin.apollo.platform.internals.ConfigManager;
import com.digiwin.apollo.platform.spi.ConfigFactory;
import com.digiwin.apollo.platform.spi.ConfigRegistry;

public class PlatformConfigService {
    private static final PlatformConfigService s_instance = new PlatformConfigService();
    private volatile ConfigManager m_configManager;
    private volatile ConfigRegistry m_configRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigManager getManager() {
        if (this.m_configManager == null) {
            PlatformConfigService platformConfigService = this;
            synchronized (platformConfigService) {
                if (this.m_configManager == null) {
                    this.m_configManager = ApolloInjector.getInstance(ConfigManager.class);
                }
            }
        }
        return this.m_configManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigRegistry getRegistry() {
        if (this.m_configRegistry == null) {
            PlatformConfigService platformConfigService = this;
            synchronized (platformConfigService) {
                if (this.m_configRegistry == null) {
                    this.m_configRegistry = ApolloInjector.getInstance(ConfigRegistry.class);
                }
            }
        }
        return this.m_configRegistry;
    }

    public static PlatformConfig getAppConfig() {
        return PlatformConfigService.getConfig("application");
    }

    public static PlatformConfig getConfig(String namespace) {
        return s_instance.getManager().getConfig(namespace);
    }

    public static PlatformConfigFile getConfigFile(String namespace, ConfigFileFormat configFileFormat) {
        return s_instance.getManager().getConfigFile(namespace, configFileFormat);
    }

    static void setConfig(PlatformConfig config) {
        PlatformConfigService.setConfig("application", config);
    }

    static void setConfig(String namespace, final PlatformConfig config) {
        s_instance.getRegistry().register(namespace, new ConfigFactory(){

            @Override
            public PlatformConfig create(String namespace) {
                return config;
            }

            @Override
            public PlatformConfigFile createConfigFile(String namespace, ConfigFileFormat configFileFormat) {
                return null;
            }
        });
    }

    static void setConfigFactory(ConfigFactory factory) {
        PlatformConfigService.setConfigFactory("application", factory);
    }

    static void setConfigFactory(String namespace, ConfigFactory factory) {
        s_instance.getRegistry().register(namespace, factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        PlatformConfigService platformConfigService = s_instance;
        synchronized (platformConfigService) {
            PlatformConfigService.s_instance.m_configManager = null;
            PlatformConfigService.s_instance.m_configRegistry = null;
        }
    }
}

