/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.foundation;

import com.ctrip.framework.foundation.internals.NullProviderManager;
import com.ctrip.framework.foundation.internals.ServiceBootstrap;
import com.ctrip.framework.foundation.spi.ProviderManager;
import com.ctrip.framework.foundation.spi.provider.ApplicationProvider;
import com.ctrip.framework.foundation.spi.provider.NetworkProvider;
import com.ctrip.framework.foundation.spi.provider.ServerProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Foundation {
    private static final Log logger = LogFactory.getLog(Foundation.class);
    private static Object lock = new Object();
    private static volatile ProviderManager s_manager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProviderManager getManager() {
        try {
            if (s_manager == null) {
                Object object = lock;
                synchronized (object) {
                    if (s_manager == null) {
                        s_manager = ServiceBootstrap.loadFirst(ProviderManager.class);
                    }
                }
            }
            return s_manager;
        }
        catch (Throwable ex) {
            s_manager = new NullProviderManager();
            logger.error((Object)"Initialize ProviderManager failed.", ex);
            return s_manager;
        }
    }

    public static String getProperty(String name, String defaultValue) {
        try {
            return Foundation.getManager().getProperty(name, defaultValue);
        }
        catch (Throwable ex) {
            logger.error((Object)("getProperty for " + name + " failed."), ex);
            return defaultValue;
        }
    }

    public static NetworkProvider net() {
        try {
            return Foundation.getManager().provider(NetworkProvider.class);
        }
        catch (Exception ex) {
            logger.error((Object)"Initialize NetworkProvider failed.", (Throwable)ex);
            return NullProviderManager.provider;
        }
    }

    public static ServerProvider server() {
        try {
            return Foundation.getManager().provider(ServerProvider.class);
        }
        catch (Exception ex) {
            logger.error((Object)"Initialize ServerProvider failed.", (Throwable)ex);
            return NullProviderManager.provider;
        }
    }

    public static ApplicationProvider app() {
        try {
            return Foundation.getManager().provider(ApplicationProvider.class);
        }
        catch (Exception ex) {
            logger.error((Object)"Initialize ApplicationProvider failed.", (Throwable)ex);
            return NullProviderManager.provider;
        }
    }

    static {
        Foundation.getManager();
    }
}

