/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.application.spring.property;

import com.ctrip.framework.apollo.core.utils.ApolloThreadFactory;
import com.digiwin.apollo.application.spring.property.SpringValue;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.BeanFactory;

public class SpringValueRegistry {
    private static final long CLEAN_INTERVAL_IN_SECONDS = 5L;
    private final Map<BeanFactory, Multimap<String, SpringValue>> registry = Maps.newConcurrentMap();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(BeanFactory beanFactory, String key, SpringValue springValue) {
        if (!this.registry.containsKey(beanFactory)) {
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.registry.containsKey(beanFactory)) {
                    this.registry.put(beanFactory, (Multimap<String, SpringValue>)Multimaps.synchronizedListMultimap((ListMultimap)LinkedListMultimap.create()));
                }
            }
        }
        this.registry.get(beanFactory).put((Object)key, (Object)springValue);
        if (this.initialized.compareAndSet(false, true)) {
            this.initialize();
        }
    }

    public Collection<SpringValue> get(BeanFactory beanFactory, String key) {
        Multimap<String, SpringValue> beanFactorySpringValues = this.registry.get(beanFactory);
        if (beanFactorySpringValues == null) {
            return null;
        }
        return beanFactorySpringValues.get((Object)key);
    }

    private void initialize() {
        Executors.newSingleThreadScheduledExecutor(ApolloThreadFactory.create("SpringValueRegistry", true)).scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    SpringValueRegistry.this.scanAndClean();
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }, 5L, 5L, TimeUnit.SECONDS);
    }

    private void scanAndClean() {
        Iterator<Multimap<String, SpringValue>> iterator = this.registry.values().iterator();
        while (!Thread.currentThread().isInterrupted() && iterator.hasNext()) {
            Multimap<String, SpringValue> springValues = iterator.next();
            Iterator springValueIterator = springValues.entries().iterator();
            while (springValueIterator.hasNext()) {
                Map.Entry springValue = (Map.Entry)springValueIterator.next();
                if (((SpringValue)springValue.getValue()).isTargetBeanValid()) continue;
                springValueIterator.remove();
            }
        }
    }
}

