/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.platform.spi;

import com.ctrip.framework.apollo.core.enums.ConfigFileFormat;
import com.digiwin.apollo.platform.PlatformConfig;
import com.digiwin.apollo.platform.PlatformConfigFile;
import com.digiwin.apollo.platform.PlatformConfigService;
import com.digiwin.apollo.platform.PropertiesCompatibleConfigFile;
import com.digiwin.apollo.platform.build.ApolloInjector;
import com.digiwin.apollo.platform.internals.DefaultConfig;
import com.digiwin.apollo.platform.internals.JsonConfigFile;
import com.digiwin.apollo.platform.internals.LocalFileConfigRepository;
import com.digiwin.apollo.platform.internals.PropertiesCompatibleFileConfigRepository;
import com.digiwin.apollo.platform.internals.PropertiesConfigFile;
import com.digiwin.apollo.platform.internals.RemoteConfigRepository;
import com.digiwin.apollo.platform.internals.TxtConfigFile;
import com.digiwin.apollo.platform.internals.XmlConfigFile;
import com.digiwin.apollo.platform.internals.YamlConfigFile;
import com.digiwin.apollo.platform.internals.YmlConfigFile;
import com.digiwin.apollo.platform.spi.ConfigFactory;
import com.digiwin.apollo.platform.util.ConfigUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultConfigFactory
implements ConfigFactory {
    private static final Log logger = LogFactory.getLog(DefaultConfigFactory.class);
    private ConfigUtil m_configUtil = ApolloInjector.getInstance(ConfigUtil.class);

    @Override
    public PlatformConfig create(String namespace) {
        ConfigFileFormat format = this.determineFileFormat(namespace);
        if (ConfigFileFormat.isPropertiesCompatible(format)) {
            return new DefaultConfig(namespace, this.createPropertiesCompatibleFileConfigRepository(namespace, format));
        }
        return new DefaultConfig(namespace, this.createLocalConfigRepository(namespace));
    }

    @Override
    public PlatformConfigFile createConfigFile(String namespace, ConfigFileFormat configFileFormat) {
        LocalFileConfigRepository configRepository = this.createLocalConfigRepository(namespace);
        switch (configFileFormat) {
            case Properties: {
                return new PropertiesConfigFile(namespace, configRepository);
            }
            case XML: {
                return new XmlConfigFile(namespace, configRepository);
            }
            case JSON: {
                return new JsonConfigFile(namespace, configRepository);
            }
            case YAML: {
                return new YamlConfigFile(namespace, configRepository);
            }
            case YML: {
                return new YmlConfigFile(namespace, configRepository);
            }
            case TXT: {
                return new TxtConfigFile(namespace, configRepository);
            }
        }
        return null;
    }

    LocalFileConfigRepository createLocalConfigRepository(String namespace) {
        if (this.m_configUtil.isInLocalMode()) {
            logger.warn((Object)("==== Apollo is in local mode! Won't pull configs from remote server for namespace " + namespace + " ! ===="));
            return new LocalFileConfigRepository(namespace);
        }
        return new LocalFileConfigRepository(namespace, this.createRemoteConfigRepository(namespace));
    }

    RemoteConfigRepository createRemoteConfigRepository(String namespace) {
        return new RemoteConfigRepository(namespace);
    }

    PropertiesCompatibleFileConfigRepository createPropertiesCompatibleFileConfigRepository(String namespace, ConfigFileFormat format) {
        String actualNamespaceName = this.trimNamespaceFormat(namespace, format);
        PropertiesCompatibleConfigFile configFile = (PropertiesCompatibleConfigFile)PlatformConfigService.getConfigFile(actualNamespaceName, format);
        return new PropertiesCompatibleFileConfigRepository(configFile);
    }

    ConfigFileFormat determineFileFormat(String namespaceName) {
        String lowerCase = namespaceName.toLowerCase();
        for (ConfigFileFormat format : ConfigFileFormat.values()) {
            if (!lowerCase.endsWith("." + format.getValue())) continue;
            return format;
        }
        return ConfigFileFormat.Properties;
    }

    String trimNamespaceFormat(String namespaceName, ConfigFileFormat format) {
        String extension = "." + format.getValue();
        if (!namespaceName.toLowerCase().endsWith(extension)) {
            return namespaceName;
        }
        return namespaceName.substring(0, namespaceName.length() - extension.length());
    }
}

