/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.apollo.platform.spring.config;

import com.digiwin.apollo.platform.PlatformConfig;
import com.digiwin.apollo.platform.PlatformConfigService;
import com.digiwin.apollo.platform.build.ApolloInjector;
import com.digiwin.apollo.platform.spring.config.ConfigPropertySource;
import com.digiwin.apollo.platform.spring.config.ConfigPropertySourceFactory;
import com.digiwin.apollo.platform.spring.property.AutoUpdateConfigChangeListener;
import com.digiwin.apollo.platform.spring.util.SpringInjector;
import com.digiwin.apollo.platform.util.ConfigUtil;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class PropertySourcesProcessor
implements BeanFactoryPostProcessor,
EnvironmentAware,
PriorityOrdered {
    private static final Multimap<Integer, String> NAMESPACE_NAMES = LinkedHashMultimap.create();
    private static final Set<BeanFactory> AUTO_UPDATE_INITIALIZED_BEAN_FACTORIES = Sets.newConcurrentHashSet();
    private final ConfigPropertySourceFactory configPropertySourceFactory = SpringInjector.getInstance(ConfigPropertySourceFactory.class);
    private final ConfigUtil configUtil = ApolloInjector.getInstance(ConfigUtil.class);
    private ConfigurableEnvironment environment;

    public static boolean addNamespaces(Collection<String> namespaces, int order) {
        return NAMESPACE_NAMES.putAll((Object)order, namespaces);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.initializePropertySources();
        this.initializeAutoUpdatePropertiesFeature(beanFactory);
    }

    private void initializePropertySources() {
        if (this.environment.getPropertySources().contains("ApolloPropertySources")) {
            return;
        }
        CompositePropertySource composite = new CompositePropertySource("ApolloPropertySources");
        ImmutableSortedSet orders = ImmutableSortedSet.copyOf((Collection)NAMESPACE_NAMES.keySet());
        UnmodifiableIterator iterator = orders.iterator();
        while (iterator.hasNext()) {
            int order = (Integer)iterator.next();
            for (String namespace : NAMESPACE_NAMES.get((Object)order)) {
                PlatformConfig config = PlatformConfigService.getConfig(namespace);
                composite.addPropertySource((PropertySource)this.configPropertySourceFactory.getConfigPropertySource(namespace, config));
            }
        }
        NAMESPACE_NAMES.clear();
        if (this.environment.getPropertySources().contains("ApolloBootstrapPropertySources")) {
            this.ensureBootstrapPropertyPrecedence(this.environment);
            this.environment.getPropertySources().addAfter("ApolloBootstrapPropertySources", (PropertySource)composite);
        } else {
            this.environment.getPropertySources().addFirst((PropertySource)composite);
        }
    }

    private void ensureBootstrapPropertyPrecedence(ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = environment.getPropertySources();
        PropertySource bootstrapPropertySource = propertySources.get("ApolloBootstrapPropertySources");
        if (bootstrapPropertySource == null || propertySources.precedenceOf(bootstrapPropertySource) == 0) {
            return;
        }
        propertySources.remove("ApolloBootstrapPropertySources");
        propertySources.addFirst(bootstrapPropertySource);
    }

    private void initializeAutoUpdatePropertiesFeature(ConfigurableListableBeanFactory beanFactory) {
        if (!this.configUtil.isAutoUpdateInjectedSpringPropertiesEnabled() || !AUTO_UPDATE_INITIALIZED_BEAN_FACTORIES.add((BeanFactory)beanFactory)) {
            return;
        }
        AutoUpdateConfigChangeListener autoUpdateConfigChangeListener = new AutoUpdateConfigChangeListener((Environment)this.environment, beanFactory);
        List<ConfigPropertySource> configPropertySources = this.configPropertySourceFactory.getAllConfigPropertySources();
        for (ConfigPropertySource configPropertySource : configPropertySources) {
            configPropertySource.addChangeListener(autoUpdateConfigChangeListener);
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    static void reset() {
        NAMESPACE_NAMES.clear();
        AUTO_UPDATE_INITIALIZED_BEAN_FACTORIES.clear();
    }
}

